/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client.data;

import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.reviewdb.Change;
import java.sql.Timestamp;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.data.GerritPerson;

public class GerritQueryResult {
    private int _number;
    private String branch;
    private Timestamp created;
    private String id;
    private GerritPerson owner;
    private String project;
    private String status;
    private String subject;
    private Timestamp updated;

    public GerritQueryResult(ChangeInfo changeInfo) {
        this.setNumber(changeInfo.getId().get());
        this.setId(changeInfo.getKey().get());
        this.setProject(changeInfo.getProject().getName());
        this.setSubject(changeInfo.getSubject());
        Change.Status status = changeInfo.getStatus();
        if (GerritUtil.isDraft(status)) {
            this.setStatus("DRAFT");
        } else {
            this.setStatus(status.toString());
        }
        this.setUpdated(changeInfo.getLastUpdatedOn());
    }

    public GerritQueryResult() {
    }

    public String getBranch() {
        return this.branch;
    }

    public Timestamp getCreated() {
        return this.created;
    }

    public String getId() {
        return this.id;
    }

    public int getNumber() {
        return this._number;
    }

    public GerritPerson getOwner() {
        return this.owner;
    }

    public String getProject() {
        return this.project;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSubject() {
        return this.subject;
    }

    public Timestamp getUpdated() {
        return this.updated;
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setNumber(int number) {
        this._number = number;
    }

    private void setProject(String project) {
        this.project = project;
    }

    private void setStatus(String status) {
        this.status = status;
    }

    private void setSubject(String subject) {
        this.subject = subject;
    }

    private void setUpdated(Timestamp updated) {
        this.updated = updated;
    }
}

