/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.remote;

import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.CommentDetail;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchLineComment;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.ReviewItemCache;
import org.eclipse.mylyn.internal.gerrit.core.client.PatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.remote.GerritRemoteFactoryProvider;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.core.model.IRepository;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.AbstractRemoteEmfFactoryProvider;
import org.eclipse.mylyn.reviews.core.spi.remote.review.ReviewItemSetContentRemoteFactory;
import org.eclipse.osgi.util.NLS;

public abstract class PatchSetContentRemoteFactory<RemoteKeyType>
extends ReviewItemSetContentRemoteFactory<PatchSetContent, RemoteKeyType> {
    private final ReviewItemCache cache;
    private final GerritRemoteFactoryProvider gerritFactoryProvider;

    public PatchSetContentRemoteFactory(GerritRemoteFactoryProvider gerritRemoteFactoryProvider) {
        super((AbstractRemoteEmfFactoryProvider)gerritRemoteFactoryProvider);
        this.gerritFactoryProvider = gerritRemoteFactoryProvider;
        this.cache = new ReviewItemCache();
    }

    public PatchSetContent pull(IReviewItemSet parentObject, PatchSetContent content, IProgressMonitor monitor) throws CoreException {
        this.gerritFactoryProvider.getClient().loadPatchSetContent(content, monitor);
        if (parentObject.getReview() == null) {
            return content;
        }
        for (Patch patch : content.getTargetDetail().getPatches()) {
            PatchScript patchScript = content.getPatchScript(patch.getKey());
            CommentDetail commentDetail = patchScript.getCommentDetail();
            ArrayList comments = new ArrayList();
            comments.addAll(commentDetail.getCommentsA());
            comments.addAll(commentDetail.getCommentsB());
            for (PatchLineComment comment : comments) {
                this.gerritFactoryProvider.pullUser(parentObject.getReview().getRepository(), patchScript.getCommentDetail().getAccounts(), comment.getAuthor(), monitor);
            }
        }
        return content;
    }

    boolean addComments(IReviewItemSet set, IFileVersion version, List<PatchLineComment> comments, AccountInfoCache accountInfoCache) {
        version.getComments().clear();
        if (version == null || comments == null || comments.isEmpty()) {
            return false;
        }
        boolean changed = comments.size() != version.getComments().size();
        int oldDraftCount = version.getDrafts().size();
        int draftCount = 0;
        for (PatchLineComment gerritComment : comments) {
            ILineRange line = IReviewsFactory.INSTANCE.createLineRange();
            line.setStart(gerritComment.getLine());
            line.setEnd(gerritComment.getLine());
            ILineLocation location = IReviewsFactory.INSTANCE.createLineLocation();
            location.getRanges().add(line);
            IComment comment = IReviewsFactory.INSTANCE.createComment();
            IUser author = this.getGerritProvider().createUser((IRepository)this.getGerritProvider().getRoot(), accountInfoCache, gerritComment.getAuthor());
            comment.setId(gerritComment.getKey().get());
            comment.setCreationDate((Date)gerritComment.getWrittenOn());
            comment.setTitle(GerritUtil.shortenText(gerritComment.getMessage(), 10, 20));
            comment.setDescription(gerritComment.getMessage());
            comment.setDraft(PatchLineComment.Status.DRAFT == gerritComment.getStatus());
            if (comment.isDraft()) {
                ++draftCount;
            }
            comment.setAuthor(author);
            comment.getLocations().add(location);
            version.getComments().add(comment);
        }
        return changed |= draftCount != oldDraftCount;
    }

    public boolean isPullNeeded(IReviewItemSet parent, List<IFileItem> items, PatchSetContent remote) {
        return true;
    }

    public List<IFileItem> createModel(IReviewItemSet set, PatchSetContent content) {
        List items = set.getItems();
        for (Patch patch : content.getTargetDetail().getPatches()) {
            String targetId = patch.getKey().toString();
            String sourceFileName = patch.getSourceFileName() != null ? patch.getSourceFileName() : patch.getFileName();
            String baseId = content.getBase() != null ? new Patch.Key(content.getBase().getId(), sourceFileName).toString() : "base-" + targetId;
            String id = String.valueOf(baseId) + ":" + targetId;
            IFileItem item = (IFileItem)this.getCache().getItem(id);
            if (item == null) {
                item = IReviewsFactory.INSTANCE.createFileItem();
                item.setId(id);
                item.setName(patch.getFileName());
                item.setAddedBy(set.getAddedBy());
                item.setCommittedBy(set.getCommittedBy());
                item.setReference(patch.getKey().getParentKey() + "," + patch.getFileName());
                this.getCache().put((IReviewItem)item);
            }
            items.add(item);
            PatchScript patchScript = content.getPatchScript(patch.getKey());
            if (patchScript == null) continue;
            IFileVersion baseVersion = (IFileVersion)this.getCache().getItem(baseId);
            if (baseVersion == null) {
                baseVersion = IReviewsFactory.INSTANCE.createFileVersion();
                baseVersion.setId(baseId);
                baseVersion.setContent(patchScript.getA().asString());
                baseVersion.setPath(patchScript.getA().getPath());
                baseVersion.setDescription(content.getBase() != null ? NLS.bind((String)"Patch Set {0}", (Object)content.getBase().getPatchSetId()) : "Base");
                baseVersion.setFile(item);
                baseVersion.setName(item.getName());
                this.getCache().put((IReviewItem)baseVersion);
            }
            item.setBase(baseVersion);
            IFileVersion targetVersion = (IFileVersion)this.getCache().getItem(targetId);
            if (targetVersion == null) {
                targetVersion = IReviewsFactory.INSTANCE.createFileVersion();
                targetVersion.setId(targetId);
                SparseFileContent target = patchScript.getB().apply(patchScript.getA(), patchScript.getEdits());
                targetVersion.setContent(target.asString());
                targetVersion.setPath(patchScript.getB().getPath());
                targetVersion.setDescription(NLS.bind((String)"Patch Set {0}", (Object)content.getTargetDetail().getPatchSet().getPatchSetId()));
                targetVersion.setFile(item);
                targetVersion.setAddedBy(item.getAddedBy());
                targetVersion.setCommittedBy(item.getCommittedBy());
                targetVersion.setName(item.getName());
                this.getCache().put((IReviewItem)targetVersion);
            }
            item.setTarget(targetVersion);
        }
        return items;
    }

    public boolean isCreateModelNeeded(IReviewItemSet set, List<IFileItem> items) {
        return super.isCreateModelNeeded((EObject)set, items) || items == null || items.isEmpty();
    }

    public boolean updateModel(IReviewItemSet set, List<IFileItem> items, PatchSetContent content) {
        if (set.getReview() == null) {
            return false;
        }
        boolean changed = false;
        Iterator<IFileItem> iterator = items.iterator();
        while (iterator.hasNext()) {
            IFileItem item;
            IFileItem fileItem = item = iterator.next();
            PatchScript patchScript = content.getPatchScript(Patch.Key.parse((String)item.getReference()));
            if (patchScript == null) continue;
            CommentDetail commentDetail = patchScript.getCommentDetail();
            changed |= this.addComments(set, fileItem.getBase(), commentDetail.getCommentsA(), commentDetail.getAccounts());
            changed |= this.addComments(set, fileItem.getTarget(), commentDetail.getCommentsB(), commentDetail.getAccounts());
        }
        if (changed) {
            this.getGerritProvider().save((EObject)set.getReview());
        }
        return changed;
    }

    public GerritRemoteFactoryProvider getGerritProvider() {
        return this.gerritFactoryProvider;
    }

    protected List<IFileItem> open(IReviewItemSet parentObject, String localKey) {
        return parentObject.getItems();
    }

    public String getLocalKey(IReviewItemSet parentObject, List<IFileItem> modelObject) {
        return parentObject.getId();
    }

    public ReviewItemCache getCache() {
        return this.cache;
    }

    public String getModelDescription(IReviewItemSet set, List<IFileItem> items, String localKey) {
        if (set.getReview() != null) {
            return "Review " + set.getReview().getId() + ", Patch Set " + set.getId();
        }
        return set.getName();
    }
}

