/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.trac.tests.support;

import java.net.Proxy;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.IProxyProvider;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.FixtureConfiguration;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.internal.trac.core.TracClientFactory;
import org.eclipse.mylyn.internal.trac.core.TracCorePlugin;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tests.util.TestFixture;
import org.eclipse.mylyn.trac.tests.support.TracHarness;

public class TracFixture
extends TestFixture {
    public static String TAG_MISC = "misc";
    public static final String TAG_TEST = "test";
    private static TracFixture current;
    private final ITracClient.Version accessMode;
    private final String version;
    private final Set<String> tags;

    public static TracFixture current() {
        if (current == null) {
            current = (TracFixture)((Object)TestConfiguration.getDefault().discoverDefault(TracFixture.class, "trac"));
            current.activate();
        }
        return current;
    }

    public TracFixture(ITracClient.Version accessMode, String url, String version, String info) {
        super("trac", url);
        Assert.isNotNull((Object)accessMode);
        Assert.isNotNull((Object)info);
        this.accessMode = accessMode;
        this.version = version;
        this.tags = new HashSet<String>();
        this.setInfo("Trac", version, info);
    }

    public TracFixture(FixtureConfiguration configuration) {
        this(ITracClient.Version.fromVersion((String)((String)configuration.getProperties().get("version"))), configuration.getUrl(), configuration.getVersion(), configuration.getInfo());
        if (configuration.getTags() != null) {
            this.tags.addAll(configuration.getTags());
        }
    }

    public TracFixture activate() {
        current = this;
        this.setUpFramework();
        return this;
    }

    protected TestFixture getDefault() {
        return (TestFixture)TestConfiguration.getDefault().discoverDefault(TracFixture.class, "trac");
    }

    public ITracClient connect() throws Exception {
        return this.connect(this.repositoryUrl);
    }

    public ITracClient connectXmlRpc(CommonTestUtil.PrivilegeLevel level) throws Exception {
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)level);
        return this.connect(this.repositoryUrl, credentials.getUserName(), credentials.getPassword(), this.getDefaultProxy(this.repositoryUrl), ITracClient.Version.XML_RPC);
    }

    private Proxy getDefaultProxy(String url) {
        return WebUtil.getProxyForUrl((String)url);
    }

    public ITracClient connect(String url) throws Exception {
        return this.connect(url, this.getDefaultProxy(url), CommonTestUtil.PrivilegeLevel.USER);
    }

    public ITracClient connect(String url, Proxy proxy, CommonTestUtil.PrivilegeLevel level) throws Exception {
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)level);
        return this.connect(url, credentials.getUserName(), credentials.getPassword(), proxy);
    }

    public ITracClient connect(String url, String username, String password) throws Exception {
        return this.connect(url, username, password, this.getDefaultProxy(url));
    }

    public ITracClient connect(String url, String username, String password, Proxy proxy) throws Exception {
        return this.connect(url, username, password, proxy, this.accessMode);
    }

    public ITracClient connect(String url, String username, String password, final Proxy proxy, ITracClient.Version version) throws Exception {
        WebLocation location = new WebLocation(url, username, password, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return proxy;
            }
        });
        return TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)version);
    }

    public ITracClient.Version getAccessMode() {
        return this.accessMode;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isXmlRpcEnabled() {
        return ITracClient.Version.XML_RPC.name().equals(this.getAccessMode());
    }

    public TaskRepository singleRepository(TracRepositoryConnector connector) {
        connector.getClientManager().writeCache();
        TaskRepository repository = super.singleRepository();
        connector.getClientManager().clearClients();
        connector.getClientManager().readCache();
        return repository;
    }

    public TaskRepository singleRepository() {
        return this.singleRepository(this.connector());
    }

    protected void configureRepository(TaskRepository repository) {
        repository.setTimeZoneId("UTC");
        repository.setCharacterEncoding("UTF-8");
        repository.setVersion(this.accessMode.name());
    }

    protected void resetRepositories() {
        TracCorePlugin.getDefault().getConnector().getClientManager().clearClients();
    }

    public TracRepositoryConnector connector() {
        return (TracRepositoryConnector)super.connector();
    }

    public TracHarness createHarness() {
        return new TracHarness(this);
    }

    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    public boolean requiresAuthentication() {
        return this.getInfo().contains("AllBasicAuth");
    }
}

