/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.epub.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.mylyn.docs.epub.core.ILogger;
import org.eclipse.mylyn.docs.epub.core.Messages;
import org.eclipse.mylyn.docs.epub.core.OPS2Publication;
import org.eclipse.mylyn.docs.epub.core.ValidationException;
import org.eclipse.mylyn.docs.epub.core.ValidationMessage;
import org.eclipse.mylyn.docs.epub.dc.Contributor;
import org.eclipse.mylyn.docs.epub.dc.Coverage;
import org.eclipse.mylyn.docs.epub.dc.Creator;
import org.eclipse.mylyn.docs.epub.dc.DCFactory;
import org.eclipse.mylyn.docs.epub.dc.DCType;
import org.eclipse.mylyn.docs.epub.dc.Date;
import org.eclipse.mylyn.docs.epub.dc.Description;
import org.eclipse.mylyn.docs.epub.dc.Format;
import org.eclipse.mylyn.docs.epub.dc.Identifier;
import org.eclipse.mylyn.docs.epub.dc.Language;
import org.eclipse.mylyn.docs.epub.dc.LocalizedDCType;
import org.eclipse.mylyn.docs.epub.dc.Publisher;
import org.eclipse.mylyn.docs.epub.dc.Relation;
import org.eclipse.mylyn.docs.epub.dc.Rights;
import org.eclipse.mylyn.docs.epub.dc.Source;
import org.eclipse.mylyn.docs.epub.dc.Subject;
import org.eclipse.mylyn.docs.epub.dc.Title;
import org.eclipse.mylyn.docs.epub.dc.Type;
import org.eclipse.mylyn.docs.epub.opf.Item;
import org.eclipse.mylyn.docs.epub.opf.Itemref;
import org.eclipse.mylyn.docs.epub.opf.Meta;
import org.eclipse.mylyn.docs.epub.opf.OPFFactory;
import org.eclipse.mylyn.docs.epub.opf.OPFPackage;
import org.eclipse.mylyn.docs.epub.opf.Package;
import org.eclipse.mylyn.docs.epub.opf.Reference;
import org.eclipse.mylyn.docs.epub.opf.Role;
import org.eclipse.mylyn.docs.epub.opf.Spine;
import org.eclipse.mylyn.docs.epub.opf.util.OPFResourceImpl;
import org.eclipse.mylyn.docs.epub.opf.util.OPFValidator;
import org.eclipse.mylyn.internal.docs.epub.core.EPUBFileUtil;
import org.eclipse.mylyn.internal.docs.epub.core.EPUBXMLHelperImp;
import org.eclipse.mylyn.internal.docs.epub.core.ReferenceScanner;
import org.xml.sax.SAXException;

public abstract class OPSPublication {
    private static final String COVER_ID = "cover";
    public static final String COVER_IMAGE_ID = "cover-image";
    protected static final String CREATION_DATE_ID = "creation";
    private static final String EMPTY_STRING = "";
    public static final String MIMETYPE_CSS = "text/css";
    public static final String MIMETYPE_XHTML = "application/xhtml+xml";
    private static final String OPF_FILE_SUFFIX = "opf";
    protected static final String UUID_SCHEME = "uuid";
    protected static final String XML_ENCODING = "UTF-8";
    protected int indent = 0;
    protected ILogger logger;
    protected List<ValidationMessage> messages;
    protected Package opfPackage = OPFFactory.eINSTANCE.createPackage();
    private File rootFolder;

    public static OPSPublication getVersion2Instance() {
        return new OPS2Publication();
    }

    public static OPSPublication getVersion2Instance(ILogger logger) {
        return new OPS2Publication(logger);
    }

    protected OPSPublication() {
        this.registerOPFResourceFactory();
    }

    protected OPSPublication(ILogger logger) {
        this();
        this.logger = logger;
        this.log(MessageFormat.format(Messages.getString("OPSPublication.0"), this.getVersion()), ILogger.Severity.INFO, this.indent++);
    }

    private void addCompulsoryData() {
        this.log(Messages.getString("OPSPublication.1"), ILogger.Severity.VERBOSE, this.indent++);
        this.addDate(null, new java.util.Date(System.currentTimeMillis()), CREATION_DATE_ID);
        this.addContributor(null, null, "Eclipse Mylyn Docs project", Role.REDACTOR, null);
        if (this.getIdentifier() == null) {
            this.addIdentifier(UUID_SCHEME, UUID_SCHEME, "urn:uuid" + UUID.randomUUID().toString());
            this.setIdentifierId(UUID_SCHEME);
        }
        if (this.opfPackage.getMetadata().getSubjects().isEmpty()) {
            this.addSubject(null, null, EMPTY_STRING);
        }
        if (this.opfPackage.getMetadata().getLanguages().isEmpty()) {
            this.addLanguage(null, Locale.ENGLISH.toString());
        }
        if (this.opfPackage.getMetadata().getTitles().isEmpty()) {
            this.addTitle(null, null, "No title specified");
        }
        if (this.opfPackage.getMetadata().getFormats().isEmpty()) {
            this.addFormat(null, "application/epub+zip");
        }
        --this.indent;
    }

    public Contributor addContributor(String id, Locale lang, String name, Role role, String fileAs) {
        this.log(MessageFormat.format(Messages.getString("OPSPublication.2"), new Object[]{name, role, lang == null ? Messages.getString("OPSPublication.3") : lang.getDisplayName()}), ILogger.Severity.VERBOSE, this.indent);
        Contributor dc = DCFactory.eINSTANCE.createContributor();
        this.setDcLocalized(dc, id, lang, name);
        if (role != null) {
            dc.setRole(role);
        }
        if (fileAs != null) {
            dc.setFileAs(fileAs);
        }
        this.opfPackage.getMetadata().getContributors().add((Object)dc);
        return dc;
    }

    public Coverage addCoverage(String id, Locale lang, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        Coverage dc = DCFactory.eINSTANCE.createCoverage();
        this.setDcLocalized(dc, id, lang, value);
        this.opfPackage.getMetadata().getCoverages().add((Object)dc);
        return dc;
    }

    public Creator addCreator(String id, Locale lang, String name, Role role, String fileAs) {
        this.log(MessageFormat.format(Messages.getString("OPSPublication.4"), new Object[]{name, role, lang == null ? Messages.getString("OPSPublication.3") : lang.getDisplayName()}), ILogger.Severity.VERBOSE, this.indent);
        Creator dc = DCFactory.eINSTANCE.createCreator();
        this.setDcLocalized(dc, id, lang, name);
        if (role != null) {
            dc.setRole(role);
        }
        if (fileAs != null) {
            dc.setFileAs(fileAs);
        }
        this.opfPackage.getMetadata().getCreators().add((Object)dc);
        return dc;
    }

    public Date addDate(String id, java.util.Date date, String event) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        Date dc = DCFactory.eINSTANCE.createDate();
        this.setDcCommon(dc, id, df.format(date));
        if (event != null) {
            dc.setEvent(event);
        }
        this.opfPackage.getMetadata().getDates().add((Object)dc);
        return dc;
    }

    public Date addDate(String id, String value, String event) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        Date dc = DCFactory.eINSTANCE.createDate();
        this.setDcCommon(dc, id, value);
        if (event != null) {
            dc.setEvent(event);
        }
        this.opfPackage.getMetadata().getDates().add((Object)dc);
        return dc;
    }

    public Description addDescription(String id, Locale lang, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        this.log(MessageFormat.format(Messages.getString("OPSPublication.6"), value, lang == null ? Messages.getString("OPSPublication.3") : lang), ILogger.Severity.VERBOSE, this.indent);
        Description dc = DCFactory.eINSTANCE.createDescription();
        this.setDcLocalized(dc, id, lang, value);
        this.opfPackage.getMetadata().getDescriptions().add((Object)dc);
        return dc;
    }

    public Format addFormat(String id, String value) {
        Format dc = DCFactory.eINSTANCE.createFormat();
        this.setDcCommon(dc, id, value);
        this.opfPackage.getMetadata().getFormats().add((Object)dc);
        return dc;
    }

    public Identifier addIdentifier(String id, String scheme, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        Identifier dc = DCFactory.eINSTANCE.createIdentifier();
        dc.setId(id);
        dc.setScheme(scheme);
        FeatureMapUtil.addText((FeatureMap)dc.getMixed(), (String)value);
        this.opfPackage.getMetadata().getIdentifiers().add((Object)dc);
        return dc;
    }

    public Item addItem(File file) {
        return this.addItem(null, null, file, null, null, true, true, false);
    }

    public Item addItem(String id, Locale lang, File file, String dest, String type, boolean spine, boolean linear, boolean noToc) {
        if (file == null) {
            throw new IllegalArgumentException("\"file\" must be specified");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("\"file\" " + file.getAbsolutePath() + " must exist.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("\"file\" " + file.getAbsolutePath() + " must not be a directory.");
        }
        Item item = OPFFactory.eINSTANCE.createItem();
        if (type == null && (type = EPUBFileUtil.getMimeType(file)) == null) {
            throw new IllegalArgumentException("Could not automatically determine MIME type for file " + file + ". Please specify the correct value");
        }
        if (id == null) {
            String prefix = EMPTY_STRING;
            if (!type.equals(MIMETYPE_XHTML)) {
                prefix = type.indexOf(47) == -1 ? type : String.valueOf(type.substring(0, type.indexOf(47))) + '-';
            }
            id = String.valueOf(prefix) + file.getName().substring(0, file.getName().lastIndexOf(46));
        }
        item.setId(id);
        if (dest == null) {
            item.setHref(file.getName());
        } else {
            item.setHref(String.valueOf(dest) + '/' + file.getName());
        }
        item.setNoToc(noToc);
        item.setMedia_type(type);
        item.setFile(file.getAbsolutePath());
        this.log(MessageFormat.format(Messages.getString("OPSPublication.8"), item.getHref(), item.getMedia_type()), ILogger.Severity.VERBOSE, this.indent);
        this.opfPackage.getManifest().getItems().add((Object)item);
        if (spine) {
            Itemref ref = OPFFactory.eINSTANCE.createItemref();
            if (!linear) {
                ref.setLinear("no");
            }
            ref.setIdref(id);
            this.getSpine().getSpineItems().add((Object)ref);
        }
        return item;
    }

    public Language addLanguage(String id, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        Language dc = DCFactory.eINSTANCE.createLanguage();
        this.setDcCommon(dc, id, value);
        this.opfPackage.getMetadata().getLanguages().add((Object)dc);
        return dc;
    }

    public Meta addMeta(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("A name must be specified");
        }
        Meta opf = OPFFactory.eINSTANCE.createMeta();
        opf.setName(name);
        opf.setContent(value);
        this.opfPackage.getMetadata().getMetas().add((Object)opf);
        return opf;
    }

    public Publisher addPublisher(String id, Locale lang, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        this.log(MessageFormat.format(Messages.getString("OPSPublication.9"), value, lang == null ? Messages.getString("OPSPublication.3") : lang.getDisplayName()), ILogger.Severity.VERBOSE, this.indent);
        Publisher dc = DCFactory.eINSTANCE.createPublisher();
        this.setDcLocalized(dc, id, lang, value);
        this.opfPackage.getMetadata().getPublishers().add((Object)dc);
        return dc;
    }

    public Reference addReference(String href, String title, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        if (href == null) {
            throw new IllegalArgumentException("A href must be specified");
        }
        this.log(MessageFormat.format(Messages.getString("OPSPublication.11"), value, title, href), ILogger.Severity.VERBOSE, this.indent);
        Reference reference = OPFFactory.eINSTANCE.createReference();
        reference.setHref(href);
        reference.setTitle(title);
        reference.setType(value);
        this.opfPackage.getGuide().getGuideItems().add((Object)reference);
        return reference;
    }

    public Relation addRelation(String id, Locale lang, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        this.log(MessageFormat.format(Messages.getString("OPSPublication.12"), value, lang == null ? Messages.getString("OPSPublication.3") : lang.getDisplayName()), ILogger.Severity.VERBOSE, this.indent);
        Relation dc = DCFactory.eINSTANCE.createRelation();
        this.setDcLocalized(dc, id, lang, value);
        this.opfPackage.getMetadata().getRelations().add((Object)dc);
        return dc;
    }

    public Rights addRights(String id, Locale lang, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        this.log(MessageFormat.format(Messages.getString("OPSPublication.14"), value, lang == null ? Messages.getString("OPSPublication.3") : lang.getDisplayName()), ILogger.Severity.VERBOSE, this.indent);
        Rights dc = DCFactory.eINSTANCE.createRights();
        this.setDcLocalized(dc, id, lang, value);
        this.opfPackage.getMetadata().getRights().add((Object)dc);
        return dc;
    }

    public Source addSource(String id, Locale lang, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        this.log(MessageFormat.format(Messages.getString("OPSPublication.16"), value, lang == null ? Messages.getString("OPSPublication.3") : lang.getDisplayName()), ILogger.Severity.VERBOSE, this.indent);
        Source dc = DCFactory.eINSTANCE.createSource();
        this.setDcLocalized(dc, id, lang, value);
        this.opfPackage.getMetadata().getSources().add((Object)dc);
        return dc;
    }

    public Subject addSubject(String id, Locale lang, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        this.log(MessageFormat.format(Messages.getString("OPSPublication.18"), value, lang == null ? Messages.getString("OPSPublication.3") : lang.getDisplayName()), ILogger.Severity.VERBOSE, this.indent);
        Subject dc = DCFactory.eINSTANCE.createSubject();
        this.setDcLocalized(dc, id, lang, value);
        this.opfPackage.getMetadata().getSubjects().add((Object)dc);
        return dc;
    }

    public Title addTitle(String id, Locale lang, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        this.log(MessageFormat.format(Messages.getString("OPSPublication.20"), value, lang == null ? Messages.getString("OPSPublication.3") : lang.getDisplayName()), ILogger.Severity.VERBOSE, this.indent);
        Title dc = DCFactory.eINSTANCE.createTitle();
        this.setDcLocalized(dc, id, lang, value);
        this.opfPackage.getMetadata().getTitles().add((Object)dc);
        return dc;
    }

    public Type addType(String id, String value) {
        if (value == null) {
            throw new IllegalArgumentException("A value must be specified");
        }
        Type dc = DCFactory.eINSTANCE.createType();
        this.setDcCommon(dc, id, value);
        this.opfPackage.getMetadata().getTypes().add((Object)dc);
        return dc;
    }

    protected abstract void generateTableOfContents() throws Exception;

    public Identifier getIdentifier() {
        EList<Identifier> identifiers = this.opfPackage.getMetadata().getIdentifiers();
        for (Identifier identifier : identifiers) {
            if (!identifier.getId().equals(this.opfPackage.getUniqueIdentifier())) continue;
            return identifier;
        }
        return null;
    }

    public Item getItemById(String id) {
        EList<Item> items = this.opfPackage.getManifest().getItems();
        for (Item item : items) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public List<Item> getItemsByMIMEType(String mimetype) {
        ArrayList<Item> stylesheets = new ArrayList<Item>();
        EList<Item> items = this.opfPackage.getManifest().getItems();
        for (Item item : items) {
            if (!item.getMedia_type().equals(mimetype)) continue;
            stylesheets.add(item);
        }
        return stylesheets;
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }

    public Package getOpfPackage() {
        return this.opfPackage;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    protected Spine getSpine() {
        return this.opfPackage.getSpine();
    }

    public abstract Object getTableOfContents();

    public List<ValidationMessage> getValidationMessages() {
        return this.messages;
    }

    protected abstract String getVersion();

    private void includeReferencedResources() throws ParserConfigurationException, SAXException, IOException {
        this.log(Messages.getString("OPSPublication.23"), ILogger.Severity.INFO, this.indent++);
        EList<Item> manifestItems = this.opfPackage.getManifest().getItems();
        HashMap<File, List<File>> references = new HashMap<File, List<File>>();
        for (Item item : manifestItems) {
            if (item.getMedia_type().equals(MIMETYPE_XHTML) && !item.isGenerated()) {
                File source = null;
                if (item.getSourcePath() != null) {
                    source = new File(item.getSourcePath());
                    this.log(MessageFormat.format(Messages.getString("OPSPublication.24"), source), ILogger.Severity.VERBOSE, this.indent);
                    references.put(source, ReferenceScanner.parse(item));
                } else {
                    source = new File(item.getFile());
                    this.log(MessageFormat.format(Messages.getString("OPSPublication.25"), source), ILogger.Severity.VERBOSE, this.indent);
                }
                references.put(source, ReferenceScanner.parse(item));
                continue;
            }
            this.log(MessageFormat.format(Messages.getString("OPSPublication.26"), item.getFile()), ILogger.Severity.DEBUG, this.indent);
        }
        --this.indent;
        for (File root : references.keySet()) {
            List files = (List)references.get(root);
            for (File file : files) {
                File relativePath = new File(EPUBFileUtil.getRelativePath(root, file));
                if (relativePath.isAbsolute()) {
                    relativePath = new File(EMPTY_STRING);
                }
                boolean add = true;
                EList<Item> items = this.getOpfPackage().getManifest().getItems();
                for (Item item : items) {
                    if (!item.getFile().equals(file.getAbsolutePath())) continue;
                    add = false;
                }
                if (!add) continue;
                try {
                    this.addItem(null, null, file, relativePath.getParent(), null, false, false, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not add file referenced from \"" + root + "\"", e);
                }
            }
        }
        --this.indent;
    }

    protected void log(String message, ILogger.Severity severity, int indent) {
        if (this.logger != null) {
            if (indent == 0) {
                this.logger.log(message, severity);
            } else {
                StringBuilder sb = new StringBuilder(message);
                int i = 0;
                while (i < indent) {
                    sb.insert(0, "  ");
                    ++i;
                }
                this.logger.log(sb.toString(), severity);
            }
        }
    }

    void pack(File rootFile) throws IOException, ValidationException, ParserConfigurationException, SAXException {
        if (this.opfPackage.getSpine().getSpineItems().isEmpty()) {
            throw new ValidationException("Spine does not contain any items");
        }
        if (this.opfPackage.isIncludeReferencedResources()) {
            this.includeReferencedResources();
        }
        this.addCompulsoryData();
        this.rootFolder = rootFile.getAbsoluteFile().getParentFile();
        if (this.rootFolder.isDirectory() || this.rootFolder.mkdirs()) {
            Iterator<Diagnostic> iterator;
            this.messages = this.validateContents();
            this.log(Messages.getString("OPSPublication.5"), ILogger.Severity.INFO, this.indent);
            ++this.indent;
            for (ValidationMessage validation : this.messages) {
                switch (validation.getSeverity()) {
                    case ERROR: {
                        throw new ValidationException(validation.getMessage());
                    }
                    case WARNING: {
                        this.log(validation.getMessage(), ILogger.Severity.WARNING, this.indent);
                        break;
                    }
                }
            }
            --this.indent;
            List<Diagnostic> problems = this.validateMetadata();
            if (problems.size() > 0 && (iterator = problems.iterator()).hasNext()) {
                Diagnostic diagnostic = iterator.next();
                throw new ValidationException(diagnostic.getMessage());
            }
            if (this.opfPackage.isGenerateCoverHTML()) {
                this.writeCoverHTML(this.rootFolder);
            }
        } else {
            throw new IOException("Could not create OEBPS folder in " + this.rootFolder.getAbsolutePath());
        }
        this.writeContent(this.rootFolder);
        this.writeTableOfContents(this.rootFolder);
        this.writeOPF(rootFile);
    }

    protected void readOPF(File rootFile) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)rootFile.getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.load(null);
        this.opfPackage = (Package)resource.getContents().get(0);
    }

    protected abstract void readTableOfContents(File var1) throws IOException;

    private void registerOPFResourceFactory() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(OPF_FILE_SUFFIX, new XMLResourceFactoryImpl(){

            public Resource createResource(URI uri) {
                OPFResourceImpl xmiResource = new OPFResourceImpl(uri){

                    protected XMLHelper createXMLHelper() {
                        EPUBXMLHelperImp xmlHelper = new EPUBXMLHelperImp();
                        return xmlHelper;
                    }
                };
                Map loadOptions = xmiResource.getDefaultLoadOptions();
                Map saveOptions = xmiResource.getDefaultSaveOptions();
                saveOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
                loadOptions.put("EXTENDED_META_DATA", Boolean.TRUE);
                loadOptions.put("LAX_FEATURE_PROCESSING", Boolean.TRUE);
                loadOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                saveOptions.put("ENCODING", OPSPublication.XML_ENCODING);
                HashMap<String, Boolean> parserFeatures = new HashMap<String, Boolean>();
                parserFeatures.put("http://xml.org/sax/features/validation", Boolean.FALSE);
                parserFeatures.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                loadOptions.put("PARSER_FEATURES", parserFeatures);
                return xmiResource;
            }
        });
    }

    public void setCover(File image, String title) {
        Item item = this.addItem(COVER_IMAGE_ID, null, image, null, null, false, false, true);
        item.setTitle(title);
        this.addMeta(COVER_ID, COVER_IMAGE_ID);
        this.opfPackage.setGenerateCoverHTML(true);
    }

    private void setDcCommon(DCType dc, String id, String value) {
        FeatureMapUtil.addText((FeatureMap)dc.getMixed(), (String)value);
        if (id != null) {
            dc.setId(id);
        }
    }

    private void setDcLocalized(LocalizedDCType dc, String id, Locale lang, String value) {
        this.setDcCommon(dc, id, value);
        if (lang != null) {
            dc.setLang(lang.toString());
        }
    }

    public void setGenerateToc(boolean generateToc) {
        this.opfPackage.setGenerateTableOfContents(generateToc);
    }

    public void setIdentifierId(String identifier_id) {
        this.opfPackage.setUniqueIdentifier(identifier_id);
    }

    public void setIncludeReferencedResources(boolean include) {
        this.opfPackage.setIncludeReferencedResources(include);
    }

    public abstract void setTableOfContents(File var1);

    void unpack(File opfFile) throws Exception {
        this.readOPF(opfFile);
        this.rootFolder = opfFile.getAbsoluteFile().getParentFile();
        String tocId = this.opfPackage.getSpine().getToc();
        Item tocItem = this.getItemById(tocId);
        File tocFile = new File(String.valueOf(this.rootFolder.getAbsolutePath()) + File.separator + tocItem.getHref());
        this.readTableOfContents(tocFile);
    }

    protected abstract List<ValidationMessage> validateContents() throws FileNotFoundException, IOException, SAXException, ParserConfigurationException;

    public List<Diagnostic> validateMetadata() {
        EValidator.Registry.INSTANCE.put((Object)OPFPackage.eINSTANCE, (Object)new OPFValidator());
        BasicDiagnostic diagnostics = new BasicDiagnostic();
        for (EObject eo : this.opfPackage.eContents()) {
            HashMap context = new HashMap();
            Diagnostician.INSTANCE.validate(eo, (DiagnosticChain)diagnostics, context);
        }
        return diagnostics.getChildren();
    }

    private void writeContent(File rootFolder) throws IOException {
        this.log(Messages.getString("OPSPublication.22"), ILogger.Severity.INFO, this.indent);
        EList<Item> items = this.opfPackage.getManifest().getItems();
        for (Item item : items) {
            if (item.isGenerated()) continue;
            File source = new File(item.getFile());
            File destination = new File(String.valueOf(rootFolder.getAbsolutePath()) + File.separator + item.getHref());
            EPUBFileUtil.copy(source, destination);
        }
    }

    private void writeCoverHTML(File rootFolder) throws IOException {
        Item coverImage = this.getItemById(COVER_IMAGE_ID);
        File coverFile = new File(String.valueOf(rootFolder.getAbsolutePath()) + File.separator + "cover-page.xhtml");
        if (!coverFile.exists()) {
            try {
                this.log(MessageFormat.format(Messages.getString("OPSPublication.28"), coverImage.getHref()), ILogger.Severity.INFO, this.indent);
                FileWriter fw = new FileWriter(coverFile);
                fw.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n");
                fw.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n");
                fw.append("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
                fw.append("  <head>\n");
                fw.append("    <title>" + coverImage.getTitle() + "</title>\n");
                fw.append("    <style type=\"text/css\">");
                fw.append("      #cover-body {\n");
                fw.append("        margin: 0px;\n");
                fw.append("        text-align: center;\n");
                fw.append("        background-color: #222222;\n");
                fw.append("      }\n");
                fw.append("      #cover-block {\n");
                fw.append("        height: 100%;\n");
                fw.append("        margin-top: 0;\n");
                fw.append("      }\n");
                fw.append("      #cover-image {\n");
                fw.append("        height: 100%;\n");
                fw.append("        text-align: center;\n");
                fw.append("        max-width: 100%;\n");
                fw.append("      }\n");
                fw.append("    </style>\n");
                fw.append("  </head>\n");
                fw.append("  <body id=\"cover-body\">\n");
                fw.append("    <div id=\"cover-block\">\n");
                fw.append("      <img id=\"cover-image\" src=\"" + coverImage.getHref() + "\" alt=\"" + coverImage.getTitle() + "\"/>\n");
                fw.append("    </div>\n");
                fw.append("  </body>\n");
                fw.append("</html>\n");
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Item coverPage = this.addItem(COVER_ID, null, coverFile, null, MIMETYPE_XHTML, true, false, false);
        coverPage.setGenerated(true);
        this.addReference(coverPage.getHref(), coverImage.getTitle(), org.eclipse.mylyn.docs.epub.opf.Type.COVER.getLiteral());
        EList<Itemref> spine = this.opfPackage.getSpine().getSpineItems();
        Itemref cover = null;
        for (Itemref itemref : spine) {
            if (!itemref.getIdref().equals(COVER_ID)) continue;
            cover = itemref;
        }
        if (cover != null) {
            spine.move(0, cover);
        }
    }

    private void writeOPF(File opfFile) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)opfFile.getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)this.opfPackage);
        resource.save(null);
    }

    protected abstract void writeTableOfContents(File var1) throws IOException, ParserConfigurationException, SAXException;
}

