/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.PlatformActivator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.RepositoryModel;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.SynchronizationManger;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationSession;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeTasksJob;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.tests.connector.AssertionProgressMonitor;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnectorWithTaskDataHandler;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.tests.connector.MockTaskDataHandler;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tests.util.TestFixture;

public class SynchronizeTasksJobTest
extends TestCase {
    private IRepositoryModel tasksModel;
    private TaskDataManager taskDataManager;
    private TaskRepository repository;
    private TaskList taskList;
    private TaskDataStore taskDataStore;

    protected void setUp() throws Exception {
        this.tasksModel = TasksUi.getRepositoryModel();
        this.taskDataManager = (TaskDataManager)TasksUi.getTaskDataManager();
        this.repository = new TaskRepository("mock", "http://mockrepository.test");
        this.taskList = (TaskList)TasksUiInternal.getTaskList();
        this.taskDataStore = new TaskDataStore(TasksUi.getRepositoryManager());
    }

    protected void tearDown() throws Exception {
        TestFixture.resetTaskList();
    }

    public void testRunsExclusivly() throws Exception {
        SynchronizeTasksJob job = this.createSyncJob(null, Collections.<ITask>emptySet());
        SynchronizeTasksJobTest.assertTrue((boolean)(job.getRule() instanceof ITasksCoreConstants.MutexSchedulingRule));
    }

    public void testSyncWithSingleTaskDataCanceled() throws Exception {
        DeltaCountingTaskListChangeListener listener = new DeltaCountingTaskListChangeListener();
        MockRepositoryConnector connector = new MockRepositoryConnector(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                throw new OperationCanceledException();
            }
        };
        MockTask firstTask = new MockTask("1");
        MockTask secondTask = new MockTask("2");
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)firstTask);
        tasks.add((ITask)secondTask);
        SynchronizeTasksJob job = this.createSyncJob(connector, tasks);
        IStatus status = job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((Object)Status.CANCEL_STATUS, (Object)status);
        SynchronizeTasksJobTest.assertEquals((int)2, (int)listener.getDeltasFired());
        listener.tearDown();
    }

    public void testSyncWithSingleTaskDataRandomException() throws Exception {
        MockRepositoryConnector connector = new MockRepositoryConnector(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                throw new NullPointerException("Should just be logged");
            }
        };
        MockTask firstTask = new MockTask("1");
        MockTask secondTask = new MockTask("2");
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)firstTask);
        tasks.add((ITask)secondTask);
        SynchronizeTasksJob job = this.createSyncJob(connector, tasks);
        job.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void testMonitorWithSingleTaskData() throws Exception {
        MockRepositoryConnector connector = new MockRepositoryConnector();
        MockTask task = new MockTask("1");
        MockTask task2 = new MockTask("2");
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)task);
        tasks.add((ITask)task2);
        SynchronizeTasksJob job = this.createSyncJob(connector, tasks);
        AssertionProgressMonitor monitor = new AssertionProgressMonitor();
        job.run((IProgressMonitor)monitor);
        SynchronizeTasksJobTest.assertEquals((String)"beginTask|subTask|subTask|done", (String)monitor.getProgressLog());
    }

    public void testResetTaskStatusBeforeSync() throws Exception {
        DeltaCountingTaskListChangeListener listener = new DeltaCountingTaskListChangeListener();
        MockRepositoryConnector connector = new MockRepositoryConnector();
        MockTask firstTask = new MockTask("1");
        MockTask secondTask = new MockTask("2");
        ((AbstractTask)firstTask).setStatus((IStatus)new Status(2, "bundle", ""));
        ((AbstractTask)secondTask).setStatus((IStatus)new Status(4, "bundle", ""));
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)firstTask);
        tasks.add((ITask)secondTask);
        SynchronizeTasksJob job = this.createSyncJob(connector, tasks);
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((int)4, (int)listener.getDeltasFired());
        listener.tearDown();
    }

    public void testMonitorWithMultiTaskData() throws Exception {
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public AbstractTaskDataHandler getTaskDataHandler() {
                return new MockTaskDataHandler(this){

                    public boolean canGetMultiTaskData(TaskRepository repository) {
                        return true;
                    }

                    public void getMultiTaskData(TaskRepository repository, Set<String> taskIds, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
                    }
                };
            }
        };
        MockTask task = new MockTask("1");
        MockTask task2 = new MockTask("2");
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)task);
        tasks.add((ITask)task2);
        SynchronizeTasksJob job = this.createSyncJob(connector, tasks);
        AssertionProgressMonitor monitor = new AssertionProgressMonitor();
        job.run((IProgressMonitor)monitor);
        SynchronizeTasksJobTest.assertEquals((String)"beginTask|subTask|done", (String)monitor.getProgressLog());
    }

    public void testGetSingleTaskDataError() throws Exception {
        Status status = new Status(2, "bundle", "error");
        MockRepositoryConnector connector = new MockRepositoryConnector((IStatus)status){
            private final /* synthetic */ IStatus val$status;
            {
                this.val$status = iStatus;
            }

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                throw new CoreException(this.val$status);
            }
        };
        MockTask task = new MockTask("1");
        SynchronizeTasksJob job = this.createSyncJob(connector, Collections.singleton(task));
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((Object)status, (Object)((AbstractTask)task).getStatus());
    }

    public void testMultipleErrors() throws Exception {
        Status status = new Status(2, "bundle", "error");
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler((IStatus)status){
            private final /* synthetic */ IStatus val$status;
            {
                this.val$status = iStatus;
            }

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                if (!taskId.equals("3")) {
                    throw new CoreException(this.val$status);
                }
                return SynchronizeTasksJobTest.this.createTaskData("x");
            }
        };
        DeltaCountingTaskListChangeListener listener = new DeltaCountingTaskListChangeListener();
        MockTask task = new MockTask("1");
        MockTask task2 = new MockTask("2");
        MockTask task3 = new MockTask("3");
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)task);
        tasks.add((ITask)task2);
        tasks.add((ITask)task3);
        SynchronizeTasksJob job = this.createSyncJob(connector, tasks);
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((Object)status, (Object)((AbstractTask)task).getStatus());
        SynchronizeTasksJobTest.assertFalse((boolean)((AbstractTask)task).isSynchronizing());
        SynchronizeTasksJobTest.assertEquals((Object)status, (Object)((AbstractTask)task2).getStatus());
        SynchronizeTasksJobTest.assertFalse((boolean)((AbstractTask)task2).isSynchronizing());
        SynchronizeTasksJobTest.assertNull((Object)((AbstractTask)task3).getStatus());
        Collection statuses = job.getStatuses();
        SynchronizeTasksJobTest.assertEquals((int)2, (int)statuses.size());
        try {
            statuses.add(status);
            SynchronizeTasksJobTest.fail((String)"Should not be modifiable");
        }
        catch (Exception exception) {}
        SynchronizeTasksJobTest.assertEquals((int)2, (int)listener.getDeltasFired());
        listener.tearDown();
    }

    public void testGetSingleTaskDataNull() throws Exception {
        MockRepositoryConnector connector = new MockRepositoryConnector(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                return null;
            }
        };
        MockTask task = new MockTask("1");
        SynchronizeTasksJob job = this.createSyncJob(connector, Collections.singleton(task));
        job.run((IProgressMonitor)new NullProgressMonitor());
        IStatus status = ((AbstractTask)task).getStatus();
        SynchronizeTasksJobTest.assertEquals((String)"Connector failed to return task data for task \"Mock Task: http://mockrepository.test-1\"", (String)status.getMessage());
        SynchronizeTasksJobTest.assertEquals((int)4, (int)status.getSeverity());
        SynchronizeTasksJobTest.assertEquals((String)"org.eclipse.mylyn.tasks.core", (String)status.getPlugin());
    }

    public void testGetSingleTaskData() throws Exception {
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                return SynchronizeTasksJobTest.this.createTaskData("x");
            }
        };
        MockTask task = new MockTask("1");
        final AtomicBoolean putTaskData = new AtomicBoolean();
        SynchronizationSession synchronizationSession = new SynchronizationSession();
        TaskDataManager customTaskDataManager = new TaskDataManager(this.taskDataStore, TasksUi.getRepositoryManager(), this.taskList, (TaskActivityManager)TasksUi.getTaskActivityManager(), new SynchronizationManger((RepositoryModel)TasksUi.getRepositoryModel()), (ITask)task, synchronizationSession){
            private final /* synthetic */ ITask val$task;
            private final /* synthetic */ SynchronizationSession val$synchronizationSession;
            {
                this.val$task = iTask;
                this.val$synchronizationSession = synchronizationSession;
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
            }

            public void putUpdatedTaskData(ITask itask, TaskData taskData, boolean user, Object token, IProgressMonitor monitor) throws CoreException {
                putTaskData.set(true);
                SynchronizeTasksJobTest.assertEquals((Object)this.val$task, (Object)itask);
                SynchronizeTasksJobTest.assertNotNull((Object)taskData);
                SynchronizeTasksJobTest.assertFalse((boolean)user);
                SynchronizeTasksJobTest.assertEquals((Object)this.val$synchronizationSession, (Object)token);
                SynchronizeTasksJobTest.assertNotNull((Object)monitor);
            }
        };
        SynchronizeTasksJob job = this.createSyncJobWithManager(connector, Collections.singleton(task), customTaskDataManager);
        job.setSession(synchronizationSession);
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertTrue((boolean)putTaskData.get());
    }

    public void testGetSingleTaskDataPutFails() throws Exception {
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                return SynchronizeTasksJobTest.this.createTaskData("x");
            }
        };
        MockTask task = new MockTask("1");
        TaskDataStore taskDataStore = new TaskDataStore(TasksUi.getRepositoryManager());
        final Status status = new Status(4, "bundle", "error");
        TaskDataManager customTaskDataManager = new TaskDataManager(taskDataStore, TasksUi.getRepositoryManager(), this.taskList, (TaskActivityManager)TasksUi.getTaskActivityManager(), new SynchronizationManger((RepositoryModel)TasksUi.getRepositoryModel())){

            public void putUpdatedTaskData(ITask itask, TaskData taskData, boolean user, Object token, IProgressMonitor monitor) throws CoreException {
                throw new CoreException((IStatus)status);
            }
        };
        SynchronizeTasksJob job = this.createSyncJobWithManager(connector, Collections.singleton(task), customTaskDataManager);
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((Object)status, (Object)((AbstractTask)task).getStatus());
    }

    public void testGetMultiTaskData() throws Exception {
        final AtomicBoolean multiGotCalled = new AtomicBoolean();
        DeltaCountingTaskListChangeListener listener = new DeltaCountingTaskListChangeListener();
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                SynchronizeTasksJobTest.fail((String)"Should use canGetMultiTaskData");
                return null;
            }

            @Override
            public AbstractTaskDataHandler getTaskDataHandler() {
                return new MockTaskDataHandler(this){

                    public boolean canGetMultiTaskData(TaskRepository repository) {
                        return true;
                    }

                    public void getMultiTaskData(TaskRepository repository, Set<String> taskIds, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
                        multiGotCalled.set(true);
                        SynchronizeTasksJobTest.assertEquals((int)3, (int)taskIds.size());
                        SynchronizeTasksJobTest.assertTrue((boolean)taskIds.contains("1"));
                        SynchronizeTasksJobTest.assertTrue((boolean)taskIds.contains("2"));
                        SynchronizeTasksJobTest.assertTrue((boolean)taskIds.contains("3"));
                        SynchronizeTasksJobTest.assertNotNull((Object)collector);
                    }
                };
            }
        };
        MockTask task = new MockTask("1");
        MockTask task2 = new MockTask("2");
        MockTask task3 = new MockTask("3");
        ((AbstractTask)task).setStatus((IStatus)new Status(2, "bundle", ""));
        ((AbstractTask)task2).setStatus((IStatus)new Status(2, "bundle", ""));
        ((AbstractTask)task3).setStatus((IStatus)new Status(2, "bundle", ""));
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)task);
        tasks.add((ITask)task2);
        tasks.add((ITask)task3);
        SynchronizeTasksJob job = this.createSyncJob(connector, tasks);
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((int)3, (int)listener.getDeltasFired());
        SynchronizeTasksJobTest.assertTrue((boolean)multiGotCalled.get());
        listener.tearDown();
    }

    public void testGetMultiTaskDataPutIntoManager() throws Exception {
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public AbstractTaskDataHandler getTaskDataHandler() {
                return new MockTaskDataHandler(this){

                    public boolean canGetMultiTaskData(TaskRepository repository) {
                        return true;
                    }

                    public void getMultiTaskData(TaskRepository repository, Set<String> taskIds, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
                        collector.accept(SynchronizeTasksJobTest.this.createTaskData("1"));
                        collector.accept(SynchronizeTasksJobTest.this.createTaskData("2"));
                        collector.failed("3", (IStatus)new Status(4, "bundle", "error"));
                    }
                };
            }
        };
        MockTask task = new MockTask("1");
        MockTask task2 = new MockTask("2");
        MockTask task3 = new MockTask("3");
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)task);
        tasks.add((ITask)task2);
        tasks.add((ITask)task3);
        final AtomicInteger taskDataPut = new AtomicInteger();
        TaskDataManager customTaskDataManager = new TaskDataManager(this.taskDataStore, TasksUi.getRepositoryManager(), this.taskList, (TaskActivityManager)TasksUi.getTaskActivityManager(), new SynchronizationManger((RepositoryModel)TasksUi.getRepositoryModel())){

            public void putUpdatedTaskData(ITask itask, TaskData taskData, boolean user, Object token, IProgressMonitor monitor) throws CoreException {
                taskDataPut.incrementAndGet();
            }
        };
        SynchronizeTasksJob job = this.createSyncJobWithManager(connector, tasks, customTaskDataManager);
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((int)2, (int)taskDataPut.get());
        SynchronizeTasksJobTest.assertEquals((String)"error", (String)((AbstractTask)task3).getStatus().getMessage());
    }

    public void testGetMultiTaskDataFails() throws Exception {
        final Status errorStatus = new Status(4, "bundle", "error");
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public AbstractTaskDataHandler getTaskDataHandler() {
                return new MockTaskDataHandler(this){

                    public boolean canGetMultiTaskData(TaskRepository repository) {
                        return true;
                    }

                    public void getMultiTaskData(TaskRepository repository, Set<String> taskIds, TaskDataCollector collector, IProgressMonitor monitor) throws CoreException {
                        throw new CoreException((IStatus)errorStatus);
                    }
                };
            }
        };
        MockTask task = new MockTask("1");
        MockTask task2 = new MockTask("2");
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)task);
        tasks.add((ITask)task2);
        SynchronizeTasksJob job = this.createSyncJob(connector, tasks);
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((Object)errorStatus, (Object)((AbstractTask)task).getStatus());
        SynchronizeTasksJobTest.assertEquals((Object)errorStatus, (Object)((AbstractTask)task2).getStatus());
    }

    public void testGetSingleTaskDataWithRelations() throws Exception {
        final AtomicReference requestedTaskIds = new AtomicReference();
        requestedTaskIds.set(new ArrayList());
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                ((List)requestedTaskIds.get()).add(taskId);
                return SynchronizeTasksJobTest.this.createTaskData(taskId);
            }

            public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
                if (!taskData.getTaskId().equals("1")) {
                    return null;
                }
                ArrayList<TaskRelation> relations = new ArrayList<TaskRelation>();
                relations.add(TaskRelation.dependency((String)"1.dep.in", (TaskRelation.Direction)TaskRelation.Direction.INWARD));
                relations.add(TaskRelation.dependency((String)"1.dep.out", (TaskRelation.Direction)TaskRelation.Direction.OUTWARD));
                relations.add(TaskRelation.parentTask((String)"1.par"));
                relations.add(TaskRelation.subtask((String)"1.sub"));
                relations.add(TaskRelation.subtask((String)"1.sub2"));
                return relations;
            }
        };
        MockTask task = new MockTask("1");
        this.taskList.addTask((ITask)task);
        SynchronizeTasksJob job = this.createSyncJob(connector, Collections.singleton(task));
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((int)3, (int)((List)requestedTaskIds.get()).size());
        SynchronizeTasksJobTest.assertTrue((boolean)((List)requestedTaskIds.get()).contains("1"));
        SynchronizeTasksJobTest.assertTrue((boolean)((List)requestedTaskIds.get()).contains("1.sub"));
        SynchronizeTasksJobTest.assertTrue((boolean)((List)requestedTaskIds.get()).contains("1.sub2"));
        ITask sub1 = this.taskList.getTask("http://mockrepository.test", "1.sub");
        SynchronizeTasksJobTest.assertNotNull((Object)sub1);
        ITask sub2 = this.taskList.getTask("http://mockrepository.test", "1.sub2");
        SynchronizeTasksJobTest.assertNotNull((Object)sub2);
        SynchronizeTasksJobTest.assertEquals((Object)ITask.SynchronizationState.INCOMING_NEW, (Object)((AbstractTask)sub1).getSynchronizationState());
        SynchronizeTasksJobTest.assertEquals((Object)ITask.SynchronizationState.INCOMING_NEW, (Object)((AbstractTask)sub2).getSynchronizationState());
        ((List)requestedTaskIds.get()).clear();
        job = this.createSyncJob(connector, Collections.singleton(task));
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((int)1, (int)((List)requestedTaskIds.get()).size());
        SynchronizeTasksJobTest.assertTrue((boolean)((List)requestedTaskIds.get()).contains("1"));
    }

    public void testGetSingleTaskDataWithRelationsAndRemoveRelation() throws Exception {
        final AtomicReference requestedTaskIds = new AtomicReference();
        requestedTaskIds.set(new ArrayList());
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                ((List)requestedTaskIds.get()).add(taskId);
                return SynchronizeTasksJobTest.this.createTaskData(taskId);
            }

            public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
                if (!taskData.getTaskId().equals("1")) {
                    return null;
                }
                ArrayList<TaskRelation> relations = new ArrayList<TaskRelation>();
                relations.add(TaskRelation.subtask((String)"1.sub"));
                relations.add(TaskRelation.subtask((String)"1.sub5"));
                return relations;
            }
        };
        MockTask task = new MockTask("1");
        MockTask subtaskToBeGone = new MockTask("1.sub2");
        MockTask subtaskToStay = new MockTask("1.sub5");
        this.taskList.addTask((ITask)task);
        this.taskList.addTask((ITask)subtaskToBeGone, (AbstractTaskContainer)task);
        this.taskList.addTask((ITask)subtaskToStay, (AbstractTaskContainer)task);
        SynchronizeTasksJob job = this.createSyncJob(connector, Collections.singleton(task));
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((int)2, (int)((List)requestedTaskIds.get()).size());
        SynchronizeTasksJobTest.assertTrue((boolean)((List)requestedTaskIds.get()).contains("1"));
        SynchronizeTasksJobTest.assertTrue((boolean)((List)requestedTaskIds.get()).contains("1.sub"));
        ITask sub1 = this.taskList.getTask("http://mockrepository.test", "1.sub");
        ITask sub2 = this.taskList.getTask("http://mockrepository.test", "1.sub2");
        ITask sub5 = this.taskList.getTask("http://mockrepository.test", "1.sub5");
        SynchronizeTasksJobTest.assertNotNull((Object)sub1);
        SynchronizeTasksJobTest.assertNotNull((Object)sub2);
        SynchronizeTasksJobTest.assertNotNull((Object)sub5);
        Collection children = ((AbstractTaskContainer)task).getChildren();
        SynchronizeTasksJobTest.assertEquals((int)2, (int)children.size());
        SynchronizeTasksJobTest.assertTrue((boolean)children.contains(sub1));
        SynchronizeTasksJobTest.assertTrue((boolean)children.contains(sub5));
    }

    public void testErrorOnRelationRetrieval() throws Exception {
        final AtomicReference requestedTaskIds = new AtomicReference();
        requestedTaskIds.set(new ArrayList());
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                ((List)requestedTaskIds.get()).add(taskId);
                if (taskId.equals("1.sub")) {
                    throw new CoreException((IStatus)new Status(4, "bundle", "log me"));
                }
                return SynchronizeTasksJobTest.this.createTaskData(taskId);
            }

            public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
                if (!taskData.getTaskId().equals("1")) {
                    return null;
                }
                ArrayList<TaskRelation> relations = new ArrayList<TaskRelation>();
                relations.add(TaskRelation.subtask((String)"1.sub"));
                return relations;
            }
        };
        ILog log = InternalPlatform.getDefault().getLog(PlatformActivator.getContext().getBundle());
        final AtomicReference loggedStatus = new AtomicReference();
        ILogListener listener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                loggedStatus.set(status);
            }
        };
        log.addLogListener(listener);
        MockTask task = new MockTask("1");
        this.taskList.addTask((ITask)task);
        SynchronizeTasksJob job = this.createSyncJob(connector, Collections.singleton(task));
        job.run((IProgressMonitor)new NullProgressMonitor());
        SynchronizeTasksJobTest.assertEquals((String)"Synchronization of task 1.sub [http://mockrepository.test] failed", (String)((IStatus)loggedStatus.get()).getMessage());
        log.removeLogListener(listener);
    }

    public void testTasksForSeveralRepositories() throws Exception {
        final AtomicReference requestedTaskIds = new AtomicReference();
        requestedTaskIds.set(new ArrayList());
        MockRepositoryConnectorWithTaskDataHandler connector = new MockRepositoryConnectorWithTaskDataHandler(){

            @Override
            public TaskData getTaskData(TaskRepository taskRepository, String taskId, IProgressMonitor monitor) throws CoreException {
                ((List)requestedTaskIds.get()).add(String.valueOf(taskId) + " on " + taskRepository.getRepositoryUrl());
                return SynchronizeTasksJobTest.this.createTaskData(taskId);
            }
        };
        MockTask task = new MockTask("1");
        this.taskList.addTask((ITask)task);
        MockTask anotherTask = new MockTask("5");
        String secondRepositoryUrl = "http://mockrepository.test2";
        ((AbstractTask)anotherTask).setRepositoryUrl(secondRepositoryUrl);
        this.taskList.addTask((ITask)anotherTask);
        TaskRepository firstRepository = new TaskRepository("mock", "http://mockrepository.test");
        TasksUi.getRepositoryManager().addRepository(firstRepository);
        TaskRepository secondRepository = new TaskRepository("mock", secondRepositoryUrl);
        TasksUi.getRepositoryManager().addRepository(secondRepository);
        HashSet<ITask> tasks = new HashSet<ITask>();
        tasks.add((ITask)task);
        tasks.add((ITask)anotherTask);
        SynchronizeTasksJob job = this.createSyncJobWithoutRepository(connector, tasks);
        final StringBuilder progressLog = new StringBuilder();
        job.run((IProgressMonitor)new NullProgressMonitor(){

            public void beginTask(String name, int totalWork) {
                progressLog.append("beginTask|");
            }

            public void done() {
                progressLog.append("done");
            }

            public void subTask(String name) {
                progressLog.append("subTask|");
            }
        });
        SynchronizeTasksJobTest.assertEquals((String)"beginTask|subTask|subTask|subTask|subTask|done", (String)progressLog.toString());
        SynchronizeTasksJobTest.assertTrue((boolean)((List)requestedTaskIds.get()).contains("1 on http://mockrepository.test"));
        SynchronizeTasksJobTest.assertTrue((boolean)((List)requestedTaskIds.get()).contains("5 on http://mockrepository.test2"));
        ((TaskRepositoryManager)TasksUi.getRepositoryManager()).removeRepository(secondRepository);
        ((TaskRepositoryManager)TasksUi.getRepositoryManager()).removeRepository(firstRepository);
    }

    private SynchronizeTasksJob createSyncJob(AbstractRepositoryConnector connector, Set<ITask> tasks) {
        return new SynchronizeTasksJob(this.taskList, this.taskDataManager, this.tasksModel, connector, this.repository, tasks);
    }

    private SynchronizeTasksJob createSyncJobWithManager(AbstractRepositoryConnector connector, Set<ITask> tasks, TaskDataManager customTaskDataManager) {
        return new SynchronizeTasksJob(this.taskList, customTaskDataManager, this.tasksModel, connector, this.repository, tasks);
    }

    private SynchronizeTasksJob createSyncJobWithoutRepository(AbstractRepositoryConnector connector, Set<ITask> tasks) {
        return new SynchronizeTasksJob(this.taskList, this.taskDataManager, this.tasksModel, connector, TasksUi.getRepositoryManager(), tasks);
    }

    private TaskData createTaskData(String taskId) {
        return new TaskData(new TaskAttributeMapper(this.repository), "mock", "http://mockrepository.test", taskId);
    }

    private final class DeltaCountingTaskListChangeListener
    implements ITaskListChangeListener {
        private int deltasFired = 0;

        public DeltaCountingTaskListChangeListener() {
            SynchronizeTasksJobTest.this.taskList.addChangeListener((ITaskListChangeListener)this);
        }

        public void containersChanged(Set<TaskContainerDelta> containers) {
            ++this.deltasFired;
        }

        public int getDeltasFired() {
            return this.deltasFired;
        }

        public void tearDown() {
            SynchronizeTasksJobTest.this.taskList.removeChangeListener((ITaskListChangeListener)this);
        }
    }
}

