/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.commons.workbench.browser.AbstractUrlHandler;
import org.eclipse.mylyn.internal.gerrit.ui.editor.GerritTaskEditorPage;
import org.eclipse.mylyn.reviews.ui.spi.editor.ReviewSetSection;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.editor.IFormPage;

public class GerritUrlHandler
extends AbstractUrlHandler {
    private static final Pattern URL_PATTERN = Pattern.compile("/?(#/c)?/(\\d+)");

    public EditorHandle openUrl(IWorkbenchPage page, String url, int customFlags) {
        for (TaskRepository repository : TasksUi.getRepositoryManager().getRepositories("org.eclipse.mylyn.gerrit")) {
            String taskId = this.getTaskId(repository, url);
            if (taskId == null) continue;
            EditorHandle editorHandle = TasksUiUtil.openTaskWithResult((TaskRepository)repository, (String)taskId);
            int patchSetNumber = this.getPatchSetNumber(repository, url, taskId);
            if (patchSetNumber > 0) {
                this.revealPatchSet(editorHandle, patchSetNumber);
            }
            return editorHandle;
        }
        return null;
    }

    private void revealPatchSet(EditorHandle editorHandle, Integer patchSetNumber) {
        GerritTaskEditorPage gerritPage;
        ReviewSetSection section;
        TaskEditor taskEditor;
        IFormPage activePage;
        IWorkbenchPart part = editorHandle.getPart();
        if (part instanceof TaskEditor && (activePage = (taskEditor = (TaskEditor)part).setActivePage(GerritTaskEditorPage.class.getName())) instanceof GerritTaskEditorPage && (section = (ReviewSetSection)(gerritPage = (GerritTaskEditorPage)activePage).getPart(ReviewSetSection.class.getName())) != null && !section.getControl().isDisposed()) {
            section.revealPatchSet(patchSetNumber.intValue());
        }
    }

    public String getTaskId(TaskRepository repository, String url) {
        String path;
        Matcher matcher;
        if (url.startsWith(repository.getRepositoryUrl()) && (matcher = URL_PATTERN.matcher(path = "/" + url.substring(repository.getRepositoryUrl().length()))).find()) {
            return matcher.group(2);
        }
        return null;
    }

    int getPatchSetNumber(TaskRepository repository, String url, String taskId) {
        String taskUrl = TasksUi.getRepositoryConnector((String)"org.eclipse.mylyn.gerrit").getTaskUrl(repository.getUrl(), taskId);
        String urlQualifiers = StringUtils.remove((String)url, (String)taskUrl);
        String[] fragments = StringUtils.split((String)urlQualifiers, (String)"/");
        if (fragments.length > 0) {
            String patchSetFragment = fragments[0];
            try {
                return Integer.valueOf(patchSetFragment);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -1;
    }

    public int getPriority() {
        return 200;
    }
}

