/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.ui.editor.GerritReviewDetailSection;
import org.eclipse.mylyn.internal.gerrit.ui.editor.PatchSetSection;
import org.eclipse.mylyn.reviews.ui.spi.editor.AbstractReviewTaskEditorPage;
import org.eclipse.mylyn.reviews.ui.spi.editor.ReviewDetailSection;
import org.eclipse.mylyn.reviews.ui.spi.editor.ReviewSetSection;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.services.IServiceLocator;

public class GerritTaskEditorPage
extends AbstractReviewTaskEditorPage {
    public GerritTaskEditorPage(TaskEditor editor) {
        super(editor, GerritTaskEditorPage.class.getName(), "Gerrit Page", "org.eclipse.mylyn.gerrit");
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmitButton(false);
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        return new AttributeEditorFactory(this.getModel(), this.getTaskRepository(), (IServiceLocator)this.getEditorSite()){

            public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
                if (taskAttribute.getId().equals(GerritTaskSchema.getDefault().CHANGE_ID.getKey())) {
                    AbstractAttributeEditor editor = super.createEditor(type, taskAttribute);
                    editor.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
                    return editor;
                }
                if (taskAttribute.getId().equals(GerritTaskSchema.getDefault().PROJECT.getKey())) {
                    AbstractAttributeEditor editor = super.createEditor(type, taskAttribute);
                    editor.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
                    return editor;
                }
                return super.createEditor(type, taskAttribute);
            }
        };
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set descriptors = super.createPartDescriptors();
        TaskEditorPartDescriptor commentsDescriptor = null;
        TaskEditorPartDescriptor newCommentsDescriptor = null;
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            TaskEditorPartDescriptor descriptor = (TaskEditorPartDescriptor)it.next();
            if ("actions".equals(descriptor.getPath())) {
                it.remove();
            }
            if ("people".equals(descriptor.getPath())) {
                it.remove();
            }
            if ("org.eclipse.mylyn.tasks.ui.editors.parts.comments".equals(descriptor.getId())) {
                it.remove();
                commentsDescriptor = descriptor;
            }
            if (!"org.eclipse.mylyn.tasks.ui.editors.parts.newComment".equals(descriptor.getId())) continue;
            it.remove();
            newCommentsDescriptor = descriptor;
        }
        descriptors.add(new TaskEditorPartDescriptor(ReviewDetailSection.class.getName()){

            public AbstractTaskEditorPart createPart() {
                return new GerritReviewDetailSection();
            }
        });
        descriptors.add(new TaskEditorPartDescriptor(ReviewSetSection.class.getName()){

            public AbstractTaskEditorPart createPart() {
                return new PatchSetSection();
            }
        });
        if (commentsDescriptor != null) {
            descriptors.add(commentsDescriptor);
        }
        if (newCommentsDescriptor != null) {
            descriptors.add(newCommentsDescriptor);
        }
        return descriptors;
    }
}

