/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.factories;

import com.google.gerrit.common.data.PatchSetPublishDetail;
import com.google.gerrit.reviewdb.PatchSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.ui.factories.AbstractPatchSetUiFactory;
import org.eclipse.mylyn.internal.gerrit.ui.operations.PublishDialog;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class PublishUiFactory
extends AbstractPatchSetUiFactory {
    public PublishUiFactory(IUiContext context, IReviewItemSet set) {
        super("Publish Comments...", context, set);
    }

    public void execute() {
        PatchSet.Id patchSetId = this.getPatchSetDetail().getPatchSet().getId();
        PatchSetPublishDetail publishDetail = (PatchSetPublishDetail)this.getChange().getPublishDetailByPatchSetId().get(patchSetId);
        TaskAttribute comment = this.getTaskData().getRoot().getAttribute("task.common.comment.new");
        String editorCommentText = comment != null ? comment.getValue() : "";
        int open = new PublishDialog(this.getShell(), this.getTask(), publishDetail, (IReviewItemSet)this.getModelObject(), editorCommentText).open(this.getEditor());
        if (open == 0 && comment != null) {
            comment.clearValues();
            if (this.getTaskEditorPage() != null) {
                this.getTaskEditorPage().doSave((IProgressMonitor)new NullProgressMonitor());
            }
            try {
                TasksUi.getTaskDataManager().discardEdits(this.getTask());
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.mylyn.gerrit.ui", "Error while clearing task status.", (Throwable)e);
                TasksUiInternal.displayStatus((String)"Clear outgoing task status failed", (IStatus)status);
            }
        }
    }

    public boolean isExecutable() {
        return this.getTaskData().getAttributeMapper().getBooleanValue(this.getTaskData().getRoot().getAttribute(GerritTaskSchema.getDefault().CAN_PUBLISH.getKey()));
    }
}

