/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.gitlab.core.GitlabConfiguration;
import org.eclipse.mylyn.gitlab.core.GitlabException;
import org.eclipse.mylyn.internal.gitlab.core.GitlabJSonArrayOperation;
import org.eclipse.mylyn.internal.gitlab.core.GitlabNewTaskSchema;
import org.eclipse.mylyn.internal.gitlab.core.GitlabOperation;
import org.eclipse.mylyn.internal.gitlab.core.GitlabPostOperation;
import org.eclipse.mylyn.internal.gitlab.core.GitlabPutOperation;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRepositoryConnector;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskAttributeMapper;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskDataHandler;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskSchema;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.osgi.util.NLS;

public class GitlabRestClient {
    private final CommonHttpClient client;
    private final GitlabRepositoryConnector connector;
    private final TaskRepository taskRepository;
    public static String AUTHORIZATION_HEADER = "authorization_header";
    Map<String, String> updatable;
    private static SimpleDateFormat dmyFormat = new SimpleDateFormat("yyyy-MM-dd");

    public GitlabRestClient(RepositoryLocation location, GitlabRepositoryConnector connector, TaskRepository taskRepository) {
        this.updatable = Map.ofEntries(Map.entry(GitlabTaskSchema.getDefault().SUMMARY.getKey(), "title"), Map.entry(GitlabTaskSchema.getDefault().DESCRIPTION.getKey(), "description"), Map.entry(GitlabTaskSchema.getDefault().DISCUSSION_LOCKED.getKey(), GitlabTaskSchema.getDefault().DISCUSSION_LOCKED.getKey()), Map.entry(GitlabTaskSchema.getDefault().CONFIDENTIAL.getKey(), GitlabTaskSchema.getDefault().CONFIDENTIAL.getKey()), Map.entry(GitlabTaskSchema.getDefault().ISSUE_TYPE.getKey(), GitlabTaskSchema.getDefault().ISSUE_TYPE.getKey()), Map.entry(GitlabTaskSchema.getDefault().OPERATION.getKey(), "state_event"), Map.entry(GitlabTaskSchema.getDefault().DUE_DATE.getKey(), GitlabTaskSchema.getDefault().DUE_DATE.getKey()));
        this.client = new CommonHttpClient(location);
        this.connector = connector;
        this.taskRepository = taskRepository;
    }

    public RepositoryLocation getLocation() {
        return this.client.getLocation();
    }

    public CommonHttpClient getClient() {
        return this.client;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public IStatus getIssues(IRepositoryQuery query, TaskDataCollector collector, IOperationMonitor monitor) throws GitlabException, CoreException {
        String[] gueryGroups;
        int n;
        this.getAccessTokenIfNotPresent(monitor);
        String[] queryProjects = query.getAttribute(GitlabTaskSchema.getDefault().PRODUCT.getKey()).split(",");
        String groupAttribute = query.getAttribute("group");
        if (!queryProjects[0].isEmpty()) {
            String[] stringArray = queryProjects;
            n = queryProjects.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String path = "/projects/" + string.replaceAll("/", "%2F");
                this.getIssuesInternal(query, collector, path, monitor);
                ++n2;
            }
        }
        if (groupAttribute != null && !(gueryGroups = groupAttribute.split(","))[0].isEmpty()) {
            String[] stringArray = gueryGroups;
            int n3 = gueryGroups.length;
            n = 0;
            while (n < n3) {
                String string = stringArray[n];
                String path = "/groups/" + string.replaceAll("/", "%2F");
                this.getIssuesInternal(query, collector, path, monitor);
                ++n;
            }
        }
        return Status.OK_STATUS;
    }

    private void getIssuesInternal(final IRepositoryQuery query, final TaskDataCollector collector, String path, IOperationMonitor monitor) throws GitlabException {
        List taskDataArray = (List)new GitlabOperation<List<TaskData>>(this.client, String.valueOf(path) + "/issues"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                String state = query.getAttribute("STATE");
                HttpGet request = new HttpGet(String.valueOf(url) + (switch (state != null ? state : "") {
                    case "opened" -> "?state=opened";
                    case "closed" -> "?state=closed";
                    default -> "";
                }));
                return request;
            }

            @Override
            protected List<TaskData> parseFromJson(InputStreamReader in) throws GitlabException {
                TypeToken<List<TaskData>> type = new TypeToken<List<TaskData>>(){};
                return (List)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataListDeserializer()).create().fromJson((Reader)in, type.getType());
            }
        }.run(monitor);
        for (final TaskData taskData : taskDataArray) {
            taskData.setPartial(true);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    collector.accept(taskData);
                }

                public void handleException(Throwable exception) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", NLS.bind((String)"Unexpected error during result collection. TaskID {0} in repository {1}", (Object)taskData.getTaskId(), (Object)taskData.getRepositoryUrl()), exception));
                }
            });
        }
    }

    public String getVersion(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject versionInfo = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/version"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return versionInfo.get("version").getAsString();
    }

    public String getVersionAndRevision(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject versionInfo = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/version"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return String.valueOf(versionInfo.get("version").getAsString()) + "(rev: " + versionInfo.get("revision").getAsString() + ")";
    }

    public boolean validate(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        String validate = (String)new GitlabOperation<String>(this.client, "/version"){

            protected boolean isRepeatable() {
                return false;
            }

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected String parseFromJson(InputStreamReader in) throws GitlabException {
                return ((Stream)new BufferedReader(in).lines().parallel()).collect(Collectors.joining("\n"));
            }
        }.run(monitor);
        return validate.length() > 0 && validate.contains("version");
    }

    public JsonObject getMetadata(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/metadata"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    private TaskData getFromJson(JsonObject jo) {
        GitlabTaskDataHandler dataHandler = (GitlabTaskDataHandler)this.connector.getTaskDataHandler();
        TaskAttributeMapper mapper = dataHandler.getAttributeMapper(this.taskRepository);
        String selfString = jo.get("_links").getAsJsonObject().get("self").getAsString();
        TaskData response = new TaskData(mapper, this.connector.getConnectorKind(), this.taskRepository.getRepositoryUrl(), selfString.replace(String.valueOf(this.taskRepository.getUrl()) + "/api/v4", ""));
        try {
            dataHandler.initializeTaskData(this.taskRepository, response, null, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : jo.entrySet()) {
            String attributeId = GitlabTaskSchema.getAttributeNameFromJsonName((String)entry.getKey());
            TaskAttribute attribute = response.getRoot().getAttribute(attributeId);
            AbstractTaskSchema.Field field = GitlabTaskSchema.getDefault().getFieldByKey(attributeId);
            if (attribute == null) {
                PrintStream ps = attribute == null ? System.err : System.out;
                ps.println(String.valueOf((String)entry.getKey()) + " -> " + entry.getValue() + " -> " + attributeId + " -> " + attribute + "\n" + ((JsonElement)entry.getValue()).isJsonPrimitive() + ((JsonElement)entry.getValue()).isJsonObject() + ((JsonElement)entry.getValue()).isJsonArray());
                ps.flush();
            }
            if (attribute != null && entry.getValue() != null && ((JsonElement)entry.getValue()).isJsonPrimitive()) {
                attribute.setValue(((JsonElement)entry.getValue()).getAsString());
            }
            if (field == null || !"person".equals(field.getType()) || !((JsonElement)entry.getValue()).isJsonObject()) continue;
            attribute.setValue(((JsonElement)entry.getValue()).getAsJsonObject().get("name").getAsString());
            IRepositoryPerson author = this.taskRepository.createPerson(((JsonElement)entry.getValue()).getAsJsonObject().get("username").getAsString());
            author.setName(((JsonElement)entry.getValue()).getAsJsonObject().get("name").getAsString());
            author.setAttribute("avatar_url", ((JsonElement)entry.getValue()).getAsJsonObject().get("avatar_url").getAsString());
            mapper.setRepositoryPerson(attribute, author);
        }
        return response;
    }

    private GitlabConfiguration getConfiguration() {
        GitlabConfiguration config;
        try {
            config = this.connector.getRepositoryConfiguration(this.taskRepository);
        }
        catch (CoreException e) {
            e.printStackTrace();
            config = null;
        }
        return config;
    }

    private void getAccessTokenIfNotPresent(IOperationMonitor monitor) {
        if (this.getClientAttribute(AUTHORIZATION_HEADER) == null) {
            try {
                this.obtainAccessToken(monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Object getClientAttribute(String attribute) {
        return this.getClient().getAttribute(attribute);
    }

    private void setClientAttribute(String attribute, Object value) {
        this.getClient().setAttribute(attribute, value);
    }

    public String obtainAccessToken(IOperationMonitor monitor) throws Exception {
        AuthenticationCredentials credentials1 = this.taskRepository.getCredentials(AuthenticationType.REPOSITORY);
        String username = credentials1.getUserName();
        String password = credentials1.getPassword();
        String repositoryUrl = this.taskRepository.getRepositoryUrl();
        URL url = new URL(String.valueOf(repositoryUrl) + "/oauth/token");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.getOutputStream().write(("grant_type=password&username=" + username + "&password=" + password).getBytes());
        connection.connect();
        int responseCode = connection.getResponseCode();
        if (responseCode != 200) {
            throw new Exception("Failed to obtain access token");
        }
        String response = new String(connection.getInputStream().readAllBytes());
        String accessToken = response.split("\"access_token\":\"")[1].split("\"")[0];
        this.setClientAttribute(AUTHORIZATION_HEADER, "Bearer " + accessToken);
        return accessToken;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws GitlabException {
        TaskData result = null;
        String searchString = ".*(/projects/\\d+)/issues/(\\d+)";
        Pattern pattern = Pattern.compile(searchString, 2);
        Matcher matcher = pattern.matcher(taskId);
        if (matcher.find()) {
            GitlabConfiguration config = this.getConfiguration();
            JsonObject issue = this.getIssue(matcher.group(1), matcher.group(2), OperationUtil.convert((IProgressMonitor)monitor));
            TypeToken<TaskData> type = new TypeToken<TaskData>(){};
            result = (TaskData)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((JsonElement)issue, type.getType());
            JsonArray discussions = this.getIssueDiscussions(matcher.group(1), matcher.group(2), OperationUtil.convert((IProgressMonitor)monitor));
            if (discussions != null) {
                int i = 0;
                TaskAttribute attrib = null;
                for (JsonElement jsonElement : discussions) {
                    JsonObject discussion = (JsonObject)jsonElement;
                    JsonArray notesArray = discussion.get("notes").getAsJsonArray();
                    if (discussion.get("individual_note").getAsBoolean()) {
                        JsonObject note = notesArray.get(0).getAsJsonObject();
                        attrib = this.createNoteTaskAttribute(repository, result.getRoot(), i++, note);
                        attrib.createAttribute("discussions").setValue(discussion.get("id").getAsString());
                        attrib.createAttribute("noteable_id").setValue(note.get("noteable_id").getAsString());
                        attrib.createAttribute("note_id").setValue(note.get("id").getAsString());
                        continue;
                    }
                    TaskAttribute reply = null;
                    for (JsonElement jsonElement2 : notesArray) {
                        JsonObject note = jsonElement2.getAsJsonObject();
                        attrib = this.createNoteTaskAttribute(repository, reply == null ? result.getRoot() : reply, i++, note);
                        if (reply == null) {
                            reply = attrib.createAttribute("reply");
                        }
                        attrib.createAttribute("discussions").setValue(discussion.get("id").getAsString());
                        attrib.createAttribute("noteable_id").setValue(note.get("noteable_id").getAsString());
                        attrib.createAttribute("note_id").setValue(note.get("id").getAsString());
                    }
                }
            }
            config.updateProductOptions(result);
        }
        return result;
    }

    private TaskAttribute createNoteTaskAttribute(TaskRepository repository, TaskAttribute result, int i, JsonObject note) {
        TaskCommentMapper cmapper = new TaskCommentMapper();
        IRepositoryPerson author = repository.createPerson(note.get("author").getAsJsonObject().get("username").getAsString());
        author.setName(note.get("author").getAsJsonObject().get("name").getAsString());
        author.setAttribute("avatar_url", note.get("author").getAsJsonObject().get("avatar_url").getAsString());
        cmapper.setAuthor(author);
        cmapper.setCreationDate(GitlabTaskAttributeMapper.parseDate(note.get("created_at").getAsString()));
        cmapper.setText(note.get("body").getAsString());
        cmapper.setNumber(Integer.valueOf(++i));
        TaskAttribute attribute = result.createAttribute("task.common.comment-" + i);
        cmapper.applyTo(attribute);
        attribute.createAttribute("system").setValue(note.get("system").getAsString());
        return attribute;
    }

    public void getTaskData(Set<String> taskIds, TaskRepository taskRepository, TaskDataCollector collector, IOperationMonitor monitor) throws GitlabException {
        for (String taskId : taskIds) {
            TaskData data = this.getTaskData(taskRepository, taskId, (IProgressMonitor)monitor);
            collector.accept(data);
        }
    }

    public JsonObject getUser(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/user"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getUsers(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/users" + path){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getNamespaces(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/namespaces"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getGroup(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/groups" + path){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getSubGroups(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/groups" + path + "/subgroups?all_available=true"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getDescendantGroups(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/groups" + path + "/descendant_groups?all_available=true"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getNamespace(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonObject = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/namespaces" + path){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonObject;
    }

    public JsonArray getProjects(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, String.valueOf(path) + "/projects"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getProject(String projectid, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/projects/" + projectid){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getGroupProjects(String projectid, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/groups/" + projectid + "/projects?include_subgroups=true"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getIssues(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, String.valueOf(path) + "/issues"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getIssue(String path, String id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, String.valueOf(path) + "/issues/" + id){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getIssueNotes(String path, String id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, String.valueOf(path) + "/issues/" + id + "/notes?sort=asc"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getIssueDiscussions(String path, String id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, String.valueOf(path) + "/issues/" + id + "/discussions"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getIssueDiscussion(String path, String id, String discussion_id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, String.valueOf(path) + "/issues/" + id + "/discussions/" + discussion_id){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonElement createIssueNote(String path, String id, final String body, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonElement = (JsonObject)new GitlabPostOperation<JsonObject>(this.client, String.valueOf(path) + "/issues/" + id + "/notes"){

            @Override
            protected void addHttpRequestEntities(HttpRequestBase request) throws GitlabException {
                super.addHttpRequestEntities(request);
                request.setHeader("Content-Type", "application/json");
                try {
                    ((HttpPost)request).setEntity((HttpEntity)new StringEntity(body));
                }
                catch (UnsupportedEncodingException e) {
                    throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "UnsupportedEncodingException", (Throwable)e));
                }
            }

            @Override
            protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, GitlabException {
                this.validate(response, 201, monitor);
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonElement;
    }

    public JsonElement updateIssue(String path, String id, String body, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonElement = (JsonObject)new GitlabPutOperation<JsonObject>(this.client, String.valueOf(path) + "/issues/" + id, body){

            @Override
            protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, GitlabException {
                this.validate(response, 200, monitor);
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                StringBuilder result = new StringBuilder();
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonElement;
    }

    public GitlabConfiguration getConfiguration(TaskRepository repository, IOperationMonitor monitor) {
        GitlabConfiguration config = new GitlabConfiguration(repository.getUrl());
        try {
            String[] groupList;
            JsonObject user = this.getUser(monitor);
            config.setUserID(user.get("id").getAsBigInteger());
            config.setUserDetails((JsonElement)user);
            JsonArray projects = this.getProjects("/users/" + config.getUserID(), monitor);
            for (JsonElement project : projects) {
                config.addProject(project);
            }
            String groupsValue = repository.getProperty("gitlab.groups");
            String[] stringArray = groupList = groupsValue.split(",");
            int n = groupList.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                JsonObject groupDetail = this.getGroup("/" + group, monitor);
                config.addGroup((JsonElement)groupDetail);
                projects = this.getGroupProjects(group, monitor);
                for (JsonElement project : projects) {
                    config.addProject(project);
                }
                ++n2;
            }
        }
        catch (GitlabException e) {
            e.printStackTrace();
        }
        return config;
    }

    public RepositoryResponse postTaskData(TaskData taskData, Set<TaskAttribute> oldAttributes, IOperationMonitor monitor) throws GitlabException {
        if (taskData.isNew()) {
            JsonElement result = this.createNewIssue(taskData, monitor);
            JsonObject resObj = (JsonObject)result;
            String newID = resObj.get("iid").getAsString();
            String projectID = resObj.get("project_id").getAsString();
            return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, "/projects/" + projectID + "/issues/" + newID);
        }
        return this.updateExistingIssue(taskData, oldAttributes, monitor);
    }

    private RepositoryResponse updateExistingIssue(TaskData taskData, Set<TaskAttribute> oldAttributes, IOperationMonitor monitor) throws GitlabException {
        ArrayList<String> changedAtributes = new ArrayList<String>();
        String newComentValue = "";
        String discussionsId = "";
        for (TaskAttribute taskAttribute : oldAttributes) {
            TaskAttribute newAttrib;
            String attributeID = taskAttribute.getId();
            if (this.updatable.containsKey(attributeID)) {
                newAttrib = taskData.getRoot().getAttribute(attributeID);
                String newValue = newAttrib.getValue();
                if (attributeID.equals("due_date") && newValue.length() > 0) {
                    newValue = dmyFormat.format(new Date(Long.parseLong(newValue)));
                }
                changedAtributes.add(NLS.bind((String)"\"{0}\":\"{1}\"", (Object)this.updatable.get(attributeID), (Object)newValue));
            }
            if (!GitlabTaskSchema.getDefault().NEW_COMMENT.getKey().equals(taskAttribute.getId())) continue;
            newAttrib = taskData.getRoot().getAttribute(attributeID);
            TaskAttribute noteableIdAttrib = newAttrib.getAttribute("noteable_id");
            TaskAttribute iidAttribute = taskData.getRoot().getAttribute(GitlabTaskSchema.getDefault().IID.getKey());
            discussionsId = iidAttribute.getValue();
            if (noteableIdAttrib != null) {
                newComentValue = "{\"note_id\":" + noteableIdAttrib.getValue() + ",\"body\":\"" + newAttrib.getValue().replaceAll("\n", "\\\\n").replaceAll("\"", "\\\\\"") + "\"}";
                TaskAttribute xx1 = newAttrib.getAttribute("discussions");
                discussionsId = String.valueOf(discussionsId) + "/discussions/" + xx1.getValue();
                continue;
            }
            newComentValue = "{\"body\":\"" + newAttrib.getValue().replaceAll("\n", "\\\n") + "\"}";
        }
        TaskAttribute productAttribute = taskData.getRoot().getAttribute(GitlabTaskSchema.getDefault().PRODUCT.getKey());
        if (productAttribute != null && !productAttribute.getValue().isEmpty()) {
            TaskAttribute iidAttribute = taskData.getRoot().getAttribute(GitlabTaskSchema.getDefault().IID.getKey());
            if (!changedAtributes.isEmpty()) {
                this.updateIssue("/projects/" + productAttribute.getValue(), iidAttribute.getValue(), "{" + String.join((CharSequence)",", changedAtributes) + "}", monitor);
            }
            if (!newComentValue.isEmpty()) {
                this.createIssueNote("/projects/" + productAttribute.getValue(), discussionsId, newComentValue, monitor);
            }
        }
        return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, taskData.getTaskId());
    }

    public JsonElement createNewIssue(final TaskData taskData, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        TaskAttribute productAttribute = taskData.getRoot().getAttribute(GitlabTaskSchema.getDefault().PRODUCT.getKey());
        if (productAttribute == null || productAttribute.getValue().isEmpty()) {
            throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "productAttribute should not be null"));
        }
        JsonObject jsonElement = (JsonObject)new GitlabPostOperation<JsonObject>(this.client, "/projects/" + productAttribute.getValue() + "/issues"){

            @Override
            protected void addHttpRequestEntities(HttpRequestBase request) throws GitlabException {
                super.addHttpRequestEntities(request);
                request.setHeader("Content-Type", "application/json");
                Gson gson = new GsonBuilder().registerTypeAdapter(TaskData.class, (Object)new TaskAttributeTypeAdapter()).create();
                String jsondata = gson.toJson((Object)taskData);
                try {
                    ((HttpPost)request).setEntity((HttpEntity)new StringEntity(jsondata));
                }
                catch (UnsupportedEncodingException e) {
                    throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "UnsupportedEncodingException", (Throwable)e));
                }
            }

            @Override
            protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, GitlabException {
                this.validate(response, 201, monitor);
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonElement;
    }

    public static String convertString2GSonString(String str) {
        str = str.replace("\"", "\\\"").replace("\n", "\\\n");
        StringBuffer ostr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
            } else {
                ostr.append("\\u");
                String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
                int j = 0;
                while (j < 4 - hex.length()) {
                    ostr.append("0");
                    ++j;
                }
                ostr.append(hex.toLowerCase());
            }
            ++i;
        }
        return new String(ostr);
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<TaskData> {
        private JSonTaskDataDeserializer() {
        }

        public TaskData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            GitlabConfiguration config = GitlabRestClient.this.getConfiguration();
            JsonObject jo = json.getAsJsonObject();
            TaskData taskData = GitlabRestClient.this.getFromJson(jo);
            if (config != null) {
                config.updateProductOptions(taskData);
                config.addValidOperations(taskData);
            }
            return taskData;
        }
    }

    private class JSonTaskDataListDeserializer
    implements JsonDeserializer<ArrayList<TaskData>> {
        private JSonTaskDataListDeserializer() {
        }

        public ArrayList<TaskData> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<TaskData> response = new ArrayList<TaskData>();
            GitlabConfiguration config = GitlabRestClient.this.getConfiguration();
            JsonArray ja = json.getAsJsonArray();
            for (JsonElement jsonElement : ja) {
                JsonObject jo = jsonElement.getAsJsonObject();
                TaskData taskData = GitlabRestClient.this.getFromJson(jo);
                if (config != null) {
                    config.updateProductOptions(taskData);
                }
                response.add(taskData);
            }
            return response;
        }
    }

    class TaskAttributeTypeAdapter
    extends TypeAdapter<TaskData> {
        TaskAttributeTypeAdapter() {
        }

        public void write(JsonWriter out, TaskData taskData) throws IOException {
            out.beginObject();
            for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
                String id = taskAttribute.getId();
                String attributValue = GitlabRestClient.convertString2GSonString(taskAttribute.getValue());
                if ("project_id".equals(id = GitlabNewTaskSchema.getJsonNameFromAttributeName(id)) || "state".equals(id)) continue;
                out.name(id).value(attributValue);
            }
            out.endObject();
        }

        public TaskData read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("TaskAttributeTypeAdapter in GitlabRestClient only supports write");
        }
    }
}

