/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.identity.core.IProfileImage;
import org.eclipse.mylyn.commons.identity.core.spi.ProfileImage;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.gitlab.ui.GitlabUiActivator;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.CommentQuoter;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.AbstractReplyToCommentAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.CommentGroupStrategy;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorCommentPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorRichTextPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.UserAttributeEditor;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class GitlabTaskEditorCommentPart
extends TaskEditorCommentPart {
    public List<TaskEditorCommentPart.CommentGroupViewer> getCommentGroupViewers() {
        if (this.commentGroupViewers != null) {
            return this.commentGroupViewers;
        }
        ArrayList<TaskComment> comments = new ArrayList<TaskComment>();
        for (TaskAttribute commentAttribute : this.commentAttributes) {
            comments.add(this.convertToTaskComment(this.getModel(), commentAttribute));
        }
        String currentPersonId = this.getModel().getTaskRepository().getUserName();
        List commentGroups = this.getCommentGroupStrategy().groupComments(comments, currentPersonId);
        this.commentGroupViewers = new ArrayList(commentGroups.size());
        if (commentGroups.size() > 0) {
            int i = 0;
            while (i < commentGroups.size()) {
                GitlabCommentGroupViewer viewer = new GitlabCommentGroupViewer((CommentGroupStrategy.CommentGroup)commentGroups.get(i));
                boolean isLastGroup = i == commentGroups.size() - 1;
                viewer.setRenderedInSubSection(!isLastGroup);
                this.commentGroupViewers.add(viewer);
                ++i;
            }
        }
        return this.commentGroupViewers;
    }

    protected void addActionsToToolbarButton(ToolBarManager toolBarManager, TaskComment taskComment, TaskEditorCommentPart.CommentViewer commentViewer) {
        ReplyToCommentActionWithMenu replyAction = new ReplyToCommentActionWithMenu(commentViewer);
        replyAction.setImageDescriptor(TasksUiImages.COMMENT_REPLY_SMALL);
        toolBarManager.add((IAction)replyAction);
    }

    public class GitlabCommentGroupViewer
    extends TaskEditorCommentPart.CommentGroupViewer {
        private ArrayList<TaskEditorCommentPart.CommentViewer> commentViewers;

        public GitlabCommentGroupViewer(CommentGroupStrategy.CommentGroup commentGroup) {
            super((TaskEditorCommentPart)GitlabTaskEditorCommentPart.this, commentGroup);
        }

        public List<TaskEditorCommentPart.CommentViewer> getCommentViewers() {
            if (this.commentViewers != null) {
                return this.commentViewers;
            }
            this.commentViewers = new ArrayList(this.commentGroup.getCommentAttributes().size());
            for (TaskAttribute commentAttribute : this.commentGroup.getCommentAttributes()) {
                GitlabCommentViewer commentViewer = new GitlabCommentViewer(commentAttribute);
                this.commentViewers.add(commentViewer);
            }
            return this.commentViewers;
        }
    }

    public class GitlabCommentViewer
    extends TaskEditorCommentPart.CommentViewer {
        ArrayList<GitlabCommentViewer> subViewer;

        public GitlabCommentViewer(TaskAttribute commentAttribute) {
            super((TaskEditorCommentPart)GitlabTaskEditorCommentPart.this, commentAttribute);
            this.subViewer = new ArrayList();
        }

        protected void expandComment(FormToolkit toolkit, Composite composite, boolean expanded) {
            this.buttonComposite.setVisible(expanded);
            if (expanded && composite.getData("viewer") == null) {
                String commentAuthor;
                TaskAttribute userImageAttribute;
                Menu mm0 = composite.getMenu();
                this.commentViewer = toolkit.createComposite(composite);
                this.commentViewer.setLayout((Layout)new GridLayout(2, false));
                this.commentViewer.setLayoutData((Object)new GridData(2));
                boolean showAvatar = Boolean.parseBoolean(GitlabTaskEditorCommentPart.this.getModel().getTaskRepository().getProperty("gitlab.avantar"));
                if (showAvatar && (userImageAttribute = this.commentAttribute.getAttribute(commentAuthor = GitlabTaskEditorCommentPart.this.getTaskData().getAttributeMapper().mapToRepositoryKey(this.commentAttribute, "task.common.comment.author"))) != null) {
                    this.userImageComposite = toolkit.createComposite(this.commentViewer);
                    this.userImageComposite.setLayout((Layout)new GridLayout(1, false));
                    GridDataFactory.swtDefaults().align(16384, 1).applyTo((Control)this.userImageComposite);
                    toolkit.paintBordersFor(this.userImageComposite);
                    UserAttributeEditor userImage = new UserAttributeEditor(GitlabTaskEditorCommentPart.this.getModel(), userImageAttribute, 30);
                    userImage.createControl(this.userImageComposite, toolkit);
                    TaskAttribute avatar_url = userImageAttribute.getAttribute("avatar_url");
                    if (avatar_url != null) {
                        GitlabRepositoryConnector gitlabConnector = (GitlabRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector(userImageAttribute.getTaskData().getConnectorKind());
                        byte[] avatarBytes = gitlabConnector.getAvatarData(avatar_url.getValue());
                        userImage.updateImage((IProfileImage)new ProfileImage(avatarBytes, 30, 30, ""));
                    }
                }
                TaskAttribute textAttribute = GitlabTaskEditorCommentPart.this.getTaskData().getAttributeMapper().getAssoctiatedAttribute(this.taskComment.getTaskAttribute());
                this.commentTextEditor = GitlabTaskEditorCommentPart.this.createAttributeEditor(textAttribute);
                if (this.commentTextEditor != null) {
                    this.commentTextEditor.setDecorationEnabled(false);
                    this.commentTextEditor.createControl(this.commentViewer, toolkit);
                    GridData commentGridData = new GridData(768);
                    commentGridData.verticalAlignment = 1;
                    this.commentTextEditor.getControl().setLayoutData((Object)commentGridData);
                    this.commentTextEditor.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            GitlabTaskEditorCommentPart.this.getTaskEditorPage().selectionChanged((Object)GitlabCommentViewer.this.taskComment);
                        }
                    });
                    composite.setData("viewer", (Object)this.commentTextEditor);
                    TaskAttribute reply = this.commentAttribute.getAttribute("reply");
                    if (reply != null) {
                        for (TaskAttribute taskAttributeReply : reply.getAttributes().values()) {
                            TaskComment replyComment = new TaskComment(GitlabTaskEditorCommentPart.this.getModel().getTaskRepository(), GitlabTaskEditorCommentPart.this.getModel().getTask(), taskAttributeReply);
                            this.commentAttribute.getTaskData().getAttributeMapper().updateTaskComment((ITaskComment)replyComment, taskAttributeReply);
                            GitlabCommentViewer replyCommentViewer = new GitlabCommentViewer(taskAttributeReply);
                            this.subViewer.add(replyCommentViewer);
                            replyCommentViewer.createControl(this.commentViewer, toolkit);
                            GridData subViewerGridData = new GridData(1);
                            subViewerGridData.horizontalSpan = 2;
                            replyCommentViewer.getControl().setLayoutData((Object)subViewerGridData);
                        }
                    }
                    GitlabTaskEditorCommentPart.this.getTaskEditorPage().getAttributeEditorToolkit().adapt(this.commentTextEditor);
                    GitlabTaskEditorCommentPart.this.reflow();
                }
            } else if (!expanded && composite.getData("viewer") != null) {
                this.commentTextEditor.getControl().setMenu(null);
                this.commentTextEditor.getControl().dispose();
                if (this.userImageComposite != null) {
                    this.userImageComposite.setMenu(null);
                    this.userImageComposite.dispose();
                }
                if (this.commentViewer != null) {
                    for (GitlabCommentViewer subView : this.subViewer) {
                        if (subView == null) continue;
                        if (subView.commentTextEditor != null && subView.commentTextEditor.getControl() != null && !subView.commentTextEditor.getControl().isDisposed()) {
                            subView.commentTextEditor.getControl().setMenu(null);
                            subView.commentTextEditor.getControl().dispose();
                        }
                        if (subView.userImageComposite != null && subView.userImageComposite.isDisposed()) {
                            subView.userImageComposite.setMenu(null);
                            subView.userImageComposite.dispose();
                        }
                        if (subView.commentViewer == null || subView.commentViewer.isDisposed()) continue;
                        subView.commentViewer.setMenu(null);
                        subView.commentViewer.dispose();
                    }
                    this.commentViewer.setMenu(null);
                    this.commentViewer.dispose();
                }
                composite.setData("viewer", null);
                GitlabTaskEditorCommentPart.this.reflow();
            }
            if (!this.suppressSelectionChanged) {
                GitlabTaskEditorCommentPart.this.getTaskEditorPage().selectionChanged((Object)this.taskComment);
            }
        }

        protected Composite createTitle(final ExpandableComposite commentComposite, FormToolkit toolkit) {
            Composite titleComposite = toolkit.createComposite((Composite)commentComposite);
            commentComposite.setTextClient((Control)titleComposite);
            RowLayout rowLayout = new RowLayout();
            rowLayout.pack = true;
            rowLayout.marginLeft = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginTop = 0;
            rowLayout.center = true;
            titleComposite.setLayout((Layout)rowLayout);
            titleComposite.setBackground(null);
            ImageHyperlink expandCommentHyperlink = this.createTitleHyperLink(toolkit, titleComposite, (ITaskComment)this.taskComment);
            expandCommentHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    CommonFormUtil.setExpanded((ExpandableComposite)commentComposite, (!commentComposite.isExpanded() ? 1 : 0) != 0);
                }
            });
            TaskAttribute systemAttribute = this.taskComment.getTaskAttribute().getAttribute("system");
            String systemAttributeValue = systemAttribute != null ? systemAttribute.getValue() : "false";
            boolean showCommentIcons = Boolean.parseBoolean(GitlabTaskEditorCommentPart.this.getModel().getTaskRepository().getProperty("gitlab.show.comment.icons"));
            if (showCommentIcons) {
                if ("true".equals(systemAttributeValue)) {
                    expandCommentHyperlink.setImage(GitlabUiActivator.getDefault().getImageRegistry().get(GitlabUiActivator.GITLAB_PICTURE_FILE));
                } else {
                    IRepositoryPerson author = this.taskComment.getAuthor();
                    if (author != null && author.matchesUsername(GitlabTaskEditorCommentPart.this.getTaskEditorPage().getTaskRepository().getUserName())) {
                        expandCommentHyperlink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME));
                    } else {
                        expandCommentHyperlink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.PERSON));
                    }
                }
            } else {
                expandCommentHyperlink.setImage(null);
            }
            ToolBarManager toolBarManagerTitle = new ToolBarManager(0x800000);
            GitlabTaskEditorCommentPart.this.addActionsToToolbarTitle(toolBarManagerTitle, this.taskComment, this);
            toolBarManagerTitle.createControl(titleComposite);
            Composite buttonComposite = toolkit.createComposite(titleComposite);
            RowLayout buttonCompLayout = new RowLayout();
            buttonCompLayout.marginBottom = 0;
            buttonCompLayout.marginTop = 0;
            buttonComposite.setLayout((Layout)buttonCompLayout);
            buttonComposite.setBackground(null);
            buttonComposite.setVisible(commentComposite.isExpanded());
            ToolBarManager toolBarManagerButton = new ToolBarManager(0x800000);
            GitlabTaskEditorCommentPart.this.addActionsToToolbarButton(toolBarManagerButton, this.taskComment, this);
            toolBarManagerButton.createControl(buttonComposite);
            return buttonComposite;
        }
    }

    private class ReplyToCommentAction
    extends AbstractReplyToCommentAction {
        private final AbstractTaskEditorPage editor;
        private final TaskEditorCommentPart.CommentViewer commentViewerGitlab;

        public ReplyToCommentAction(TaskEditorCommentPart.CommentViewer commentViewer) {
            super(GitlabTaskEditorCommentPart.this.getTaskEditorPage(), (ITaskComment)commentViewer.getTaskComment());
            this.editor = GitlabTaskEditorCommentPart.this.getTaskEditorPage();
            this.commentViewerGitlab = commentViewer;
        }

        protected String getReplyText() {
            return this.commentViewerGitlab.getReplyToText();
        }

        protected TaskEditorCommentPart.CommentViewer getCommentViewer() {
            return this.commentViewerGitlab;
        }

        public void run() {
            ReplyToCommentAction.reply(this.editor, (ITaskComment)this.getCommentViewer().getTaskComment(), this.getReplyText());
        }

        public void dispose() {
        }

        public static void reply(AbstractTaskEditorPage editor, ITaskComment taskComment, String text) {
            AbstractTaskEditorPart newCommentPart;
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi((String)editor.getConnectorKind());
            String reference = connectorUi.getReplyText(editor.getTaskRepository(), editor.getTask(), taskComment, false);
            StringBuilder sb = new StringBuilder();
            sb.append(reference);
            sb.append("\n");
            if (text != null) {
                CommentQuoter quoter = new CommentQuoter();
                sb.append(quoter.quote(text));
            }
            if ((newCommentPart = editor.getPart("org.eclipse.mylyn.tasks.ui.editors.parts.newComment")) instanceof TaskEditorRichTextPart) {
                TaskAttribute newCommentAttrib = ((TaskEditorRichTextPart)newCommentPart).getAttribute();
                TaskAttribute newCommentDiscussion = newCommentAttrib.getAttribute("discussions");
                TaskAttribute newCommentNoteable = newCommentAttrib.getAttribute("noteable_id");
                TaskAttribute newCommentNoteID = newCommentAttrib.getAttribute("note_id");
                TaskAttribute commentDiscussion = taskComment.getTaskAttribute().getAttribute("discussions");
                TaskAttribute commentNoteable = taskComment.getTaskAttribute().getAttribute("noteable_id");
                TaskAttribute commentNoteID = taskComment.getTaskAttribute().getAttribute("note_id");
                if (newCommentDiscussion == null) {
                    newCommentDiscussion = newCommentAttrib.createAttribute("discussions");
                }
                if (newCommentNoteable == null) {
                    newCommentNoteable = newCommentAttrib.createAttribute("noteable_id");
                }
                if (newCommentNoteID == null) {
                    newCommentNoteID = newCommentAttrib.createAttribute("note_id");
                }
                newCommentDiscussion.setValue(commentDiscussion.getValue());
                newCommentNoteable.setValue(commentNoteable.getValue());
                newCommentNoteID.setValue(commentNoteID.getValue());
            }
            editor.appendTextToNewComment(sb.toString());
        }
    }

    private class ReplyToCommentActionWithMenu
    extends ReplyToCommentAction
    implements IMenuCreator {
        public ReplyToCommentActionWithMenu(TaskEditorCommentPart.CommentViewer commentViewer) {
            super(commentViewer);
            this.setMenuCreator(this);
        }

        public Menu getMenu(Control parent) {
            GitlabTaskEditorCommentPart.this.setCurrentViewer(this.getCommentViewer());
            GitlabTaskEditorCommentPart.this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)GitlabTaskEditorCommentPart.this.getCurrentViewer().getTaskComment()));
            return GitlabTaskEditorCommentPart.this.getCommentMenu();
        }

        public Menu getMenu(Menu parent) {
            GitlabTaskEditorCommentPart.this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.getCommentViewer().getTaskComment()));
            return GitlabTaskEditorCommentPart.this.getCommentMenu();
        }
    }
}

