/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.ui;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.mylyn.internal.gitlab.ui.GitlabTaskEditorCommentPart;
import org.eclipse.mylyn.internal.gitlab.ui.GitlabTaskEditorSummaryPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorNewCommentPart;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;

public class GitlabTaskEditorPage
extends AbstractTaskEditorPage {
    public GitlabTaskEditorPage(TaskEditor editor) {
        this(editor, "org.eclipse.mylyn.gitlab");
    }

    public GitlabTaskEditorPage(TaskEditor editor, String connectorKind) {
        super(editor, connectorKind);
        this.setNeedsPrivateSection(false);
        this.setNeedsSubmitButton(true);
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        return super.createAttributeEditorFactory();
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set descriptors = super.createPartDescriptors();
        ArrayList<TaskEditorPartDescriptor> descriptorsToRemove = new ArrayList<TaskEditorPartDescriptor>(2);
        boolean hasCommentPart = false;
        boolean hasNewCommentPart = false;
        for (TaskEditorPartDescriptor taskEditorPartDescriptor : descriptors) {
            if (!taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.comments") && !taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.newComment") && !taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.summary")) continue;
            hasCommentPart = hasCommentPart || taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.comments");
            hasNewCommentPart = hasNewCommentPart || taskEditorPartDescriptor.getId().equals("org.eclipse.mylyn.tasks.ui.editors.parts.newComment");
            descriptorsToRemove.add(taskEditorPartDescriptor);
        }
        descriptors.removeAll(descriptorsToRemove);
        descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.summary"){

            public AbstractTaskEditorPart createPart() {
                return new GitlabTaskEditorSummaryPart();
            }
        }.setPath("header"));
        if (hasCommentPart) {
            descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.comments"){

                public AbstractTaskEditorPart createPart() {
                    return new GitlabTaskEditorCommentPart();
                }
            }.setPath("comments"));
        }
        if (hasCommentPart) {
            descriptors.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.tasks.ui.editors.parts.newComment"){

                public AbstractTaskEditorPart createPart() {
                    return new TaskEditorNewCommentPart();
                }
            }.setPath("comments"));
        }
        return descriptors;
    }
}

