/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.wizard;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.internal.trac.ui.wizard.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TracFilterQueryPage
extends AbstractRepositoryQueryPage {
    private static final String TITLE = Messages.TracFilterQueryPage_New_Trac_Query;
    private static final String DESCRIPTION = Messages.TracFilterQueryPage_Add_search_filters_to_define_query;
    private static final String TITLE_QUERY_TITLE = Messages.TracFilterQueryPage_Query_Title;
    private Text titleText;
    private Composite scrollComposite;
    private final Set<SearchField> visibleSearchFields = new LinkedHashSet<SearchField>();
    private List<SearchField> searchFields;

    public TracFilterQueryPage(TaskRepository repository, IRepositoryQuery query) {
        super(TITLE, repository, query);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
    }

    public void applyTo(IRepositoryQuery query) {
        query.setUrl(this.getQueryUrl(this.getTaskRepository().getRepositoryUrl()));
        query.setSummary(this.getQueryTitle());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData());
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createTitleGroup(composite);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 2560);
        GridData gd = new GridData(4, 4, true, true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setLayoutData((Object)gd);
        this.scrollComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.scrollComposite);
        this.scrollComposite.setLayout((Layout)new GridLayout(4, false));
        this.createAddFilterGroup(composite);
        if (this.getQuery() != null) {
            this.titleText.setText(this.getQuery().getSummary());
            TracSearch search = TracUtil.toTracSearch((IRepositoryQuery)this.getQuery());
            if (search != null) {
                this.restoreWidgetValues(search);
            }
        }
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    public String getQueryTitle() {
        return this.titleText != null ? this.titleText.getText() : null;
    }

    private void restoreWidgetValues(TracSearch search) {
        List filters = search.getFilters();
        for (TracSearchFilter filter : filters) {
            SearchField field = this.getSearchField(filter.getFieldName());
            if (field != null) {
                this.showSearchField(field, filter);
                continue;
            }
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.ui", "Ignoring invalid search filter: " + filter));
        }
    }

    private SearchField getSearchField(String fieldName) {
        for (SearchField searchField : this.searchFields) {
            if (!searchField.getFieldName().equals(fieldName)) continue;
            return searchField;
        }
        return null;
    }

    private void createAddFilterGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(769);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 16384);
        label.setText(Messages.TracFilterQueryPage_Select_to_add_filter);
        final Combo filterCombo = new Combo(composite, 2060);
        this.searchFields = new ArrayList<SearchField>();
        this.searchFields.add(new TextSearchField("summary", Messages.TracFilterQueryPage_Summary));
        this.searchFields.add(new TextSearchField("reporter", Messages.TracFilterQueryPage_Reporter));
        this.searchFields.add(new TextSearchField("owner", Messages.TracFilterQueryPage_Owner));
        this.searchFields.add(new TextSearchField("type", Messages.TracFilterQueryPage_Type));
        this.searchFields.add(new TextSearchField("status", Messages.TracFilterQueryPage_Status));
        this.searchFields.add(new TextSearchField("priority", Messages.TracFilterQueryPage_Priority));
        this.searchFields.add(new TextSearchField("milestone", Messages.TracFilterQueryPage_Milestone));
        this.searchFields.add(new TextSearchField("component", Messages.TracFilterQueryPage_Component));
        this.searchFields.add(new TextSearchField("version", Messages.TracFilterQueryPage_Version));
        this.searchFields.add(new TextSearchField("resoution", Messages.TracFilterQueryPage_Resolution));
        this.searchFields.add(new TextSearchField("keywords", Messages.TracFilterQueryPage_Keywords));
        this.searchFields.add(new TextSearchField("cc", Messages.TracFilterQueryPage_CC));
        filterCombo.add("");
        for (SearchField field : this.searchFields) {
            filterCombo.add(field.getDisplayName());
        }
        filterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (filterCombo.getText().length() > 0) {
                    SearchField field = TracFilterQueryPage.this.searchFields.get(filterCombo.getSelectionIndex() - 1);
                    TracFilterQueryPage.this.showSearchField(field, null);
                    filterCombo.setText("");
                }
            }
        });
    }

    private void createTitleGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText(TITLE_QUERY_TITLE);
        group.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        this.titleText = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.titleText.setLayoutData((Object)gd);
        this.titleText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                TracFilterQueryPage.this.getContainer().updateButtons();
            }
        });
    }

    public boolean isPageComplete() {
        return this.titleText != null && this.titleText.getText().length() > 0;
    }

    private void showSearchField(SearchField field, TracSearchFilter filter) {
        assert (filter == null || !this.visibleSearchFields.contains(field));
        if (!this.visibleSearchFields.contains(field)) {
            field.createControls(this.scrollComposite, filter);
            this.visibleSearchFields.add(field);
        } else {
            field.addControl(this.scrollComposite);
        }
        this.updateScrollPane();
    }

    public String getQueryUrl(String repsitoryUrl) {
        TracSearch search = new TracSearch();
        for (SearchField field : this.visibleSearchFields) {
            search.addFilter(field.getFilter());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(repsitoryUrl);
        sb.append("/query?format=tab");
        sb.append(search.toUrl());
        return sb.toString();
    }

    private void hideSearchField(SearchField field) {
        this.visibleSearchFields.remove(field);
    }

    private void updateScrollPane() {
        this.scrollComposite.setSize(this.scrollComposite.computeSize(-1, -1));
        this.scrollComposite.layout();
    }

    private abstract class SearchField {
        protected String fieldName;
        private final String displayName;

        public SearchField(String fieldName, String displayName) {
            this.fieldName = fieldName;
            this.displayName = displayName;
        }

        public abstract void createControls(Composite var1, TracSearchFilter var2);

        public abstract void addControl(Composite var1);

        public String getFieldName() {
            return this.fieldName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public abstract TracSearchFilter getFilter();
    }

    private class TextSearchField
    extends SearchField {
        private final TracSearchFilter.CompareOperator[] compareOperators;
        private List<TextCriterion> criterions;

        public TextSearchField(String fieldName, String displayName) {
            super(fieldName, displayName);
            this.compareOperators = new TracSearchFilter.CompareOperator[]{TracSearchFilter.CompareOperator.CONTAINS, TracSearchFilter.CompareOperator.CONTAINS_NOT, TracSearchFilter.CompareOperator.BEGINS_WITH, TracSearchFilter.CompareOperator.ENDS_WITH, TracSearchFilter.CompareOperator.IS, TracSearchFilter.CompareOperator.IS_NOT};
        }

        @Override
        public void createControls(Composite parent, TracSearchFilter filter) {
            if (filter != null) {
                TextCriterion first = this.addCriterion(parent);
                first.setCondition(filter.getOperator());
                List values = filter.getValues();
                if (!values.isEmpty()) {
                    first.setSearchText((String)values.get(0));
                    int i = 1;
                    while (i < values.size()) {
                        TextCriterion criterion = this.addCriterion(parent);
                        criterion.setSearchText((String)values.get(1));
                        ++i;
                    }
                }
            } else {
                this.addCriterion(parent);
            }
        }

        @Override
        public void addControl(Composite parent) {
            this.addCriterion(parent);
        }

        public TextCriterion addCriterion(Composite parent) {
            TextCriterion criterion = new TextCriterion();
            if (this.criterions == null) {
                this.criterions = new ArrayList<TextCriterion>();
                criterion.createControl(parent);
            } else {
                criterion.createControl(parent, this.criterions.get(this.criterions.size() - 1));
            }
            this.criterions.add(criterion);
            return criterion;
        }

        @Override
        public TracSearchFilter getFilter() {
            TracSearchFilter newFilter = new TracSearchFilter(this.getFieldName());
            newFilter.setOperator(this.criterions.get(0).getCondition());
            for (TextCriterion criterion : this.criterions) {
                newFilter.addValue(criterion.getSearchText());
            }
            return newFilter;
        }

        public void removeCriterion(TextCriterion criterion) {
            int i = this.criterions.indexOf(criterion);
            if (i == -1) {
                throw new RuntimeException();
            }
            if (i == 0) {
                if (this.criterions.size() > 1) {
                    TextCriterion sourceCriterion = this.criterions.get(1);
                    criterion.searchText.setText(sourceCriterion.searchText.getText());
                    this.removeCriterionByIndex(1);
                } else {
                    this.removeCriterionByIndex(0);
                    TracFilterQueryPage.this.hideSearchField(this);
                }
            } else {
                this.removeCriterionByIndex(i);
            }
        }

        private void removeCriterionByIndex(int i) {
            this.criterions.get(i).remove();
            this.criterions.remove(i);
            TracFilterQueryPage.this.updateScrollPane();
        }

        private class TextCriterion {
            private Combo conditionCombo;
            private Text searchText;
            private Label label;
            private Button removeButton;

            private TextCriterion() {
            }

            public void createControl(Composite parent) {
                this.label = new Label(parent, 16384);
                this.label.setText(String.valueOf(TextSearchField.this.getDisplayName()) + ": ");
                this.conditionCombo = new Combo(parent, 2060);
                TracSearchFilter.CompareOperator[] compareOperatorArray = TextSearchField.this.compareOperators;
                int n = TextSearchField.this.compareOperators.length;
                int n2 = 0;
                while (n2 < n) {
                    TracSearchFilter.CompareOperator op = compareOperatorArray[n2];
                    this.conditionCombo.add(op.toString());
                    ++n2;
                }
                this.conditionCombo.setText(TextSearchField.this.compareOperators[0].toString());
                this.createSearchTextAndRemoveButton(parent);
            }

            public void createControl(Composite parent, TextCriterion top) {
                this.label = new Label(parent, 131072);
                GridData gd = new GridData();
                gd.horizontalAlignment = 0x1000008;
                gd.horizontalSpan = 2;
                this.label.setLayoutData((Object)gd);
                this.label.setText(Messages.TracFilterQueryPage_or);
                this.createSearchTextAndRemoveButton(parent);
                this.label.moveBelow((Control)top.removeButton);
                this.searchText.moveBelow((Control)this.label);
                this.removeButton.moveBelow((Control)this.searchText);
            }

            private void createSearchTextAndRemoveButton(Composite parent) {
                this.searchText = new Text(parent, 2048);
                GridData gd = new GridData(768);
                this.searchText.setLayoutData((Object)gd);
                this.removeButton = new Button(parent, 8);
                this.removeButton.setText("-");
                this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextSearchField.this.removeCriterion(TextCriterion.this);
                    }
                });
            }

            public void remove() {
                this.label.dispose();
                if (this.conditionCombo != null) {
                    this.conditionCombo.dispose();
                }
                this.searchText.dispose();
                this.removeButton.dispose();
            }

            public TracSearchFilter.CompareOperator getCondition() {
                return this.conditionCombo != null ? TextSearchField.this.compareOperators[this.conditionCombo.getSelectionIndex()] : null;
            }

            public String getSearchText() {
                return this.searchText.getText();
            }

            public boolean setCondition(TracSearchFilter.CompareOperator operator) {
                int i;
                if (this.conditionCombo != null && (i = this.conditionCombo.indexOf(operator.toString())) != -1) {
                    this.conditionCombo.select(i);
                    return true;
                }
                return false;
            }

            public void setSearchText(String text) {
                this.searchText.setText(text);
            }
        }
    }
}

