/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gitlab.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.core.operations.OperationUtil;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpClient;
import org.eclipse.mylyn.commons.repositories.http.core.CommonHttpResponse;
import org.eclipse.mylyn.gitlab.core.GitlabConfiguration;
import org.eclipse.mylyn.gitlab.core.GitlabCoreActivator;
import org.eclipse.mylyn.gitlab.core.GitlabException;
import org.eclipse.mylyn.internal.gitlab.core.GitlabActivityStyle;
import org.eclipse.mylyn.internal.gitlab.core.GitlabJSonArrayOperation;
import org.eclipse.mylyn.internal.gitlab.core.GitlabNewTaskSchema;
import org.eclipse.mylyn.internal.gitlab.core.GitlabOperation;
import org.eclipse.mylyn.internal.gitlab.core.GitlabPostOperation;
import org.eclipse.mylyn.internal.gitlab.core.GitlabPutOperation;
import org.eclipse.mylyn.internal.gitlab.core.GitlabRepositoryConnector;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskAttributeMapper;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskDataHandler;
import org.eclipse.mylyn.internal.gitlab.core.GitlabTaskSchema;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.mylyn.tasks.core.data.DefaultTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.osgi.util.NLS;

public class GitlabRestClient {
    private final CommonHttpClient client;
    private final GitlabRepositoryConnector connector;
    private final TaskRepository taskRepository;
    private static final Pattern linkPattern = Pattern.compile("\\[(.+)\\]\\((.+)\\)");
    public static String AUTHORIZATION_HEADER = "authorization_header";
    private final Type listOfMyClassObject = new TypeToken<ArrayList<GitlabActivityStyle>>(){}.getType();
    private final Gson gson = new Gson();
    Map<String, String> updatable;
    private static SimpleDateFormat dmyFormat = new SimpleDateFormat("yyyy-MM-dd");

    public GitlabRestClient(RepositoryLocation location, GitlabRepositoryConnector connector, TaskRepository taskRepository) {
        this.updatable = Map.ofEntries(Map.entry(GitlabTaskSchema.getDefault().SUMMARY.getKey(), "title"), Map.entry(GitlabTaskSchema.getDefault().DESCRIPTION.getKey(), "description"), Map.entry(GitlabTaskSchema.getDefault().DISCUSSION_LOCKED.getKey(), GitlabTaskSchema.getDefault().DISCUSSION_LOCKED.getKey()), Map.entry(GitlabTaskSchema.getDefault().CONFIDENTIAL.getKey(), GitlabTaskSchema.getDefault().CONFIDENTIAL.getKey()), Map.entry(GitlabTaskSchema.getDefault().ISSUE_TYPE.getKey(), GitlabTaskSchema.getDefault().ISSUE_TYPE.getKey()), Map.entry(GitlabTaskSchema.getDefault().OPERATION.getKey(), "state_event"), Map.entry(GitlabTaskSchema.getDefault().DUE_DATE.getKey(), GitlabTaskSchema.getDefault().DUE_DATE.getKey()), Map.entry(GitlabTaskSchema.getDefault().TASK_LABELS.getKey(), GitlabTaskSchema.getDefault().TASK_LABELS.getKey()), Map.entry(GitlabTaskSchema.getDefault().TASK_MILESTONE.getKey(), "milestone_id"));
        this.client = new CommonHttpClient(location);
        this.connector = connector;
        this.taskRepository = taskRepository;
    }

    public RepositoryLocation getLocation() {
        return this.client.getLocation();
    }

    public CommonHttpClient getClient() {
        return this.client;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public IStatus getIssues(IRepositoryQuery query, TaskDataCollector collector, IOperationMonitor monitor) throws GitlabException, CoreException {
        String[] gueryGroups;
        int n;
        if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
            GitlabCoreActivator.DEBUG_TRACE.traceEntry("/debug/rest/client", (Object)(query.toString() + " " + query.getSummary()));
        }
        this.getAccessTokenIfNotPresent(monitor);
        String[] queryProjects = query.getAttribute(GitlabTaskSchema.getDefault().PRODUCT.getKey()).split(",");
        String groupAttribute = query.getAttribute("group");
        if (!queryProjects[0].isEmpty()) {
            String[] stringArray = queryProjects;
            n = queryProjects.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String path = "/projects/" + string.replace("/", "%2F");
                this.getIssuesInternal(query, collector, path, monitor);
                ++n2;
            }
        }
        if (groupAttribute != null && !(gueryGroups = groupAttribute.split(","))[0].isEmpty()) {
            String[] stringArray = gueryGroups;
            int n3 = gueryGroups.length;
            n = 0;
            while (n < n3) {
                String string = stringArray[n];
                String path = "/groups/" + string.replace("/", "%2F");
                this.getIssuesInternal(query, collector, path, monitor);
                ++n;
            }
        }
        if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
            GitlabCoreActivator.DEBUG_TRACE.traceExit("/debug/rest/client");
        }
        return Status.OK_STATUS;
    }

    private void getIssuesInternal(final IRepositoryQuery query, final TaskDataCollector collector, String path, IOperationMonitor monitor) throws GitlabException {
        List taskDataArray = (List)new GitlabOperation<List<TaskData>>(this.client, path + "/issues"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                String state = query.getAttribute("STATE");
                ArrayList<Object> suffix = new ArrayList<Object>();
                switch (state != null ? state : "") {
                    case "opened": {
                        suffix.add("state=opened");
                        break;
                    }
                    case "closed": {
                        suffix.add("state=closed");
                    }
                }
                String search = query.getAttribute("SEARCH");
                if (search != null && !search.isBlank()) {
                    try {
                        suffix.add("search=" + URLEncoder.encode(search, StandardCharsets.UTF_8.toString()));
                        String searchIn = query.getAttribute("SEARCH_IN");
                        if (searchIn != null && !searchIn.isBlank()) {
                            suffix.add("in=" + searchIn);
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                if (Boolean.parseBoolean(query.getAttribute("CONFIDENTIAL"))) {
                    suffix.add("confidential=true");
                }
                if (Boolean.parseBoolean(query.getAttribute("ASSIGNED_TO_ME"))) {
                    suffix.add("scope=assigned_to_me");
                }
                String suffixStr = suffix.size() > 0 ? "?" + String.join((CharSequence)"&", suffix) : "";
                HttpGet request = new HttpGet(url + suffixStr);
                return request;
            }

            private String nextPage(Header[] linkHeader) {
                if (linkHeader.length > 0) {
                    Header firstLinkHeader = linkHeader[0];
                    String[] stringArray = firstLinkHeader.getValue().split(", ");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String linkHeaderEntry = stringArray[n2];
                        String[] linkHeaderElements = linkHeaderEntry.split("; ");
                        if ("rel=\"next\"".equals(linkHeaderElements[1])) {
                            return linkHeaderElements[0].substring(1, linkHeaderElements[0].length() - 1);
                        }
                        ++n2;
                    }
                }
                return null;
            }

            @Override
            protected List<TaskData> execute(IOperationMonitor monitor) throws IOException, GitlabException {
                List result = null;
                HttpRequestBase request = this.createHttpRequestBase();
                this.addHttpRequestEntities(request);
                CommonHttpResponse response = this.execute(request, monitor);
                result = (List)this.processAndRelease(response, monitor);
                Header[] linkHeader = response.getResponse().getHeaders("Link");
                String nextPageValue = this.nextPage(linkHeader);
                while (nextPageValue != null) {
                    HttpGet looprequest = new HttpGet(nextPageValue);
                    this.addHttpRequestEntities((HttpRequestBase)looprequest);
                    CommonHttpResponse loopresponse = this.execute((HttpRequestBase)looprequest, monitor);
                    List loopresult = (List)this.processAndRelease(loopresponse, monitor);
                    result.addAll(loopresult);
                    linkHeader = loopresponse.getResponse().getHeaders("Link");
                    nextPageValue = this.nextPage(linkHeader);
                }
                return result;
            }

            @Override
            protected List<TaskData> parseFromJson(InputStreamReader in) throws GitlabException {
                TypeToken<List<TaskData>> type = new TypeToken<List<TaskData>>(){};
                return (List)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataListDeserializer()).create().fromJson((Reader)in, type.getType());
            }
        }.run(monitor);
        for (final TaskData taskData : taskDataArray) {
            taskData.setPartial(true);
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    collector.accept(taskData);
                }

                public void handleException(Throwable exception) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", NLS.bind((String)"Unexpected error during result collection. TaskID {0} in repository {1}", (Object)taskData.getTaskId(), (Object)taskData.getRepositoryUrl()), exception));
                }
            });
        }
    }

    public String getVersion(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject versionInfo = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/version"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return versionInfo.get("version").getAsString();
    }

    public String getVersionAndRevision(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject versionInfo = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/version"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return versionInfo.get("version").getAsString() + "(rev: " + versionInfo.get("revision").getAsString() + ")";
    }

    public boolean validate(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        String validate = (String)new GitlabOperation<String>(this.client, "/version"){

            protected boolean isRepeatable() {
                return false;
            }

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected String parseFromJson(InputStreamReader in) throws GitlabException {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (BufferedReader bufferedReader = new BufferedReader(in);){
                        return ((Stream)bufferedReader.lines().parallel()).collect(Collectors.joining("\n"));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", e.getMessage(), (Throwable)e));
                }
            }
        }.run(monitor);
        return validate.length() > 0 && validate.contains("version");
    }

    public JsonObject getMetadata(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/metadata"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    private TaskData getFromJson(JsonObject jo) {
        GitlabTaskDataHandler dataHandler = (GitlabTaskDataHandler)this.connector.getTaskDataHandler();
        TaskAttributeMapper mapper = dataHandler.getAttributeMapper(this.taskRepository);
        String selfString = jo.get("_links").getAsJsonObject().get("self").getAsString();
        TaskData response = new TaskData(mapper, this.connector.getConnectorKind(), this.taskRepository.getRepositoryUrl(), selfString.replace(this.taskRepository.getUrl() + "/api/v4", ""));
        try {
            dataHandler.initializeTaskData(this.taskRepository, response, null, null);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry entry : jo.entrySet()) {
            String attributeId = GitlabTaskSchema.getAttributeNameFromJsonName((String)entry.getKey());
            TaskAttribute attribute = response.getRoot().getAttribute(attributeId);
            AbstractTaskSchema.Field field = GitlabTaskSchema.getDefault().getFieldByKey(attributeId);
            if (attribute != null && entry.getValue() != null && ((JsonElement)entry.getValue()).isJsonPrimitive()) {
                attribute.setValue(((JsonElement)entry.getValue()).getAsString());
            }
            if (attribute != null && entry.getValue() != null && ((JsonElement)entry.getValue()).isJsonArray()) {
                for (JsonElement arrayElement : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                    attribute.addValue(arrayElement.getAsString());
                }
            }
            if (field != null && "person".equals(field.getType()) && ((JsonElement)entry.getValue()).isJsonObject()) {
                JsonObject personObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                attribute.setValue(personObject.get("name").getAsString());
                IRepositoryPerson author = this.taskRepository.createPerson(personObject.get("username").getAsString());
                author.setName(personObject.get("name").getAsString());
                author.setAttribute("avatar_url", personObject.get("avatar_url").getAsString());
                mapper.setRepositoryPerson(attribute, author);
            }
            if (!GitlabTaskSchema.getDefault().TASK_MILESTONE.getKey().equals(attributeId) || attribute == null || entry.getValue() == null || !((JsonElement)entry.getValue()).isJsonObject()) continue;
            JsonObject obj = (JsonObject)entry.getValue();
            attribute.setValue(obj.get("id").getAsString());
        }
        return response;
    }

    private GitlabConfiguration getConfiguration() {
        GitlabConfiguration config;
        try {
            config = this.connector.getRepositoryConfiguration(this.taskRepository);
        }
        catch (CoreException e) {
            e.printStackTrace();
            config = null;
        }
        return config;
    }

    private void getAccessTokenIfNotPresent(IOperationMonitor monitor) throws GitlabException {
        if (this.getClientAttribute(AUTHORIZATION_HEADER) == null) {
            try {
                this.obtainAccessToken(monitor);
            }
            catch (Exception e) {
                throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "Exception", (Throwable)e));
            }
        }
    }

    private Object getClientAttribute(String attribute) {
        return this.getClient().getAttribute(attribute);
    }

    private void setClientAttribute(String attribute, Object value) {
        this.getClient().setAttribute(attribute, value);
    }

    public String obtainAccessToken(IOperationMonitor monitor) throws Exception {
        String accessToken;
        if (Boolean.parseBoolean(this.taskRepository.getProperty("gitlab.use.personal.access.token"))) {
            accessToken = this.taskRepository.getProperty("gitlab.personal.access.token");
        } else {
            AuthenticationCredentials credentials1 = this.taskRepository.getCredentials(AuthenticationType.REPOSITORY);
            URL url = new URL(this.taskRepository.getRepositoryUrl() + "/oauth/token");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.getOutputStream().write(("grant_type=password&username=" + credentials1.getUserName() + "&password=" + credentials1.getPassword()).getBytes());
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new Exception("Failed to obtain access token");
            }
            String response = new String(connection.getInputStream().readAllBytes());
            accessToken = response.split("\"access_token\":\"")[1].split("\"")[0];
        }
        this.setClientAttribute(AUTHORIZATION_HEADER, "Bearer " + accessToken);
        return accessToken;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws GitlabException {
        String searchString;
        Pattern pattern;
        Matcher matcher;
        Object result = null;
        if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
            GitlabCoreActivator.DEBUG_TRACE.traceEntry("/debug/rest/client", (Object)(repository.getUrl() + " id " + taskId));
        }
        if ((matcher = (pattern = Pattern.compile(searchString = ".*(/projects/\\d+)/issues/(\\d+)", 2)).matcher(taskId)).find()) {
            GitlabConfiguration config = this.getConfiguration();
            if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get Configuration ");
            }
            JsonObject issue = this.getIssue(matcher.group(1), matcher.group(2), OperationUtil.convert((IProgressMonitor)monitor));
            if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get Issue with path " + matcher.group(1) + " an ID " + matcher.group(2));
            }
            TypeToken<TaskData> type = new TypeToken<TaskData>(){};
            result = (TaskData)new GsonBuilder().registerTypeAdapter(type.getType(), (Object)new JSonTaskDataDeserializer()).create().fromJson((JsonElement)issue, type.getType());
            JsonArray discussions = this.getIssueDiscussions(matcher.group(1), matcher.group(2), OperationUtil.convert((IProgressMonitor)monitor));
            if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get IssueDiscussions with path " + matcher.group(1) + " an ID " + matcher.group(2));
            }
            if (discussions != null) {
                int commentIdx = 0;
                TaskAttribute attrib = null;
                for (Object jsonElement : discussions) {
                    JsonObject discussion = (JsonObject)jsonElement;
                    JsonArray notesArray = discussion.get("notes").getAsJsonArray();
                    if (discussion.get("individual_note").getAsBoolean()) {
                        JsonObject note = notesArray.get(0).getAsJsonObject();
                        if (!note.get("system").getAsBoolean()) {
                            attrib = this.createNoteTaskAttribute(repository, result.getRoot(), commentIdx++, note);
                            attrib.createAttribute("discussions").setValue(discussion.get("id").getAsString());
                            attrib.createAttribute("noteable_id").setValue(note.get("noteable_id").getAsString());
                            attrib.createAttribute("note_id").setValue(note.get("id").getAsString());
                            continue;
                        }
                        attrib = this.createActivityEventTaskAttribute(repository, result.getRoot(), note);
                        attrib.createAttribute("discussions").setValue(discussion.get("id").getAsString());
                        attrib.createAttribute("noteable_id").setValue(note.get("noteable_id").getAsString());
                        attrib.createAttribute("note_id").setValue(note.get("id").getAsString());
                        continue;
                    }
                    TaskAttribute reply = null;
                    for (JsonElement jsonElement2 : notesArray) {
                        JsonObject note = jsonElement2.getAsJsonObject();
                        if (!note.get("system").getAsBoolean()) {
                            attrib = this.createNoteTaskAttribute(repository, reply == null ? result.getRoot() : reply, commentIdx++, note);
                            if (reply == null) {
                                reply = attrib.createAttribute("reply");
                            }
                            attrib.createAttribute("discussions").setValue(discussion.get("id").getAsString());
                            attrib.createAttribute("noteable_id").setValue(note.get("noteable_id").getAsString());
                            attrib.createAttribute("note_id").setValue(note.get("id").getAsString());
                            continue;
                        }
                        attrib = this.createActivityEventTaskAttribute(repository, result.getRoot(), note);
                        attrib.createAttribute("discussions").setValue(discussion.get("id").getAsString());
                        attrib.createAttribute("noteable_id").setValue(note.get("noteable_id").getAsString());
                        attrib.createAttribute("note_id").setValue(note.get("id").getAsString());
                    }
                }
            }
            JsonArray states = this.getIssueStateEvents(matcher.group(1), matcher.group(2), OperationUtil.convert((IProgressMonitor)monitor));
            if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get IssueStateEvents with path " + matcher.group(1) + " an ID " + matcher.group(2));
            }
            if (states != null) {
                for (JsonElement stateElem : states) {
                    JsonObject state = (JsonObject)stateElem;
                    Instant instant = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(state.get("created_at").getAsString()));
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, TimeZone.getDefault().toZoneId());
                    TaskAttribute taskAttribute = result.getRoot().createAttribute("task.gitlab.activity-" + String.valueOf(instant));
                    taskAttribute.getMetaData().setType("activity");
                    String stateText = state.get("state").getAsString();
                    TaskAttribute child = DefaultTaskSchema.getField((String)"task.common.comment.text").createAttribute(taskAttribute);
                    child.setValue(stateText);
                    taskAttribute.getMetaData().putValue("task.meta.associated.attribute", child.getId());
                    child = DefaultTaskSchema.getField((String)"task.common.comment.date").createAttribute(taskAttribute);
                    child.setValue(localDateTime.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM)));
                    child = DefaultTaskSchema.getField((String)"task.common.comment.author").createAttribute(taskAttribute);
                    child.setValue(state.get("user").getAsJsonObject().get("name").getAsString());
                    TaskAttribute typeAttribute = taskAttribute.createAttribute("activity");
                    if (stateText.startsWith("closed")) {
                        typeAttribute.setValue(GitlabCoreActivator.ActivityType.LOCK.toString());
                        continue;
                    }
                    if (!stateText.startsWith("reopened")) continue;
                    typeAttribute.setValue(GitlabCoreActivator.ActivityType.REOPEN.toString());
                }
            }
            JsonArray labels = this.getIssueLabelEvents(matcher.group(1), matcher.group(2), OperationUtil.convert((IProgressMonitor)monitor));
            if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get getIssueLabelEvents with path " + matcher.group(1) + " an ID " + matcher.group(2));
            }
            if (labels != null) {
                long lastLabelAt = 0L;
                Instant instantAt = null;
                TaskAttribute labelText = null;
                ArrayList<String> added = new ArrayList<String>();
                ArrayList<String> removed = new ArrayList<String>();
                for (JsonElement stateElem : labels) {
                    JsonObject label = (JsonObject)stateElem;
                    Instant instant = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(label.get("created_at").getAsString()));
                    LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, TimeZone.getDefault().toZoneId());
                    if (!instant.equals(instantAt)) {
                        instantAt = instant;
                        this.buildLableText(labelText, added, removed);
                        added.clear();
                        removed.clear();
                        TaskAttribute taskAttribute = result.getRoot().createAttribute("task.gitlab.activity-" + String.valueOf(instant));
                        taskAttribute.getMetaData().setType("activity");
                        TaskAttribute child = DefaultTaskSchema.getField((String)"task.common.comment.date").createAttribute(taskAttribute);
                        child.setValue(localDateTime.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM)));
                        child = DefaultTaskSchema.getField((String)"task.common.comment.author").createAttribute(taskAttribute);
                        child.setValue(label.get("user").getAsJsonObject().get("name").getAsString());
                        TaskAttribute typeAttribute = taskAttribute.createAttribute("activity");
                        typeAttribute.setValue(GitlabCoreActivator.ActivityType.LABEL.toString());
                        labelText = DefaultTaskSchema.getField((String)"task.common.comment.text").createAttribute(taskAttribute);
                        taskAttribute.getMetaData().putValue("task.meta.associated.attribute", labelText.getId());
                    }
                    if (label.getAsJsonObject().get("action").getAsString().equals("add")) {
                        added.add(label.get("label").getAsJsonObject().get("name").getAsString());
                    }
                    if (!label.getAsJsonObject().get("action").getAsString().equals("remove")) continue;
                    removed.add(label.get("label").getAsJsonObject().get("name").getAsString());
                }
                this.buildLableText(labelText, added, removed);
            }
            config.updateProductOptions((TaskData)result);
        }
        if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
            GitlabCoreActivator.DEBUG_TRACE.traceExit("/debug/rest/client", (Object)result.toString());
        }
        return result;
    }

    private void buildLableText(TaskAttribute labelText, ArrayList<String> added, ArrayList<String> removed) {
        if (labelText != null) {
            Object text = "";
            if (added.size() > 0) {
                text = (String)text + "added ";
                text = (String)text + String.join((CharSequence)", ", added);
                text = (String)text + (added.size() > 1 ? " labels" : " label");
            }
            if (removed.size() > 0) {
                text = (String)text + (((String)text).length() == 0 ? "removed " : " and removed ");
                text = (String)text + String.join((CharSequence)", ", removed);
                text = (String)text + (removed.size() > 1 ? " labels" : " label");
            }
            labelText.setValue((String)text);
        }
    }

    private TaskAttribute createActivityEventTaskAttribute(TaskRepository repository, TaskAttribute result, JsonObject note) {
        Instant instant = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(note.get("created_at").getAsString()));
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, TimeZone.getDefault().toZoneId());
        TaskAttribute taskAttribute = result.createAttribute("task.gitlab.activity-" + String.valueOf(instant));
        taskAttribute.getMetaData().setType("activity");
        TaskAttribute child = DefaultTaskSchema.getField((String)"task.common.comment.date").createAttribute(taskAttribute);
        child.setValue(localDateTime.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM)));
        child = DefaultTaskSchema.getField((String)"task.common.comment.author").createAttribute(taskAttribute);
        child.setValue(note.get("author").getAsJsonObject().get("name").getAsString());
        this.buildActivityEventStyleInformation(taskAttribute, note.get("body").getAsString());
        return taskAttribute;
    }

    private void buildActivityEventStyleInformation(TaskAttribute taskAttribute, String bodyText) {
        TaskAttribute textAttribute = DefaultTaskSchema.getField((String)"task.common.comment.text").createAttribute(taskAttribute);
        taskAttribute.getMetaData().putValue("task.meta.associated.attribute", textAttribute.getId());
        TaskAttribute typeAttribute = taskAttribute.createAttribute("activity");
        if (bodyText.startsWith("changed due date ") || bodyText.startsWith("removed due date ")) {
            typeAttribute.setValue(GitlabCoreActivator.ActivityType.CALENDAR.toString());
        } else if (bodyText.startsWith("assigned to ") || bodyText.startsWith("unassigned ")) {
            typeAttribute.setValue(GitlabCoreActivator.ActivityType.PERSON.toString());
        } else if (bodyText.startsWith("changed ")) {
            typeAttribute.setValue(GitlabCoreActivator.ActivityType.PENCIL.toString());
        } else if (bodyText.startsWith("unlocked ")) {
            typeAttribute.setValue(GitlabCoreActivator.ActivityType.UNLOCK.toString());
        } else if (bodyText.startsWith("locked ")) {
            typeAttribute.setValue(GitlabCoreActivator.ActivityType.LOCK.toString());
        } else if (bodyText.contains("/designs?version=")) {
            typeAttribute.setValue(GitlabCoreActivator.ActivityType.DESIGN.toString());
        } else {
            typeAttribute.setValue(GitlabCoreActivator.ActivityType.UNKNOWN.toString());
        }
        TaskAttribute styleAttribute = taskAttribute.createAttribute("activity.style");
        Object resultText = "";
        String[] parts = bodyText.split("\\*\\*|\\*\\*\\{\\-|\\{\\-|\\-\\}|\\{\\+|\\+\\}");
        ArrayList<GitlabActivityStyle> styles = new ArrayList<GitlabActivityStyle>(parts.length);
        int textIdx = 0;
        GitlabActivityStyle styleRange = new GitlabActivityStyle(0);
        int textLen = bodyText.length();
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String matchText = stringArray[n2];
            int actPartLen = matchText.length();
            String marker = (textIdx += actPartLen) + 2 <= textLen ? bodyText.substring(textIdx, textIdx + 2) : "  ";
            Matcher linkMatcher = linkPattern.matcher(matchText);
            if (linkMatcher.find() && linkMatcher.start(1) > 0) {
                resultText = (String)resultText + matchText.substring(0, linkMatcher.start(1) - 1);
                styleRange.add2Length(linkMatcher.start(1) - 1);
                styleRange = this.createNewRangeIfNeeded(((String)resultText).length(), styles, styleRange, actPartLen);
                styleRange.setFontStyle(4);
                styleRange.add2Length(linkMatcher.group(1).length());
                styleRange.setUrl(this.getTaskRepository().getUrl() + linkMatcher.group(2));
                resultText = (String)resultText + linkMatcher.group(1);
                styleRange = this.createNewRangeIfNeeded(((String)resultText).length(), styles, styleRange, matchText.length() - linkMatcher.end(2));
                styleRange.setFontStyle(0);
                actPartLen = matchText.length() - linkMatcher.end(2) - 1;
            }
            if (actPartLen > 0) {
                resultText = (String)resultText + matchText;
                styleRange.add2Length(actPartLen);
            }
            if ("**".equals(marker)) {
                styleRange = this.createNewRangeIfNeeded(((String)resultText).length(), styles, styleRange, actPartLen);
                if (styleRange.getFontStyle() == 1) {
                    styleRange.setFontStyle(0);
                } else {
                    styleRange.setFontStyle(1);
                }
            }
            if ("{-".equals(marker)) {
                styleRange = this.createNewRangeIfNeeded(((String)resultText).length(), styles, styleRange, actPartLen);
                styleRange.setColor(3);
            }
            if ("{+".equals(marker)) {
                styleRange = this.createNewRangeIfNeeded(((String)resultText).length(), styles, styleRange, actPartLen);
                styleRange.setColor(5);
            }
            if ("-}".equals(marker) || "+}".equals(marker)) {
                styleRange = this.createNewRangeIfNeeded(((String)resultText).length(), styles, styleRange, actPartLen);
                styleRange.setColor(1);
            }
            textIdx += 2;
            ++n2;
        }
        textAttribute.setValue((String)resultText);
        styleAttribute.setValue(this.gson.toJson(styles, this.listOfMyClassObject));
    }

    private GitlabActivityStyle createNewRangeIfNeeded(int resultTextLen, ArrayList<GitlabActivityStyle> styles, GitlabActivityStyle styleRange, int actPartLen) {
        if (actPartLen > 0) {
            styles.add(styleRange);
            try {
                styleRange = styleRange.clone();
                styleRange.setStart(resultTextLen);
                styleRange.setLength(0);
                return styleRange;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return styleRange;
    }

    private TaskAttribute createNoteTaskAttribute(TaskRepository repository, TaskAttribute result, int i, JsonObject note) {
        TaskCommentMapper cmapper = new TaskCommentMapper();
        IRepositoryPerson author = repository.createPerson(note.get("author").getAsJsonObject().get("username").getAsString());
        author.setName(note.get("author").getAsJsonObject().get("name").getAsString());
        author.setAttribute("avatar_url", note.get("author").getAsJsonObject().get("avatar_url").getAsString());
        cmapper.setAuthor(author);
        cmapper.setCreationDate(GitlabTaskAttributeMapper.parseDate(note.get("created_at").getAsString()));
        cmapper.setText(note.get("body").getAsString());
        cmapper.setNumber(Integer.valueOf(++i));
        TaskAttribute attribute = result.createAttribute("task.common.comment-" + i);
        cmapper.applyTo(attribute);
        attribute.createAttribute("system").setValue(note.get("system").getAsString());
        return attribute;
    }

    public void getTaskData(Set<String> taskIds, TaskRepository taskRepository, TaskDataCollector collector, IOperationMonitor monitor) throws GitlabException {
        for (String taskId : taskIds) {
            TaskData data = this.getTaskData(taskRepository, taskId, (IProgressMonitor)monitor);
            collector.accept(data);
        }
    }

    public JsonObject getUser(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/user"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getUsers(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/users" + path){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getNamespaces(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/namespaces"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getGroups(IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/groups"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getGroup(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/groups" + path){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getSubGroups(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/groups" + path + "/subgroups?all_available=true"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getDescendantGroups(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/groups" + path + "/descendant_groups?all_available=true"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getNamespace(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonObject = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/namespaces" + path){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonObject;
    }

    public JsonArray getProjects(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, path + "/projects"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getProject(String projectid, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, "/projects/" + projectid){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getGroupProjects(String projectid, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/groups/" + projectid + "/projects?include_subgroups=true"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getIssues(String path, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, path + "/issues"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getIssue(String path, String id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, path + "/issues/" + id){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getIssueNotes(String path, String id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, path + "/issues/" + id + "/notes?sort=asc"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getIssueDiscussions(String path, String id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, path + "/issues/" + id + "/discussions"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getIssueStateEvents(String path, String id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, path + "/issues/" + id + "/resource_state_events"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getIssueLabelEvents(String path, String id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, path + "/issues/" + id + "/resource_label_events"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getIssueMilestoneEvents(String path, String id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, path + "/issues/" + id + "/resource_milestone_events"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonObject getIssueDiscussion(String path, String id, String discussion_id, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonArray = (JsonObject)new GitlabOperation<JsonObject>(this.client, path + "/issues/" + id + "/discussions/" + discussion_id){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonElement createIssueNote(String path, String id, final String body, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonElement = (JsonObject)new GitlabPostOperation<JsonObject>(this.client, path + "/issues/" + id + "/notes"){

            @Override
            protected void addHttpRequestEntities(HttpRequestBase request) throws GitlabException {
                super.addHttpRequestEntities(request);
                request.setHeader("Content-Type", "application/json");
                try {
                    ((HttpPost)request).setEntity((HttpEntity)new StringEntity(body));
                }
                catch (UnsupportedEncodingException e) {
                    throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "UnsupportedEncodingException", (Throwable)e));
                }
            }

            @Override
            protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, GitlabException {
                this.validate(response, 201, monitor);
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonElement;
    }

    public JsonElement updateIssue(String path, String id, String body, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonObject jsonElement = (JsonObject)new GitlabPutOperation<JsonObject>(this.client, path + "/issues/" + id, body){

            @Override
            protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, GitlabException {
                this.validate(response, 200, monitor);
            }

            @Override
            protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                StringBuilder result = new StringBuilder();
                return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
            }
        }.run(monitor);
        return jsonElement;
    }

    public GitlabConfiguration getConfiguration(TaskRepository repository, IOperationMonitor monitor) throws GitlabException {
        String groupsValue;
        String projectValue;
        if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
            GitlabCoreActivator.DEBUG_TRACE.traceEntry("/debug/rest/client", (Object)repository.getUrl());
        }
        GitlabConfiguration config = new GitlabConfiguration(repository.getUrl());
        JsonObject user = this.getUser(monitor);
        config.setUserID(user.get("id").getAsBigInteger());
        config.setUserDetails((JsonElement)user);
        if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
            GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get User");
        }
        JsonArray projects = this.getProjects("/users/" + String.valueOf(config.getUserID()), monitor);
        for (JsonElement project : projects) {
            JsonObject projectObject = (JsonObject)project;
            JsonArray labels = this.getProjectLabels(projectObject.get("id").getAsString(), monitor);
            JsonArray milestones = this.getProjectMilestones(projectObject.get("id").getAsString(), monitor);
            config.addProject((JsonElement)projectObject, (JsonElement)labels, (JsonElement)milestones);
        }
        if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
            GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get User Projects");
        }
        if ((projectValue = repository.getProperty("gitlab.projects")) != null && !projectValue.isBlank()) {
            String[] projectList = projectValue.split(",");
            int i = 0;
            while (i < projectList.length) {
                try {
                    String project = projectList[i];
                    JsonObject projectDetail = this.getProject(URLEncoder.encode(project, StandardCharsets.UTF_8.toString()), monitor);
                    if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                        GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get Project: (" + (i + 1) + "/" + projectList.length + "): " + project + " ");
                    }
                    JsonObject projectObject = projectDetail;
                    JsonArray labels = this.getProjectLabels(projectObject.get("id").getAsString(), monitor);
                    JsonArray milestones = this.getProjectMilestones(projectObject.get("id").getAsString(), monitor);
                    if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                        GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get Project: (" + (i + 1) + "/" + projectList.length + "): " + project + " Labels/Milestone ");
                    }
                    config.addProject((JsonElement)projectObject, (JsonElement)labels, (JsonElement)milestones);
                }
                catch (UnsupportedEncodingException e) {
                    throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "UnsupportedEncodingException", (Throwable)e));
                }
                ++i;
            }
        }
        if ((groupsValue = repository.getProperty("gitlab.groups")) != null && !groupsValue.isBlank()) {
            String[] groupList = groupsValue.split(",");
            int i = 0;
            while (i < groupList.length) {
                String group = groupList[i];
                JsonObject groupDetail = this.getGroup("/" + group, monitor);
                config.addGroup((JsonElement)groupDetail);
                if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                    GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get Group (" + (i + 1) + "/" + groupList.length + "): " + group);
                }
                projects = this.getGroupProjects(group, monitor);
                if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                    GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get Group (" + (i + 1) + "/" + groupList.length + "): " + group + " projects");
                }
                JsonArray projectsArray = projects;
                int j = 0;
                while (j < projectsArray.size()) {
                    JsonElement project = projectsArray.get(j);
                    JsonObject projectObject = (JsonObject)project;
                    JsonArray labels = this.getProjectLabels(projectObject.get("id").getAsString(), monitor);
                    JsonArray milestones = this.getProjectMilestones(projectObject.get("id").getAsString(), monitor);
                    if (GitlabCoreActivator.DEBUG_REST_CLIENT_TRACE) {
                        GitlabCoreActivator.DEBUG_TRACE.trace("/debug/rest/client/trace", "get Group (" + (i + 1) + "/" + groupList.length + "): " + group + " Projects (" + (j + 1) + "/" + projectsArray.size() + "): " + projectObject.get("id").getAsString() + " Labels/Milestone: ");
                    }
                    config.addProject((JsonElement)projectObject, (JsonElement)labels, (JsonElement)milestones);
                    ++j;
                }
                ++i;
            }
        }
        if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
            GitlabCoreActivator.DEBUG_TRACE.traceExit("/debug/rest/client", (Object)config.toString());
        }
        return config;
    }

    public RepositoryResponse postTaskData(TaskData taskData, Set<TaskAttribute> oldAttributes, IOperationMonitor monitor) throws GitlabException {
        if (taskData.isNew()) {
            JsonElement result = this.createNewIssue(taskData, monitor);
            JsonObject resObj = (JsonObject)result;
            String newID = resObj.get("iid").getAsString();
            String projectID = resObj.get("project_id").getAsString();
            return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_CREATED, "/projects/" + projectID + "/issues/" + newID);
        }
        return this.updateExistingIssue(taskData, oldAttributes, monitor);
    }

    private RepositoryResponse updateExistingIssue(TaskData taskData, Set<TaskAttribute> oldAttributes, IOperationMonitor monitor) throws GitlabException {
        if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
            GitlabCoreActivator.DEBUG_TRACE.traceEntry("/debug/rest/client", (Object)(taskData.getRepositoryUrl() + " id " + taskData.getTaskId()));
        }
        ArrayList<String> changedAtributes = new ArrayList<String>();
        Object newComentValue = "";
        Object discussionsId = "";
        for (TaskAttribute taskAttribute : oldAttributes) {
            TaskAttribute newAttrib;
            String attributeID = taskAttribute.getId();
            if (this.updatable.containsKey(attributeID)) {
                newAttrib = taskData.getRoot().getAttribute(attributeID);
                String newValue = newAttrib.getValue();
                if (attributeID.equals(GitlabTaskSchema.getDefault().TASK_LABELS.getKey())) {
                    newValue = newAttrib.getValues().toString().substring(1, newAttrib.getValues().toString().length() - 1);
                }
                if (attributeID.equals("due_date") && newValue.length() > 0) {
                    newValue = dmyFormat.format(new Date(Long.parseLong(newValue)));
                }
                changedAtributes.add(NLS.bind((String)"\"{0}\":\"{1}\"", (Object)this.updatable.get(attributeID), (Object)newValue));
            }
            if (!GitlabTaskSchema.getDefault().NEW_COMMENT.getKey().equals(taskAttribute.getId())) continue;
            newAttrib = taskData.getRoot().getAttribute(attributeID);
            TaskAttribute noteableIdAttrib = newAttrib.getAttribute("noteable_id");
            TaskAttribute iidAttribute = taskData.getRoot().getAttribute(GitlabTaskSchema.getDefault().IID.getKey());
            discussionsId = iidAttribute.getValue();
            if (noteableIdAttrib != null) {
                newComentValue = "{\"note_id\":" + noteableIdAttrib.getValue() + ",\"body\":\"" + newAttrib.getValue().replace("\n", "\\n").replace("\"", "\\\"") + "\"}";
                TaskAttribute xx1 = newAttrib.getAttribute("discussions");
                discussionsId = (String)discussionsId + "/discussions/" + xx1.getValue();
                continue;
            }
            newComentValue = "{\"body\":\"" + newAttrib.getValue().replace('\n', '\n') + "\"}";
        }
        TaskAttribute productAttribute = taskData.getRoot().getAttribute(GitlabTaskSchema.getDefault().PRODUCT.getKey());
        if (productAttribute != null && !productAttribute.getValue().isEmpty()) {
            TaskAttribute iidAttribute = taskData.getRoot().getAttribute(GitlabTaskSchema.getDefault().IID.getKey());
            if (!changedAtributes.isEmpty()) {
                this.updateIssue("/projects/" + productAttribute.getValue(), iidAttribute.getValue(), "{" + String.join((CharSequence)",", changedAtributes) + "}", monitor);
            }
            if (!((String)newComentValue).isEmpty()) {
                this.createIssueNote("/projects/" + productAttribute.getValue(), (String)discussionsId, (String)newComentValue, monitor);
            }
        }
        if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
            GitlabCoreActivator.DEBUG_TRACE.traceExit("/debug/rest/client");
        }
        return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, taskData.getTaskId());
    }

    public JsonElement createNewIssue(final TaskData taskData, IOperationMonitor monitor) throws GitlabException {
        if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
            GitlabCoreActivator.DEBUG_TRACE.traceEntry("/debug/rest/client", (Object)(taskData.getRepositoryUrl() + " id " + taskData.getTaskId()));
        }
        try {
            JsonObject jsonElement;
            this.getAccessTokenIfNotPresent(monitor);
            TaskAttribute productAttribute = taskData.getRoot().getAttribute(GitlabTaskSchema.getDefault().PRODUCT.getKey());
            if (productAttribute == null || productAttribute.getValue().isEmpty()) {
                throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "productAttribute should not be null"));
            }
            JsonObject jsonObject = jsonElement = (JsonObject)new GitlabPostOperation<JsonObject>(this.client, "/projects/" + productAttribute.getValue() + "/issues"){

                @Override
                protected void addHttpRequestEntities(HttpRequestBase request) throws GitlabException {
                    super.addHttpRequestEntities(request);
                    request.setHeader("Content-Type", "application/json");
                    Gson gson = new GsonBuilder().registerTypeAdapter(TaskData.class, (Object)new TaskAttributeTypeAdapter()).create();
                    String jsondata = gson.toJson((Object)taskData);
                    try {
                        ((HttpPost)request).setEntity((HttpEntity)new StringEntity(jsondata));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new GitlabException((IStatus)new Status(4, "org.eclipse.mylyn.gitlab.core", "UnsupportedEncodingException", (Throwable)e));
                    }
                }

                @Override
                protected void doValidate(CommonHttpResponse response, IOperationMonitor monitor) throws IOException, GitlabException {
                    this.validate(response, 201, monitor);
                }

                @Override
                protected JsonObject parseFromJson(InputStreamReader in) throws GitlabException {
                    return (JsonObject)new Gson().fromJson((Reader)in, JsonObject.class);
                }
            }.run(monitor);
            return jsonObject;
        }
        finally {
            if (GitlabCoreActivator.DEBUG_REST_CLIENT) {
                GitlabCoreActivator.DEBUG_TRACE.traceExit("/debug/rest/client");
            }
        }
    }

    public static String convertString2GSonString(String str) {
        str = str.replace("\"", "\\\"").replace("\n", "\\\n");
        StringBuffer ostr = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                ostr.append(ch);
            } else {
                ostr.append("\\u");
                String hex = Integer.toHexString(str.charAt(i) & 0xFFFF);
                int j = 0;
                while (j < 4 - hex.length()) {
                    ostr.append("0");
                    ++j;
                }
                ostr.append(hex.toLowerCase());
            }
            ++i;
        }
        return new String(ostr);
    }

    public JsonArray getProjectLabels(String projectid, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/projects/" + projectid + "/labels"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    public JsonArray getProjectMilestones(String projectid, IOperationMonitor monitor) throws GitlabException {
        this.getAccessTokenIfNotPresent(monitor);
        JsonArray jsonArray = (JsonArray)new GitlabJSonArrayOperation(this.client, "/projects/" + projectid + "/milestones?include_parent_milestones=true"){

            @Override
            protected HttpRequestBase createHttpRequestBase(String url) {
                HttpGet request = new HttpGet(url);
                return request;
            }

            @Override
            protected JsonArray parseFromJson(InputStreamReader in) throws GitlabException {
                return (JsonArray)new Gson().fromJson((Reader)in, JsonArray.class);
            }
        }.run(monitor);
        return jsonArray;
    }

    private class JSonTaskDataDeserializer
    implements JsonDeserializer<TaskData> {
        private JSonTaskDataDeserializer() {
        }

        public TaskData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            GitlabConfiguration config = GitlabRestClient.this.getConfiguration();
            JsonObject jo = json.getAsJsonObject();
            TaskData taskData = GitlabRestClient.this.getFromJson(jo);
            if (config != null) {
                config.updateProductOptions(taskData);
                config.addValidOperations(taskData);
            }
            return taskData;
        }
    }

    private class JSonTaskDataListDeserializer
    implements JsonDeserializer<ArrayList<TaskData>> {
        private JSonTaskDataListDeserializer() {
        }

        public ArrayList<TaskData> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ArrayList<TaskData> response = new ArrayList<TaskData>();
            GitlabConfiguration config = GitlabRestClient.this.getConfiguration();
            JsonArray ja = json.getAsJsonArray();
            for (JsonElement jsonElement : ja) {
                JsonObject jo = jsonElement.getAsJsonObject();
                TaskData taskData = GitlabRestClient.this.getFromJson(jo);
                if (config != null) {
                    config.updateProductOptions(taskData);
                }
                response.add(taskData);
            }
            return response;
        }
    }

    class TaskAttributeTypeAdapter
    extends TypeAdapter<TaskData> {
        TaskAttributeTypeAdapter() {
        }

        public void write(JsonWriter out, TaskData taskData) throws IOException {
            out.beginObject();
            for (TaskAttribute taskAttribute : taskData.getRoot().getAttributes().values()) {
                String id = taskAttribute.getId();
                String attributValue = GitlabRestClient.convertString2GSonString(taskAttribute.getValue());
                if ("project_id".equals(id = GitlabNewTaskSchema.getJsonNameFromAttributeName(id)) || "state".equals(id)) continue;
                out.name(id).value(attributValue);
            }
            out.endObject();
        }

        public TaskData read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("TaskAttributeTypeAdapter in GitlabRestClient only supports write");
        }
    }
}

