/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.util.TasksCoreUtil;
import org.eclipse.mylyn.reviews.core.spi.ReviewsConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskReviewsMappingsStore
implements ITaskListChangeListener {
    static final String ATTR_ASSOCIATED_TASK = "org.eclipse.mylyn.associated.task";
    private final SetValuedMap<String, String> taskReviewsMap;
    private final TaskRepositoryManager repositoryManager;
    private final TaskList taskList;
    private static TaskReviewsMappingsStore instance;

    public TaskReviewsMappingsStore(TaskList taskList, TaskRepositoryManager repositoryManager) {
        this.taskList = taskList;
        this.repositoryManager = repositoryManager;
        this.taskReviewsMap = new HashSetValuedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromTaskList() {
        for (AbstractTask review : this.taskList.getAllTasks()) {
            String task = this.getTaskUrl((ITask)review);
            if (task == null) continue;
            SetValuedMap<String, String> setValuedMap = this.taskReviewsMap;
            synchronized (setValuedMap) {
                this.taskReviewsMap.put((Object)task, (Object)review.getUrl());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapping(ITask review, String newTaskUrl) {
        String reviewUrl = review.getUrl();
        String oldTaskUrl = this.getTaskUrl(review);
        SetValuedMap<String, String> setValuedMap = this.taskReviewsMap;
        synchronized (setValuedMap) {
            Set urls;
            if (oldTaskUrl != null && !oldTaskUrl.equals(newTaskUrl) && (urls = this.taskReviewsMap.get((Object)oldTaskUrl)) != null) {
                urls.remove(reviewUrl);
            }
            this.taskReviewsMap.put((Object)newTaskUrl, (Object)reviewUrl);
        }
        review.setAttribute(ATTR_ASSOCIATED_TASK, newTaskUrl);
    }

    public void addTaskAssocation(ITask review, TaskData taskData) {
        TaskAttribute attr = taskData.getRoot().getMappedAttribute("task.common.description");
        if (attr == null) {
            return;
        }
        String oldTaskUrl = this.getTaskUrl(review);
        String description = attr.getValue();
        String[] stringArray = description.split("\\s+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.equals(oldTaskUrl)) {
                return;
            }
            if (token.contains("://")) {
                try {
                    AbstractRepositoryConnector connector;
                    new URL(token);
                    ITask task = this.getTaskByUrl(token);
                    if (task != null && !((connector = this.repositoryManager.getRepositoryConnector(task.getConnectorKind())) instanceof ReviewsConnector)) {
                        this.updateMapping(review, task.getUrl() != null ? task.getUrl() : token);
                        return;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        this.deleteMappingsTo(review);
    }

    public String getTaskUrl(ITask review) {
        return review.getAttribute(ATTR_ASSOCIATED_TASK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getReviewUrls(String taskUrl) {
        SetValuedMap<String, String> setValuedMap = this.taskReviewsMap;
        synchronized (setValuedMap) {
            return Set.copyOf(this.taskReviewsMap.get((Object)taskUrl));
        }
    }

    ITask getTaskByUrl(String url) {
        return TasksCoreUtil.getTaskByUrl((TaskList)this.taskList, (IRepositoryManager)this.repositoryManager, (String)url);
    }

    /*
     * WARNING - void declaration
     */
    public void containersChanged(Set<TaskContainerDelta> containers) {
        for (TaskContainerDelta delta : containers) {
            void review;
            IRepositoryElement reviewRepoElement;
            IRepositoryElement iRepositoryElement;
            if (delta.getKind() != TaskContainerDelta.Kind.DELETED || !((iRepositoryElement = (reviewRepoElement = delta.getElement())) instanceof ITask)) continue;
            ITask cfr_ignored_0 = (ITask)iRepositoryElement;
            ITask cfr_ignored_1 = (ITask)iRepositoryElement;
            AbstractRepositoryConnector connector = this.repositoryManager.getRepositoryConnector(review.getConnectorKind());
            if (!(connector instanceof ReviewsConnector)) continue;
            this.deleteMappingsTo((ITask)review);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteMappingsTo(ITask review) {
        String taskUrl = this.getTaskUrl(review);
        if (taskUrl != null) {
            SetValuedMap<String, String> setValuedMap = this.taskReviewsMap;
            synchronized (setValuedMap) {
                Set urls = this.taskReviewsMap.get((Object)taskUrl);
                if (urls != null) {
                    urls.remove(review.getUrl());
                }
            }
            review.setAttribute(ATTR_ASSOCIATED_TASK, null);
        }
    }

    public static void setInstance(TaskReviewsMappingsStore instance) {
        TaskReviewsMappingsStore.instance = instance;
    }

    public static TaskReviewsMappingsStore getInstance() {
        return instance;
    }
}

