/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractEditableCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckboxCell
extends AbstractEditableCell<Boolean, Boolean> {
    private static final SafeHtml INPUT_CHECKED = SafeHtmlUtils.fromSafeConstant("<input type=\"checkbox\" tabindex=\"-1\" checked/>");
    private static final SafeHtml INPUT_UNCHECKED = SafeHtmlUtils.fromSafeConstant("<input type=\"checkbox\" tabindex=\"-1\"/>");
    private final boolean isSelectBox;

    public CheckboxCell() {
        this(false);
    }

    public CheckboxCell(boolean isSelectBox) {
        super("change", "keydown");
        this.isSelectBox = isSelectBox;
    }

    @Override
    public boolean dependsOnSelection() {
        return this.isSelectBox;
    }

    @Override
    public boolean handlesSelection() {
        return this.isSelectBox;
    }

    @Override
    public boolean isEditing(Element parent, Boolean value, Object key) {
        return false;
    }

    @Override
    public void onBrowserEvent(Element parent, Boolean value, Object key, NativeEvent event, ValueUpdater<Boolean> valueUpdater) {
        boolean enterPressed;
        String type = event.getType();
        boolean bl = enterPressed = "keydown".equals(type) && event.getKeyCode() == 13;
        if ("change".equals(type) || enterPressed) {
            InputElement input = (InputElement)parent.getFirstChild().cast();
            Boolean isChecked = input.isChecked();
            if (enterPressed) {
                isChecked = isChecked == false;
                input.setChecked(isChecked);
            }
            this.setViewData(key, isChecked);
            if (valueUpdater != null) {
                valueUpdater.update(isChecked);
            }
        }
    }

    @Override
    public void render(Boolean value, Object key, SafeHtmlBuilder sb) {
        Boolean viewData = (Boolean)this.getViewData(key);
        if (viewData != null && viewData.equals(value)) {
            this.clearViewData(key);
            viewData = null;
        }
        if (value != null && (viewData != null ? viewData : value).booleanValue()) {
            sb.append(INPUT_CHECKED);
        } else {
            sb.append(INPUT_UNCHECKED);
        }
    }
}

