/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.mylyn.wikitext.commonmark.internal.ContentLineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LinesIterable;
import org.eclipse.mylyn.wikitext.commonmark.internal.PredicateLineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.TransformLineSequence;

public abstract class LineSequence
implements Iterable<Line> {
    public static LineSequence create(String content) {
        return new ContentLineSequence(content);
    }

    public abstract Line getCurrentLine();

    public abstract Line getNextLine();

    public abstract void advance();

    public void advance(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0);
        int x = 0;
        while (x < count) {
            this.advance();
            ++x;
        }
    }

    @Override
    public Iterator<Line> iterator() {
        Predicate<Line> predicate = x -> true;
        return this.iterator(predicate);
    }

    private Iterator<Line> iterator(Predicate<Line> predicate) {
        return new LinesIterable(this, predicate).iterator();
    }

    public LineSequence with(Predicate<Line> predicate) {
        return new PredicateLineSequence(this, predicate);
    }

    public LineSequence transform(Function<Line, Line> transform) {
        return new TransformLineSequence(this, transform);
    }

    public abstract LineSequence lookAhead();

    public String toString() {
        return MoreObjects.toStringHelper(LineSequence.class).add("currentLine", (Object)this.getCurrentLine()).add("nextLine", (Object)this.getNextLine()).toString();
    }

    static abstract class ForwardLineSequence
    extends LineSequence {
        ForwardLineSequence() {
        }

        abstract Line getNextLine(int var1);
    }
}

