/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.listeners;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;

public class OverviewSelectionMover
extends MouseMotionListener.Stub
implements MouseListener,
MouseMotionListener {
    private Point fLocation = null;
    private final Figure fFigure;

    public OverviewSelectionMover(Figure figure) {
        this.fFigure = figure;
        figure.addMouseListener((MouseListener)this);
    }

    public void mousePressed(MouseEvent me) {
        this.fLocation = me.getLocation();
        me.consume();
        this.fFigure.addMouseMotionListener((MouseMotionListener)this);
    }

    public void mouseReleased(MouseEvent me) {
        if (this.fLocation != null) {
            this.fLocation = null;
            me.consume();
        }
        this.fFigure.removeMouseMotionListener((MouseMotionListener)this);
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
        Point targetLocation;
        Dimension offset;
        if (this.fLocation != null && (offset = (targetLocation = me.getLocation()).getDifference(this.fLocation)).width() != 0) {
            TimeBaseConverter timeDetails = RootFigure.getRootFigure((IFigure)this.fFigure).getTimeViewDetails();
            if (timeDetails.translateOverviewAreaOffset(offset.width())) {
                this.fLocation = targetLocation;
            }
            me.consume();
        }
    }
}

