/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.led;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public abstract class BaseLED
extends Canvas {
    static final int DEFAULT_HEIGHT = 100;
    static final int THIN_DEFAULT_WIDTH = 30;
    protected static final int DOT_DIAMETER = 10;
    protected Color idleColor;
    protected Color selectedColor;
    protected GC gc;

    public BaseLED(Composite parent, int style) {
        super(parent, style);
        this.setBackground(this.getDisplay().getSystemColor(2));
        this.addListener(9, e -> this.onPaint(e));
        Color defaultIdleColor = new Color((Device)this.getDisplay(), 0, 29, 29);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource[])new Resource[]{defaultIdleColor});
        this.idleColor = defaultIdleColor;
        Color defaultSelectedColor = new Color((Device)this.getDisplay(), 148, 237, 147);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource[])new Resource[]{defaultSelectedColor});
        this.selectedColor = defaultSelectedColor;
    }

    private void onPaint(Event e) {
        this.gc = e.gc;
        this.gc.setBackground(this.getBackground());
        this.gc.fillRectangle(this.getClientArea());
        this.gc.setAdvanced(true);
        this.gc.setAntialias(1);
        this.paintInternal();
    }

    protected abstract void paintInternal();

    public Color getIdleColor() {
        this.checkWidget();
        return this.idleColor;
    }

    public void setIdleColor(Color idleColor) {
        this.checkWidget();
        this.checkColor(idleColor);
        this.idleColor = idleColor;
        this.redraw();
    }

    private void checkColor(Color color) {
        if (color == null) {
            SWT.error((int)4);
        }
        if (color.isDisposed()) {
            SWT.error((int)5);
        }
    }

    public Color getSelectedColor() {
        this.checkWidget();
        return this.selectedColor;
    }

    public void setSelectedColor(Color selectedColor) {
        this.checkWidget();
        this.checkColor(selectedColor);
        this.selectedColor = selectedColor;
        this.redraw();
    }
}

