/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import java.awt.Dimension;
import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTWindowEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class PTDimensionEditor
extends PTWindowEditor {
    private Text width;
    private Text height;

    @Override
    protected void createContent(Shell shell, PTProperty property) {
        Label widthLabel = new Label((Composite)shell, 0);
        widthLabel.setLayoutData((Object)new GridData(3, 1, false, false));
        widthLabel.setText(ResourceManager.getLabel((String)"width"));
        this.width = new Text((Composite)shell, 2048);
        this.width.setLayoutData((Object)new GridData(4, 1, true, false));
        if (property.getValue() != null) {
            Dimension d = (Dimension)property.getValue();
            this.width.setText(String.valueOf(d.width));
        }
        this.addVerifyListeners(this.width);
        Label heightLabel = new Label((Composite)shell, 0);
        heightLabel.setLayoutData((Object)new GridData(3, 1, false, false));
        heightLabel.setText(ResourceManager.getLabel((String)"height"));
        this.height = new Text((Composite)shell, 2048);
        this.height.setLayoutData((Object)new GridData(4, 1, true, false));
        if (property.getValue() != null) {
            Dimension d = (Dimension)property.getValue();
            this.height.setText(String.valueOf(d.height));
        }
        this.addVerifyListeners(this.height);
    }

    @Override
    protected void fillProperty(Item item, PTProperty property) {
        Dimension d = new Dimension();
        d.width = this.getIntValue(this.width);
        d.height = this.getIntValue(this.height);
        property.setValue(d);
        if (item instanceof TableItem) {
            ((TableItem)item).setText(1, this.getTextFor(property));
        } else {
            ((TreeItem)item).setText(1, this.getTextFor(property));
        }
    }

    @Override
    protected String getTextFor(PTProperty property) {
        if (property.getValue() == null) {
            return "(null)";
        }
        Dimension d = (Dimension)property.getValue();
        return "[" + d.width + "," + d.height + "]";
    }
}

