/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.duallist.snippets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.duallist.DLConfiguration;
import org.eclipse.nebula.widgets.opal.duallist.DLItem;
import org.eclipse.nebula.widgets.opal.duallist.DualList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DualListTextSnippet {
    private static final String DOUBLE_DOWN_IMAGE = "double_down.png";
    private static final String DOUBLE_UP_IMAGE = "double_up.png";
    private static final String DOUBLE_LEFT_IMAGE = "double_left.png";
    private static final String DOUBLE_RIGHT_IMAGE = "double_right.png";
    private static final String ARROW_DOWN_IMAGE = "arrow_down.png";
    private static final String ARROW_LEFT_IMAGE = "arrow_left.png";
    private static final String ARROW_UP_IMAGE = "arrow_up.png";
    private static final String ARROW_RIGHT_IMAGE = "arrow_right.png";
    private static DualList dl;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Dual List Snippet");
        shell.setSize(600, 600);
        shell.setLayout((Layout)new GridLayout(1, false));
        dl = new DualList((Composite)shell, 0);
        dl.setItems(DualListTextSnippet.createItems(shell));
        dl.addListener(13, e -> System.out.println("Selection Listener called"));
        dl.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gdButtons = new GridData(3, 4, true, false);
        gdButtons.widthHint = 150;
        Button changeConfiguration = new Button((Composite)shell, 8);
        changeConfiguration.setText("Change Configuration");
        changeConfiguration.setLayoutData((Object)gdButtons);
        changeConfiguration.addListener(13, e -> dl.setConfiguration(DualListTextSnippet.createConfiguration()));
        Button hideButtons = new Button((Composite)shell, 8);
        hideButtons.setText("Hide buttons");
        hideButtons.setLayoutData((Object)gdButtons);
        hideButtons.addListener(13, e -> {
            DLConfiguration config = new DLConfiguration();
            config.setDoubleDownVisible(false).setDoubleUpVisible(false).setDoubleRightVisible(false).setDoubleLeftVisible(false).setDownVisible(false).setUpVisible(false);
            dl.setConfiguration(config);
        });
        Button resetConfiguration = new Button((Composite)shell, 8);
        resetConfiguration.setText("Reset Configuration");
        resetConfiguration.setLayoutData((Object)gdButtons);
        resetConfiguration.addListener(13, e -> dl.setConfiguration(null));
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static List<DLItem> createItems(Shell shell) {
        ArrayList<DLItem> list = new ArrayList<DLItem>();
        String defaultFontName = null;
        int defaultHeight = -1;
        FontData[] fontDataArray = shell.getFont().getFontData();
        int n = fontDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            if (defaultFontName == null) {
                defaultFontName = fontData.getName();
            }
            if (defaultHeight == -1) {
                defaultHeight = fontData.getHeight();
            }
            ++n2;
        }
        Font font = new Font((Device)shell.getDisplay(), defaultFontName, defaultHeight, 1);
        list.add(new DLItem("Austria"));
        list.add(new DLItem("Belgium"));
        list.add(new DLItem("Bulgaria"));
        list.add(new DLItem("Cyprus"));
        list.add(new DLItem("Czech Republic"));
        list.add(new DLItem("Denmark"));
        list.add(new DLItem("Estonia"));
        list.add(new DLItem("Finland"));
        list.add(new DLItem("France").setSelected(true));
        list.add(new DLItem("Germany"));
        list.add(new DLItem("Greece"));
        list.add(new DLItem("Hungary").setSelected(true));
        list.add(new DLItem("Ireland"));
        list.add(new DLItem("Italy"));
        list.add(new DLItem("Latvia"));
        list.add(new DLItem("Lithuania").setSelected(true));
        list.add(new DLItem("Luxembourg"));
        list.add(new DLItem("Malta"));
        list.add(new DLItem("Netherlands"));
        list.add(new DLItem("Poland").setSelected(true));
        list.add(new DLItem("Portugal"));
        list.add(new DLItem("Romania"));
        list.add(new DLItem("Slovakia"));
        list.add(new DLItem("Slovenia"));
        list.add(new DLItem("Spain"));
        list.add(new DLItem("Sweden"));
        list.add(new DLItem("United Kingdom"));
        shell.addDisposeListener(e -> font.dispose());
        return list;
    }

    private static DLConfiguration createConfiguration() {
        DLConfiguration config = new DLConfiguration();
        Display display = Display.getCurrent();
        config.setItemsBackgroundColor(display.getSystemColor(2)).setItemsForegroundColor(display.getSystemColor(1)).setItemsOddLinesColor(display.getSystemColor(15));
        config.setSelectionBackgroundColor(display.getSystemColor(6)).setSelectionForegroundColor(display.getSystemColor(7)).setSelectionOddLinesColor(display.getSystemColor(3));
        config.setItemsTextAlignment(131072).setSelectionTextAlignment(0x1000000);
        config.setDownImage(DualListTextSnippet.createImage(ARROW_DOWN_IMAGE)).setUpImage(DualListTextSnippet.createImage(ARROW_UP_IMAGE)).setRightImage(DualListTextSnippet.createImage(ARROW_RIGHT_IMAGE)).setLeftImage(DualListTextSnippet.createImage(ARROW_LEFT_IMAGE)).setDoubleDownImage(DualListTextSnippet.createImage(DOUBLE_DOWN_IMAGE)).setDoubleUpImage(DualListTextSnippet.createImage(DOUBLE_UP_IMAGE)).setDoubleLeftImage(DualListTextSnippet.createImage(DOUBLE_LEFT_IMAGE)).setDoubleRightImage(DualListTextSnippet.createImage(DOUBLE_RIGHT_IMAGE));
        return config;
    }

    private static Image createImage(String fileName) {
        Image image = new Image((Device)Display.getCurrent(), DualListTextSnippet.class.getResourceAsStream("arrows/" + fileName));
        SWTGraphicUtil.addDisposer((Widget)dl, (Resource[])new Resource[]{image});
        return image;
    }
}

