/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.comm.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.core.service.SclService;

public class RestHttpServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(RestHttpServlet.class);
    private static final long serialVersionUID = 1L;
    private static SclService scl;

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int statusCode;
        String requestingEntity64;
        RequestIndication requestIndication = new RequestIndication();
        String targetID = httpServletRequest.getRequestURI().substring(System.getProperty("org.eclipse.om2m.sclBaseContext").length());
        requestIndication.setTargetID(targetID);
        String representation = null;
        try {
            representation = RestHttpServlet.convertStreamToString((InputStream)httpServletRequest.getInputStream());
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error reading httpServletRequest InputStream", (Throwable)e);
        }
        requestIndication.setRepresentation(representation);
        String httpMethod = httpServletRequest.getMethod();
        String restMethod = RestHttpServlet.getRestMethod(httpMethod, representation.isEmpty());
        requestIndication.setMethod(restMethod);
        String authorization = httpServletRequest.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic") && (requestingEntity64 = authorization.split(" ")[1]) != null) {
            requestIndication.setRequestingEntity(new String(Base64.decodeBase64((byte[])requestingEntity64.getBytes())));
        }
        String queryString = httpServletRequest.getQueryString();
        if (httpServletRequest.getQueryString() != null) {
            requestIndication.setParameters(RestHttpServlet.getParamsFromQuery(queryString));
        }
        requestIndication.setProtocol("http");
        ResponseConfirm responseConfirm = new ResponseConfirm();
        LOGGER.info((Object)RestHttpServlet.httpRequestToString(httpMethod, targetID, representation, authorization, queryString));
        responseConfirm = scl != null ? scl.doRequest(requestIndication) : new ResponseConfirm(StatusCode.STATUS_SERVICE_UNAVAILABLE, "SCL service not installed");
        boolean isEmptyResponse = false;
        if (responseConfirm.getRepresentation() == null || responseConfirm.getRepresentation().isEmpty()) {
            isEmptyResponse = true;
        }
        if ((statusCode = RestHttpServlet.getHttpStatusCode(responseConfirm.getStatusCode(), isEmptyResponse)) == 201 && responseConfirm.getResourceURI() != null) {
            httpServletResponse.addHeader("Location", responseConfirm.getResourceURI());
        }
        if (statusCode != 204) {
            httpServletResponse.setContentType("application/xml");
        }
        httpServletResponse.setStatus(statusCode);
        String body = responseConfirm.getRepresentation();
        PrintWriter out = null;
        try {
            out = httpServletResponse.getWriter();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error reading httpServletResponse Writer", (Throwable)e);
        }
        out.println(body);
        out.close();
        LOGGER.info((Object)RestHttpServlet.httpResponseToString(statusCode, body));
    }

    public static Map<String, List<String>> getParamsFromQuery(String query) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (query != null) {
            String[] pairs;
            String[] stringArray = pairs = query.split("[&]");
            int n = pairs.length;
            int n2 = 0;
            while (n2 < n) {
                String pair = stringArray[n2];
                String[] param = pair.split("[=]");
                String key = null;
                String value = null;
                if (param.length > 0) {
                    key = param[0];
                }
                if (param.length > 1) {
                    value = param[1];
                }
                if (parameters.containsKey(key)) {
                    ((List)parameters.get(key)).add(value);
                } else {
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(value);
                    parameters.put(key, values);
                }
                ++n2;
            }
        }
        return parameters;
    }

    public static String getRestMethod(String method, boolean isEmptyBody) {
        switch (method) {
            case "GET": {
                return "RETRIEVE";
            }
            case "POST": {
                if (isEmptyBody) {
                    return "EXECUTE";
                }
                return "CREATE";
            }
            case "PUT": {
                return "UPDATE";
            }
            case "DELETE": {
                return "DELETE";
            }
        }
        return null;
    }

    public static int getHttpStatusCode(StatusCode statusCode, boolean isEmptyBody) {
        switch (statusCode) {
            case STATUS_OK: {
                if (isEmptyBody) {
                    return 204;
                }
                return 200;
            }
            case STATUS_ACCEPTED: {
                return 202;
            }
            case STATUS_CREATED: {
                return 201;
            }
            case STATUS_BAD_REQUEST: {
                return 400;
            }
            case STATUS_PERMISSION_DENIED: {
                return 401;
            }
            case STATUS_AUTHORIZATION_NOT_ADDED: {
                return 402;
            }
            case STATUS_FORBIDDEN: {
                return 403;
            }
            case STATUS_NOT_FOUND: {
                return 404;
            }
            case STATUS_METHOD_NOT_ALLOWED: {
                return 405;
            }
            case STATUS_NOT_ACCEPTABLE: {
                return 406;
            }
            case STATUS_REQUEST_TIMEOUT: {
                return 408;
            }
            case STATUS_CONFLICT: {
                return 409;
            }
            case STATUS_UNSUPPORTED_MEDIA_TYPE: {
                return 415;
            }
            case STATUS_INTERNAL_SERVER_ERROR: {
                return 500;
            }
            case STATUS_NOT_IMPLEMENTED: {
                return 501;
            }
            case STATUS_BAD_GATEWAY: {
                return 502;
            }
            case STATUS_SERVICE_UNAVAILABLE: {
                return 503;
            }
            case STATUS_GATEWAY_TIMEOUT: {
                return 504;
            }
            case STATUS_EXPIRED: {
                return 410;
            }
        }
        return 500;
    }

    public static String httpRequestToString(String method, String uri, String rep, String auth, String query) {
        return "HttpRequest [method=" + method + ", URI=" + uri + ", representation=" + rep + ", Authorization=" + auth + ", queryString=" + query + "]";
    }

    public static String httpResponseToString(int statusCode, String rep) {
        return "HttpResponse [statusCode=" + statusCode + "]";
    }

    public static SclService getScl() {
        return scl;
    }

    public static void setScl(SclService scl) {
        RestHttpServlet.scl = scl;
    }

    static String convertStreamToString(InputStream is) {
        Scanner scanner = new Scanner(is);
        scanner.useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }
}

