/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipu.sample;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.core.service.SclService;
import org.eclipse.om2m.ipu.sample.SampleController;
import org.eclipse.om2m.ipu.sample.SampleMonitor;
import org.eclipse.om2m.ipu.service.IpuService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log logger = LogFactory.getLog(Activator.class);
    private ServiceTracker<Object, Object> sclServiceTracker;

    public void start(BundleContext bundleContext) throws Exception {
        logger.info((Object)"Register IpuService..");
        bundleContext.registerService(IpuService.class.getName(), (Object)new SampleController(), null);
        logger.info((Object)"IpuService is registered.");
        this.sclServiceTracker = new ServiceTracker<Object, Object>(bundleContext, SclService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                logger.info((Object)"SclService removed");
            }

            public Object addingService(ServiceReference<Object> reference) {
                logger.info((Object)"SclService discovered");
                SclService sclService = (SclService)this.context.getService(reference);
                final SampleMonitor ipuMonitor = new SampleMonitor(sclService);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            ipuMonitor.start();
                        }
                        catch (Exception e) {
                            logger.error((Object)"IpuMonitor Sample error", (Throwable)e);
                        }
                    }
                }.start();
                return sclService;
            }
        };
        this.sclServiceTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        logger.error((Object)"Stop IPU Phidgets monitor");
        try {
            SampleMonitor.stop();
        }
        catch (Exception e) {
            logger.error((Object)"Stop Phidgets error", (Throwable)e);
        }
    }
}

