/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.Date;
import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.AccessRight;
import org.eclipse.om2m.commons.resource.AnnounceTo;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.announcer.Announcer;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class AccessRightController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        if (accessRightID == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        AccessRight accessRight = null;
        try {
            accessRight = (AccessRight)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (accessRight == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (accessRight.getId() != null && !accessRight.getId().matches("^[A-Za-z0-9_-]*$")) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Id should match the following regexpr: ^[A-Za-z0-9_-]*$"));
        }
        if (accessRight.getId() != null && DAOFactory.getAccessRightDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + accessRight.getId(), em) != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "Access Right Id Conflit"));
        }
        if (accessRight.getId() == null || accessRight.getId().isEmpty()) {
            accessRight.setId(AccessRightController.generateId("AR_", ""));
        }
        if (accessRight.getExpirationTime() != null && !this.checkExpirationTime(accessRight.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time is out of Date"));
        }
        if (accessRight.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Subscriptions Reference is not Permitted"));
        }
        if (accessRight.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time is not Permitted"));
        }
        if (accessRight.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time is Not Permitted"));
        }
        if (accessRight.getSelfPermissions().getPermission() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "selfPermissions attribute is Mandatory"));
        }
        accessRight.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + accessRight.getId());
        if (accessRight.getExpirationTime() == null) {
            accessRight.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        if (accessRight.getSearchStrings() == null) {
            accessRight.setSearchStrings(AccessRightController.generateSearchStrings(accessRight.getClass().getSimpleName(), accessRight.getId()));
        }
        if (accessRight.getAnnounceTo() == null) {
            AnnounceTo announceTo = new AnnounceTo();
            announceTo.setActivated(Boolean.valueOf(false));
            announceTo.setGlobal(Boolean.valueOf(false));
            accessRight.setAnnounceTo(announceTo);
        }
        accessRight.setSubscriptionsReference(String.valueOf(accessRight.getUri()) + "/subscriptions");
        accessRight.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        accessRight.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        if (accessRight.getAnnounceTo().isActivated().booleanValue()) {
            accessRight.setAnnounceTo(new Announcer().announce(accessRight.getAnnounceTo(), accessRight.getUri(), accessRight.getSearchStrings(), requestIndication.getRequestingEntity()));
        }
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)accessRight);
        DAOFactory.getAccessRightDAO().create(accessRight, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)accessRight);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        AccessRight accessRight = DAOFactory.getAccessRightDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (accessRight == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkSelfPermissions(accessRight.getSelfPermissions(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        accessRight.setSubscriptionsReference(String.valueOf(accessRight.getUri()) + "/subscriptions");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)accessRight);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        AccessRight accessRight = DAOFactory.getAccessRightDAO().find(requestIndication.getTargetID(), em);
        if (accessRight == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkSelfPermissions(accessRight.getSelfPermissions(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        AccessRight accessRightNew = null;
        try {
            accessRightNew = (AccessRight)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (accessRightNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (accessRightNew.getId() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "accessRightId is not Permitted"));
        }
        if (accessRightNew.getExpirationTime() != null && !this.checkExpirationTime(accessRightNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time is out of Date"));
        }
        if (accessRightNew.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Subscriptions Reference is not Permitted"));
        }
        if (accessRightNew.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time is not Permitted"));
        }
        if (accessRightNew.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time is not Permitted"));
        }
        if (accessRightNew.getSelfPermissions().getPermission() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "selfPermissions attribute is Mandatory"));
        }
        if (accessRightNew.getExpirationTime() != null) {
            accessRight.setExpirationTime(accessRightNew.getExpirationTime());
        }
        if (accessRightNew.getSearchStrings() != null) {
            accessRight.setSearchStrings(accessRightNew.getSearchStrings());
        }
        if (accessRightNew.getAnnounceTo() != null) {
            accessRight.setAnnounceTo(accessRightNew.getAnnounceTo());
        }
        if (accessRightNew.getPermissions() != null) {
            accessRight.setPermissions(accessRightNew.getPermissions());
        }
        accessRight.setSelfPermissions(accessRightNew.getSelfPermissions());
        accessRight.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)accessRight);
        DAOFactory.getAccessRightDAO().update(accessRight, em);
        em.getTransaction().commit();
        em.close();
        accessRight.setSubscriptionsReference(String.valueOf(accessRight.getUri()) + "/subscriptions");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)accessRight);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        AccessRight accessRight = DAOFactory.getAccessRightDAO().find(requestIndication.getTargetID(), em);
        if (accessRight == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkSelfPermissions(accessRight.getSelfPermissions(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (accessRight.getAnnounceTo().isActivated().booleanValue()) {
            new Announcer().deAnnounce(accessRight.getAnnounceTo(), accessRight.getUri(), requestIndication.getRequestingEntity());
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)accessRight);
        DAOFactory.getAccessRightDAO().delete(accessRight, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not implmented"));
    }
}

