/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.comm.coap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.comm.coap.CoapClient;
import org.eclipse.om2m.comm.coap.CoapMessageDeliverer;
import org.eclipse.om2m.comm.coap.CoapServer;
import org.eclipse.om2m.comm.service.RestClientService;
import org.eclipse.om2m.core.service.SclService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log LOGGER = LogFactory.getLog(Activator.class);
    private ServiceTracker<Object, Object> sclServiceTracker;
    CoapServer server;

    public void start(BundleContext bundleContext) throws Exception {
        LOGGER.info((Object)"Register CoAP RestClientService..");
        bundleContext.registerService(RestClientService.class.getName(), (Object)new CoapClient(), null);
        LOGGER.info((Object)"CoAP RestClientService is registered.");
        this.server = new CoapServer();
        this.server.startServer();
        this.sclServiceTracker = new ServiceTracker<Object, Object>(bundleContext, SclService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"SclService removed");
                try {
                    CoapMessageDeliverer.setScl((SclService)service);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Object)"Error removing SclService", (Throwable)e);
                }
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"SclService discovered");
                SclService scl = (SclService)this.context.getService(reference);
                try {
                    CoapMessageDeliverer.setScl(scl);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error adding SclService", (Throwable)e);
                }
                return scl;
            }
        };
        this.sclServiceTracker.open();
        LOGGER.info((Object)"SclService opened");
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

