/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.utils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlMapper {
    private static Log LOGGER = LogFactory.getLog(XmlMapper.class);
    private static XmlMapper xmlMapper = new XmlMapper();
    private JAXBContext ctx;
    private String resourcePackage = "org.eclipse.om2m.commons.resource";

    private XmlMapper() {
        try {
            this.ctx = JAXBContext.newInstance((String)this.resourcePackage);
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"Create JAXBContext error!", (Throwable)e);
        }
    }

    public static XmlMapper getInstance() {
        return xmlMapper;
    }

    public String objectToXml(Object object) {
        try {
            Marshaller marshaller = this.ctx.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            marshaller.marshal(object, (OutputStream)outputStream);
            return ((Object)outputStream).toString();
        }
        catch (JAXBException e) {
            LOGGER.error((Object)"JAXB marshalling error!", (Throwable)e);
            return null;
        }
    }

    public Object xmlToObject(String representation) {
        StringReader stringReader = new StringReader(representation);
        try {
            Unmarshaller unmarshaller = this.ctx.createUnmarshaller();
            return unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (JAXBException e) {
            LOGGER.debug((Object)"JAXB unmarshalling error!", (Throwable)e);
            return null;
        }
    }
}

