/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.comm;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.comm.service.RestClientService;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;

public class RestClient {
    private static Log LOGGER = LogFactory.getLog(RestClient.class);
    public static Map<String, RestClientService> restClients = new HashMap<String, RestClientService>();

    public ResponseConfirm sendRequest(RequestIndication requestIndication) {
        LOGGER.info((Object)("the requestIndication RC: " + requestIndication));
        ResponseConfirm responseConfirm = new ResponseConfirm();
        String protocol = requestIndication.getBase().split("://")[0];
        if (restClients.containsKey(protocol)) {
            try {
                responseConfirm = restClients.get(protocol).sendRequest(requestIndication);
                if (responseConfirm.getStatusCode() == null) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"RestClient error", (Throwable)e);
                responseConfirm = new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_INTERNAL_SERVER_ERROR, "RestClient error"));
            }
        } else {
            responseConfirm = new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, "No RestClient service Found"));
        }
        LOGGER.info((Object)responseConfirm);
        return responseConfirm;
    }

    public static Map<String, RestClientService> getRestClients() {
        return restClients;
    }

    public static void setRestClients(Map<String, RestClientService> sclClients) {
        restClients = sclClients;
    }
}

