/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.Date;
import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.AnnounceTo;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.announcer.Announcer;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class GroupController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Group group = null;
        try {
            group = (Group)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (group == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (group.getId() != null && !group.getId().matches("^[A-Za-z0-9_-]*$")) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Id should match the following regexpr: ^[A-Za-z0-9_-]*$"));
        }
        if (group.getId() != null && DAOFactory.getGroupDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + group.getId(), em) != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "GroupId Conflit"));
        }
        if (group.getId() == null || group.getId().isEmpty()) {
            group.setId(GroupController.generateId("GRP_", ""));
        }
        if (group.getMemberType() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " MemberType is Mandatory"));
        }
        if (group.getExpirationTime() != null && !this.checkExpirationTime(group.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time CREATE is Out of Date"));
        }
        if (group.getCurrentNrOfMembers() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " CurrentNrOfMembers Reference is Not Permitted"));
        }
        if (group.getMembersContentReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " MembersContent Reference is Not Permitted"));
        }
        if (group.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "SubscriptionsReference is Not Permitted"));
        }
        if (group.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time is Not Permitted"));
        }
        if (group.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time is Not Permitted"));
        }
        if (group.getAccessRightID() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AccessRightID is Not Permitted"));
        }
        if (group.getMaxNrOfMembers() != null && group.getMembers() != null && group.getMaxNrOfMembers() >= 0L && (long)group.getMembers().getReference().size() > group.getMaxNrOfMembers()) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "CurrentNrOfMembers is greater than MaxNrOfMembers"));
        }
        group.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + group.getId());
        if (group.getMaxNrOfMembers() == null) {
            group.setMaxNrOfMembers(Long.valueOf(-1L));
        }
        if (group.getMembers() == null || group.getMembers().getReference().isEmpty()) {
            group.setCurrentNrOfMembers(Long.valueOf(0L));
        } else {
            group.setCurrentNrOfMembers(Long.valueOf(group.getMembers().getReference().size()));
        }
        if (group.getExpirationTime() == null) {
            group.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        group.setAccessRightID(accessRightID);
        if (group.getSearchStrings() == null) {
            group.setSearchStrings(GroupController.generateSearchStrings(group.getClass().getSimpleName(), group.getId()));
        }
        if (group.getAnnounceTo() == null) {
            AnnounceTo announceTo = new AnnounceTo();
            announceTo.setActivated(Boolean.valueOf(false));
            announceTo.setGlobal(Boolean.valueOf(false));
            group.setAnnounceTo(announceTo);
        }
        group.setMembersContentReference(String.valueOf(group.getUri()) + "/membersContent");
        group.setSubscriptionsReference(String.valueOf(group.getUri()) + "/subscriptions");
        group.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        group.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        if (group.getAnnounceTo().isActivated().booleanValue()) {
            group.setAnnounceTo(new Announcer().announce(group.getAnnounceTo(), group.getUri(), group.getSearchStrings(), requestIndication.getRequestingEntity()));
        }
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)group);
        DAOFactory.getGroupDAO().create(group, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)group);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Group group = DAOFactory.getGroupDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (group == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(group.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        group.setSubscriptionsReference(String.valueOf(group.getUri()) + "/subscriptions");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)group);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Group group = DAOFactory.getGroupDAO().find(requestIndication.getTargetID(), em);
        if (group == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(group.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Group groupNew = null;
        try {
            groupNew = (Group)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (groupNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (groupNew.getId() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "GroupId UPDATE is Not Permitted"));
        }
        if (groupNew.getExpirationTime() != null && !this.checkExpirationTime(groupNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time UPDATE is Out of Date"));
        }
        if (groupNew.getAccessRightID() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AccessRightID UPDATE is Not Permitted"));
        }
        if (groupNew.getMembersContentReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "MembersContent Reference UPDATE is Not Permitted"));
        }
        if (groupNew.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "SubscriptionsReference UPDATE is Not Permitted"));
        }
        if (groupNew.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time UPDATE is Not Permitted"));
        }
        if (groupNew.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time UPDATE is Not Permitted"));
        }
        if (groupNew.getMemberType() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "MemberType UPDATE is Not Permitted"));
        }
        if (groupNew.getCurrentNrOfMembers() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "currentNrOfMembers UPDATE is Not Permitted"));
        }
        if (groupNew.getMembers() != null && !groupNew.getMembers().getReference().isEmpty()) {
            group.setMembers(groupNew.getMembers());
        }
        if (groupNew.getMaxNrOfMembers() != null) {
            group.setMaxNrOfMembers(groupNew.getMaxNrOfMembers());
        }
        if (group.getMaxNrOfMembers() != null && group.getMembers() != null && group.getMaxNrOfMembers() >= 0L && (long)group.getMembers().getReference().size() > group.getMaxNrOfMembers()) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "CurrentNrOfMembers is greater than MaxNrOfMembers"));
        }
        if (groupNew.getExpirationTime() != null) {
            group.setExpirationTime(groupNew.getExpirationTime());
        }
        if (DAOFactory.getAccessRightDAO().find(groupNew.getAccessRightID(), em) != null) {
            group.setAccessRightID(groupNew.getAccessRightID());
        }
        if (groupNew.getSearchStrings() != null) {
            group.setSearchStrings(groupNew.getSearchStrings());
        }
        if (groupNew.getAnnounceTo() != null) {
            group.setAnnounceTo(groupNew.getAnnounceTo());
        }
        group.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)group);
        DAOFactory.getGroupDAO().update(group, em);
        em.getTransaction().commit();
        em.close();
        group.setSubscriptionsReference(String.valueOf(group.getUri()) + "/subscriptions");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)group);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Group group = DAOFactory.getGroupDAO().find(requestIndication.getTargetID(), em);
        if (group == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(group.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (group.getAnnounceTo().isActivated().booleanValue()) {
            new Announcer().deAnnounce(group.getAnnounceTo(), group.getUri(), requestIndication.getRequestingEntity());
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)group);
        DAOFactory.getGroupDAO().delete(group, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not yet Implemented"));
    }
}

