/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContainerAnnc;
import org.eclipse.om2m.commons.resource.Containers;
import org.eclipse.om2m.commons.resource.LocationContainer;
import org.eclipse.om2m.commons.resource.LocationContainerAnnc;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class ContainersDAO
extends DAO<Containers> {
    @Override
    public void create(Containers resource, EntityManager em) {
    }

    @Override
    public Containers find(String uri, EntityManager em) {
        Containers containers = new Containers();
        containers.setUri(uri);
        containers.getContainerCollection().getNamedReference().clear();
        containers.getContainerAnncCollection().getNamedReference().clear();
        containers.getLocationContainerCollection().getNamedReference().clear();
        containers.getLocationContainerAnncCollection().getNamedReference().clear();
        String q = DBUtil.generateLikeRequest("CONTAINER", uri);
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Container c : result) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(c.getId());
            ref.setValue(c.getUri());
            containers.getContainerCollection().getNamedReference().add(ref);
        }
        String q2 = DBUtil.generateLikeRequest("CONTAINERANNC", uri);
        Query query2 = em.createQuery(q2);
        List result2 = query2.getResultList();
        for (ContainerAnnc ca : result2) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(ca.getId());
            ref.setValue(ca.getUri());
            containers.getContainerAnncCollection().getNamedReference().add(ref);
        }
        String q3 = DBUtil.generateLikeRequest("LOCATIONCONTAINER", uri);
        Query query3 = em.createQuery(q3);
        List result3 = query3.getResultList();
        for (LocationContainer lc : result3) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(lc.getId());
            ref.setValue(lc.getUri());
            containers.getLocationContainerCollection().getNamedReference().add(ref);
        }
        String q4 = DBUtil.generateLikeRequest("LOCATIONCONTAINERANNC", uri);
        Query query4 = em.createQuery(q4);
        List result4 = query4.getResultList();
        for (LocationContainerAnnc lca : result4) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(lca.getId());
            ref.setValue(lca.getUri());
            containers.getLocationContainerAnncCollection().getNamedReference().add(ref);
        }
        return containers;
    }

    @Override
    public void update(Containers resource, EntityManager em) {
    }

    @Override
    public void delete(Containers resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        String q = DBUtil.generateLikeRequest("CONTAINER", resource.getUri());
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Container c : result) {
            c.setContentInstancesReference(String.valueOf(c.getUri()) + "/contentInstances");
            c.setSubscriptionsReference(String.valueOf(c.getUri()) + "/subscriptions");
            DAOFactory.getContainerDAO().delete(c, em);
        }
        String q2 = DBUtil.generateLikeRequest("CONTAINERANNC", resource.getUri());
        Query query2 = em.createQuery(q2);
        List result2 = query2.getResultList();
        for (ContainerAnnc ca : result2) {
            DAOFactory.getContainerAnncDAO().delete(ca, em);
        }
        String q3 = DBUtil.generateLikeRequest("LOCATIONCONTAINER", resource.getUri());
        Query query3 = em.createQuery(q3);
        List result3 = query3.getResultList();
        for (LocationContainer lc : result3) {
            lc.setContentInstancesReference(String.valueOf(lc.getUri()) + "/contentInstances");
            lc.setSubscriptionsReference(String.valueOf(lc.getUri()) + "/subscriptions");
            DAOFactory.getLocationContainerDAO().delete(lc, em);
        }
        String q4 = DBUtil.generateLikeRequest("LOCATIONCONTAINERANNC", resource.getUri());
        Query query4 = em.createQuery(q4);
        List result4 = query4.getResultList();
        for (LocationContainerAnnc lca : result4) {
            DAOFactory.getLocationContainerAnncDAO().delete(lca, em);
        }
    }
}

