/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.ExecInstance;
import org.eclipse.om2m.commons.resource.ExecInstances;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class ExecInstancesDAO
extends DAO<ExecInstances> {
    @Override
    public void create(ExecInstances resource, EntityManager em) {
    }

    @Override
    public ExecInstances find(String uri, EntityManager em) {
        ExecInstances execInstances = new ExecInstances();
        execInstances.setUri(uri);
        execInstances.getExecInstanceCollection().getNamedReference().clear();
        String q = DBUtil.generateLikeRequest("EXECINSTANCE", uri);
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (ExecInstance execInstance : result) {
            ReferenceToNamedResource reference = new ReferenceToNamedResource();
            reference.setId(execInstance.getId());
            reference.setValue(execInstance.getUri());
            execInstances.getExecInstanceCollection().getNamedReference().add(reference);
        }
        return execInstances;
    }

    @Override
    public void update(ExecInstances resource, EntityManager em) {
    }

    @Override
    public void delete(ExecInstances resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        String q = DBUtil.generateLikeRequest("EXECINSTANCE", resource.getUri());
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (ExecInstance execInstance : result) {
            execInstance.setSubscriptionsReference(String.valueOf(execInstance.getUri()) + "/subscriptions");
            DAOFactory.getExecInstanceDAO().delete(execInstance, em);
        }
    }
}

