/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.Date;
import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.MgmtObj;
import org.eclipse.om2m.commons.resource.Parameters;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;

public class ParametersDAO
extends DAO<Parameters> {
    @Override
    public void create(Parameters resource, EntityManager em) {
        resource.setSubscriptionsReference(String.valueOf(resource.getUri()) + "/subscriptions");
        em.persist((Object)resource);
        String target = resource.getUri().split("/" + resource.getId())[0];
        String[] parameter = target.split("mgmtObjs/");
        ReferenceToNamedResource reference = new ReferenceToNamedResource();
        reference.setId(resource.getId());
        reference.setValue(resource.getUri());
        if (!parameter[1].contains("/")) {
            MgmtObj mgmtObj = DAOFactory.getMgmtObjDAO().find(target, em);
            mgmtObj.getParametersCollection().getNamedReference().add(reference);
            mgmtObj.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
            DAOFactory.getMgmtObjDAO().update(mgmtObj, em);
        } else {
            Parameters parameters = DAOFactory.getParametersDAO().find(target, em);
            parameters.getParametersCollection().getNamedReference().add(reference);
            parameters.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
            DAOFactory.getParametersDAO().update(parameters, em);
        }
    }

    @Override
    public Parameters find(String uri, EntityManager em) {
        return (Parameters)em.find(Parameters.class, (Object)uri);
    }

    @Override
    public void delete(Parameters resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        for (ReferenceToNamedResource reference : resource.getParametersCollection().getNamedReference()) {
            Parameters parameters = DAOFactory.getParametersDAO().find(reference.getValue(), em);
            DAOFactory.getParametersDAO().delete(parameters, em);
        }
        String parentUri = resource.getUri().replace("/" + resource.getId(), "");
        Parameters parent = DAOFactory.getParametersDAO().find(parentUri, em);
        if (parent != null) {
            ReferenceToNamedResource reference = new ReferenceToNamedResource();
            reference.setValue(resource.getUri());
            ReferenceToNamedResource referenceInParent = null;
            for (ReferenceToNamedResource ref : parent.getParametersCollection().getNamedReference()) {
                if (!ref.getValue().equals(resource.getUri())) continue;
                referenceInParent = ref;
                break;
            }
            if (referenceInParent != null) {
                parent.getParametersCollection().getNamedReference().remove(referenceInParent);
            }
            DAOFactory.getParametersDAO().update(parent, em);
        }
        em.remove((Object)resource);
    }
}

