/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.MgmtObjs;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Scl;
import org.eclipse.om2m.commons.resource.Scls;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class SclsDAO
extends DAO<Scls> {
    @Override
    public void create(Scls resource, EntityManager em) {
    }

    @Override
    public Scls find(String uri, EntityManager em) {
        Scls scls = new Scls();
        scls.setUri(uri);
        scls.getSclCollection().getNamedReference().clear();
        String q = DBUtil.generateLikeRequest("SCL", uri);
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Scl s : result) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(s.getSclId());
            ref.setValue(s.getUri());
            scls.getSclCollection().getNamedReference().add(ref);
        }
        return scls;
    }

    @Override
    public void update(Scls resource, EntityManager em) {
    }

    @Override
    public void delete(Scls resource, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(resource.getSubscriptionsReference());
        MgmtObjs mgmtObjs = new MgmtObjs();
        mgmtObjs.setUri(resource.getMgmtObjsReference());
        mgmtObjs.setSubscriptionsReference(String.valueOf(mgmtObjs.getUri()) + "/subscriptions");
        DAOFactory.getSubscriptionsDAO().delete(subscriptions, em);
        DAOFactory.getMgmtObjsDAO().delete(mgmtObjs, em);
        String q = DBUtil.generateLikeRequest("SCL", resource.getUri());
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Scl s : result) {
            s.setContainersReference(String.valueOf(s.getUri()) + "/containers");
            s.setGroupsReference(String.valueOf(s.getUri()) + "/groups");
            s.setApplicationsReference(String.valueOf(s.getUri()) + "/applications");
            s.setAccessRightsReference(String.valueOf(s.getUri()) + "/accessRights");
            s.setSubscriptionsReference(String.valueOf(s.getUri()) + "/subscriptions");
            s.setMgmtObjsReference(String.valueOf(s.getUri()) + "/mgmtObjs");
            s.setNotificationChannelsReference(String.valueOf(s.getUri()) + "/notificationChannels");
            s.setM2MPocsReference(String.valueOf(s.getUri()) + "/m2mPocs");
            s.setAttachedDevicesReference(String.valueOf(s.getUri()) + "/attachedDevices");
            DAOFactory.getSclDAO().delete(s, em);
        }
    }
}

