/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.core.dao.DAO;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBUtil;

public class SubscriptionsDAO
extends DAO<Subscriptions> {
    @Override
    public void create(Subscriptions resource, EntityManager em) {
    }

    @Override
    public Subscriptions find(String uri, EntityManager em) {
        Subscriptions subscriptions = new Subscriptions();
        subscriptions.setUri(uri);
        subscriptions.getSubscriptionCollection().getNamedReference().clear();
        String q = DBUtil.generateLikeRequest("SUBSCRIPTION", uri);
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Subscription s : result) {
            ReferenceToNamedResource ref = new ReferenceToNamedResource();
            ref.setId(s.getId());
            ref.setValue(s.getUri());
            subscriptions.getSubscriptionCollection().getNamedReference().add(ref);
        }
        return subscriptions;
    }

    @Override
    public void update(Subscriptions resource, EntityManager em) {
    }

    @Override
    public void delete(Subscriptions resource, EntityManager em) {
        String q = DBUtil.generateLikeRequest("SUBSCRIPTION", resource.getUri());
        Query query = em.createQuery(q);
        List result = query.getResultList();
        for (Subscription s : result) {
            DAOFactory.getSubscriptionDAO().delete(s, em);
        }
    }
}

