/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.notifier;

import java.util.ArrayList;
import javax.persistence.EntityManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.Notify;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.core.comm.RestClient;
import org.eclipse.om2m.core.constants.Constants;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.redirector.Redirector;
import org.eclipse.om2m.core.router.Router;

public class Notifier {
    private static Log LOGGER = LogFactory.getLog(Notifier.class);

    public static void notify(StatusCode statusCode, Resource resource) {
        String subscriptionsUri = String.valueOf(resource.getUri().substring(0, resource.getUri().lastIndexOf("/"))) + "/subscriptions";
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Subscriptions subscriptions = DAOFactory.getSubscriptionsDAO().find(subscriptionsUri, em);
        if (subscriptions != null) {
            ArrayList<Subscription> subscriptionList = new ArrayList<Subscription>();
            int i = 0;
            while (i < subscriptions.getSubscriptionCollection().getNamedReference().size()) {
                subscriptionList.add(DAOFactory.getSubscriptionDAO().find(((ReferenceToNamedResource)subscriptions.getSubscriptionCollection().getNamedReference().get(i)).getValue(), em));
                ++i;
            }
            int i2 = 0;
            while (i2 < subscriptionList.size()) {
                Notify notify = new Notify();
                Subscription subscription = new Subscription();
                subscription = (Subscription)subscriptionList.get(i2);
                notify.setStatusCode(statusCode);
                notify.getRepresentation().setContentType("application/xml");
                if (subscription.getFilterCriteria() != null) {
                    if (!subscription.getFilterCriteria().getIfMatch().isEmpty() && subscription.getFilterCriteria().getIfMatch().get(0) != null && "contentInstance".equalsIgnoreCase(resource.getClass().getSimpleName()) && "content".equalsIgnoreCase((String)subscription.getFilterCriteria().getIfMatch().get(0))) {
                        ContentInstance contentInstance = (ContentInstance)resource;
                        notify.getRepresentation().setValue(contentInstance.getContent().getValue());
                    }
                } else {
                    notify.getRepresentation().setValue(resource);
                }
                notify.setSubscriptionReference(subscription.getUri());
                final String contact = subscription.getContact();
                final RequestIndication requestIndication = new RequestIndication();
                requestIndication.setMethod("CREATE");
                requestIndication.setRequestingEntity(Constants.ADMIN_REQUESTING_ENTITY);
                requestIndication.setRepresentation(notify);
                new Thread(){

                    @Override
                    public void run() {
                        LOGGER.info((Object)("Notification Request:\n" + requestIndication));
                        ResponseConfirm responseConfirm = Notifier.notify(requestIndication, contact);
                        LOGGER.info((Object)("Notification Response:\n" + responseConfirm));
                    }
                }.start();
                ++i2;
            }
        }
        em.close();
    }

    public static ResponseConfirm notify(RequestIndication requestIndication, String contact) {
        if (contact.matches(".*://.*")) {
            requestIndication.setBase(contact);
            requestIndication.setTargetID("");
            return new RestClient().sendRequest(requestIndication);
        }
        String sclId = contact.split("/")[0];
        requestIndication.setTargetID(contact);
        if (Constants.SCL_ID.equals(sclId)) {
            return new Router().doRequest(requestIndication);
        }
        return new Redirector().retarget(requestIndication);
    }
}

