/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.dacis;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class AeAnncDacisTest
extends Test {
    public AeAnncDacisTest(CseService pCseService) {
        super("Ae Annc Dacis", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS();
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create DAC");
            return;
        }
        RemoteCSE remoteCse = this.createRemoteCse();
        if (remoteCse == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create RemoteCse");
            return;
        }
        AEAnnc toBeCreatedAeAnnc = new AEAnnc();
        toBeCreatedAeAnnc.getDynamicAuthorizationConsultationIDs().add(dac.getResourceID());
        toBeCreatedAeAnnc.setAppID("App" + UUID.randomUUID());
        toBeCreatedAeAnnc.setLink("/link" + UUID.randomUUID());
        toBeCreatedAeAnnc.setName(toBeCreatedAeAnnc.getAppID());
        RequestPrimitive createRequest = new RequestPrimitive();
        createRequest.setOperation(Operation.CREATE);
        createRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        createRequest.setTargetId(remoteCse.getResourceID());
        createRequest.setRequestContentType("application/obj");
        createRequest.setReturnContentType("application/obj");
        createRequest.setResourceType(10002);
        createRequest.setContent((Object)toBeCreatedAeAnnc);
        ResponsePrimitive createResponse = this.getCseService().doRequest(createRequest);
        if (createResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("response is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(createResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create AeAnnc: expecting " + ResponseStatusCode.CREATED + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        AEAnnc createdAeAnnc = null;
        try {
            createdAeAnnc = (AEAnnc)createResponse.getContent();
        }
        catch (ClassCastException e) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a AeAnnc");
            return;
        }
        if (!this.checkEquals(createdAeAnnc.getDynamicAuthorizationConsultationIDs(), toBeCreatedAeAnnc.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        ResponsePrimitive retrieveResponse = this.retrieveEntity(createdAeAnnc.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve AeAnnc: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        AEAnnc retrievedAeAnnc = null;
        try {
            retrievedAeAnnc = (AEAnnc)retrieveResponse.getContent();
        }
        catch (ClassCastException e) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a AeAnnc");
            return;
        }
        if (!this.checkEquals(retrievedAeAnnc.getDynamicAuthorizationConsultationIDs(), toBeCreatedAeAnnc.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        RequestPrimitive deleteRequest = new RequestPrimitive();
        deleteRequest.setOperation(Operation.DELETE);
        deleteRequest.setTargetId(dac.getResourceID());
        deleteRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        ResponsePrimitive deleteResponse = this.getCseService().doRequest(deleteRequest);
        if (!ResponseStatusCode.DELETED.equals(deleteResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete DAC");
            return;
        }
        retrieveResponse = this.retrieveEntity(createdAeAnnc.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve AeAnnc: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        try {
            retrievedAeAnnc = (AEAnnc)retrieveResponse.getContent();
        }
        catch (ClassCastException e) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a AeAnnc");
            return;
        }
        if (!this.checkEquals(retrievedAeAnnc.getDynamicAuthorizationConsultationIDs(), new ArrayList(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        this.setState(Test.State.OK);
    }
}

