/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.flexcontainer;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.xml.sax.SAXException;

public class FlexContainerXMLValidator {
    private static final Log LOGGER = LogFactory.getLog(FlexContainerXMLValidator.class);
    private static final String FLEXCONTAINER_XSD_FOLDER_PROPERTY_NAME = "org.eclipse.om2m.flexcontainer.xsd.folder";
    private static String FLEXCONTAINER_XSD_FOLDER_PROPERTY_VALUE = System.getProperty("org.eclipse.om2m.flexcontainer.xsd.folder", null);

    static {
        if (FLEXCONTAINER_XSD_FOLDER_PROPERTY_VALUE != null && !FLEXCONTAINER_XSD_FOLDER_PROPERTY_VALUE.endsWith("/")) {
            FLEXCONTAINER_XSD_FOLDER_PROPERTY_VALUE = String.valueOf(FLEXCONTAINER_XSD_FOLDER_PROPERTY_VALUE) + "/";
        }
    }

    public static void validateXMLPayload(String xmlPayload, String containerDefinition) throws BadRequestException {
        if (FLEXCONTAINER_XSD_FOLDER_PROPERTY_VALUE == null) {
            LOGGER.warn((Object)"No XSD folder set.");
            return;
        }
        File xsdFile = new File(String.valueOf(FLEXCONTAINER_XSD_FOLDER_PROPERTY_VALUE) + containerDefinition.toLowerCase() + ".xsd");
        if (xsdFile.exists()) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                Schema schema = schemaFactory.newSchema(xsdFile);
                Validator validator = schema.newValidator();
                StreamSource ss = new StreamSource(new StringReader(xmlPayload));
                validator.validate(ss);
            }
            catch (SAXException e) {
                throw new BadRequestException("Unable to validate XML payload: " + e.getMessage());
            }
            catch (IOException e) {
                throw new BadRequestException("Unable to validate XML payload: " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Unable to validate XML payload: " + e.getMessage());
            }
            catch (NullPointerException e) {
                throw new BadRequestException("Unable to validate XML payload: " + e.getMessage());
            }
        } else {
            throw new BadRequestException("No XSD schema found for " + containerDefinition);
        }
    }
}

