/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.testsuite.module;

import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.AlarmSpeakerFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.ipe.sdt.testsuite.CSEUtil;
import org.eclipse.om2m.ipe.sdt.testsuite.TestReport;
import org.eclipse.om2m.ipe.sdt.testsuite.module.AbstractModuleTest;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.EnumDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.AlertColourCode;
import org.eclipse.om2m.sdt.home.types.DatapointType;

public class AlarmSpeakerModuleTest
extends AbstractModuleTest {
    public AlarmSpeakerModuleTest(CseService pCseService, Module pModule) {
        super(pCseService, pModule);
    }

    public TestReport testGetTone() {
        TestReport report = new TestReport("test " + this.getModule().getName() + ".getTone");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), this.getModuleUrl());
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve flexContainer of module " + this.getModule().getName() + ": " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        AlarmSpeakerFlexContainer retrievedFlexContainer = (AlarmSpeakerFlexContainer)response.getContent();
        CustomAttribute toneCA = retrievedFlexContainer.getCustomAttribute(DatapointType.tone.getShortName());
        if (toneCA == null) {
            if (this.getModule().getDataPoint(DatapointType.tone.getShortName()) != null) {
                report.setErrorMessage("tone customAttribute does not exist whereas tone Datapoint exists");
                report.setState(TestReport.State.KO);
                return report;
            }
        } else {
            Integer toneValueFromFlexContainer = null;
            try {
                toneValueFromFlexContainer = Integer.parseInt(toneCA.getCustomAttributeValue());
            }
            catch (NumberFormatException e) {
                report.setErrorMessage("NumberFormatException on toneValue from FlexContainer:" + toneCA.getCustomAttributeValue());
                report.setException(e);
                report.setState(TestReport.State.KO);
                return report;
            }
            EnumDataPoint toneDP = (EnumDataPoint)this.getModule().getDataPoint(DatapointType.tone.getShortName());
            Integer toneValueFromDP = null;
            try {
                toneValueFromDP = (Integer)toneDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve value tone: " + e.getMessage());
                report.setState(TestReport.State.KO);
                return report;
            }
            if (!this.checkObject(toneValueFromFlexContainer, toneValueFromDP, report, DatapointType.tone.getShortName())) {
                report.setErrorMessage("tone value from DataPoint and tone value from FlexContainer are different");
                report.setState(TestReport.State.KO);
                return report;
            }
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testSetTone() {
        TestReport report = new TestReport("test " + this.getModule() + ".setTone");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        EnumDataPoint toneDP = (EnumDataPoint)this.getModule().getDataPoint(DatapointType.tone.getShortName());
        if (toneDP != null) {
            Integer currentToneValueFromDP = null;
            try {
                currentToneValueFromDP = (Integer)toneDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve tone datapoint value :" + e.getMessage());
                report.setState(TestReport.State.KO);
                return report;
            }
            Integer possibleValue = (int)Math.round(Math.random() * 5.0);
            while (possibleValue.equals(currentToneValueFromDP)) {
                possibleValue = (int)Math.round(Math.random() * 5.0);
            }
            CustomAttribute toneCA = new CustomAttribute();
            toneCA.setCustomAttributeName(DatapointType.tone.getShortName());
            toneCA.setCustomAttributeValue(possibleValue.toString());
            AlarmSpeakerFlexContainer toBeUpdated = new AlarmSpeakerFlexContainer();
            toBeUpdated.getCustomAttributes().add(toneCA);
            ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.getModuleUrl(), (AbstractFlexContainer)toBeUpdated);
            if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
                report.setErrorMessage("Expecte UPDATED state: " + response.getContent());
                report.setState(TestReport.State.KO);
                return report;
            }
            try {
                currentToneValueFromDP = (Integer)toneDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve tone datapoint value :" + e.getMessage());
                report.setState(TestReport.State.KO);
                return report;
            }
            if (!this.checkObject(possibleValue, currentToneValueFromDP, report, "tone")) {
                return report;
            }
        } else {
            CustomAttribute toneCA = new CustomAttribute();
            toneCA.setCustomAttributeName(DatapointType.tone.getShortName());
            toneCA.setCustomAttributeValue("1");
            AlarmSpeakerFlexContainer toBeUpdated = new AlarmSpeakerFlexContainer();
            toBeUpdated.getCustomAttributes().add(toneCA);
            ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.getModuleUrl(), (AbstractFlexContainer)toBeUpdated);
            if (ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
                report.setErrorMessage("Expected UPDATE request failure: " + response.getContent());
                report.setState(TestReport.State.KO);
                return report;
            }
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testGetAlarmStatus() {
        TestReport report = new TestReport("Test " + this.getModule().getName() + ".getAlarmStatus");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), this.getModuleUrl());
        if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to retrieve flexContainer for module " + this.getModule().getName() + ": " + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        AlarmSpeakerFlexContainer retrievedFlexContainer = (AlarmSpeakerFlexContainer)response.getContent();
        CustomAttribute alarmStatusCA = retrievedFlexContainer.getCustomAttribute(DatapointType.alarmStatus.getShortName());
        if (alarmStatusCA == null) {
            if (this.getModule().getDataPoint("alarmStatus") != null) {
                report.setErrorMessage("alarmStatus Datapoint exists wheres alarmStatus customAttribute does not exist");
                report.setState(TestReport.State.KO);
                return report;
            }
        } else {
            BooleanDataPoint alarmStatusDP = (BooleanDataPoint)this.getModule().getDataPoint(DatapointType.alarmStatus.getShortName());
            Boolean alarmStatusValueFromDP = null;
            try {
                alarmStatusValueFromDP = (Boolean)alarmStatusDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve value of alarmStatus Datapoint:" + e.getMessage());
                report.setState(TestReport.State.KO);
                return report;
            }
            Boolean alarmStatusValueFromFlexContainer = Boolean.valueOf(alarmStatusCA.getCustomAttributeValue());
            if (!this.checkObject(alarmStatusValueFromDP, alarmStatusValueFromFlexContainer, report, DatapointType.alarmStatus.getShortName())) {
                return report;
            }
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testSetAlarmStatus() {
        TestReport report = new TestReport("test " + this.getModule().getName() + ".setAlarmStatus");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        BooleanDataPoint alarmStatusDP = (BooleanDataPoint)this.getModule().getDataPoint(DatapointType.alarmStatus.getShortName());
        Boolean alarmStatusValueFromDP = null;
        try {
            alarmStatusValueFromDP = (Boolean)alarmStatusDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve alarmStatus datapoint:" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        Boolean newAlarmStatusValue = alarmStatusValueFromDP == false;
        CustomAttribute alarmStatusCA = new CustomAttribute();
        alarmStatusCA.setCustomAttributeName(DatapointType.alarmStatus.getShortName());
        alarmStatusCA.setCustomAttributeValue(newAlarmStatusValue.toString());
        AlarmSpeakerFlexContainer toBeUpdated = new AlarmSpeakerFlexContainer();
        toBeUpdated.getCustomAttributes().add(alarmStatusCA);
        ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.getModuleUrl(), (AbstractFlexContainer)toBeUpdated);
        if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
            report.setErrorMessage("unable to update alarmStatus customAttribute:" + response.getContent());
            report.setState(TestReport.State.KO);
            return report;
        }
        try {
            alarmStatusValueFromDP = (Boolean)alarmStatusDP.getValue();
        }
        catch (AccessException | DataPointException e) {
            report.setErrorMessage("unable to retrieve alarmStatus datapoint:" + e.getMessage());
            report.setState(TestReport.State.KO);
            return report;
        }
        if (!this.checkObject(alarmStatusValueFromDP, newAlarmStatusValue, report, DatapointType.alarmStatus.getShortName())) {
            return report;
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testGetLight() {
        TestReport report = new TestReport("test " + this.getModule().getName() + ".getLight");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        AlertColourCode lightDP = (AlertColourCode)this.getModule().getDataPoint(DatapointType.light.getShortName());
        if (lightDP != null) {
            Integer lightValueFromDP = null;
            try {
                lightValueFromDP = (Integer)lightDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve value of light datapoint:" + e.getMessage());
                report.setException((Exception)e);
                return report;
            }
            ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), this.getModuleUrl());
            if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
                report.setErrorMessage("unable to retrieve FlexContainer:" + response.getContent());
                report.setState(TestReport.State.KO);
                return report;
            }
            AlarmSpeakerFlexContainer retrievedFlexContainer = (AlarmSpeakerFlexContainer)response.getContent();
            CustomAttribute lightCA = retrievedFlexContainer.getCustomAttribute(DatapointType.light.getShortName());
            if (lightCA == null) {
                report.setErrorMessage("no light customAttribute but light datapoint exists");
                report.setState(TestReport.State.KO);
                return report;
            }
            Integer lightValueFromFlexContainer = null;
            try {
                lightValueFromFlexContainer = Integer.parseInt(lightCA.getCustomAttributeValue());
            }
            catch (NumberFormatException e) {
                report.setErrorMessage("unable to cast light customAttribute value (" + lightCA.getCustomAttributeValue() + ") as an Integer");
                report.setState(TestReport.State.KO);
                return report;
            }
            if (!this.checkObject(lightValueFromDP, lightValueFromFlexContainer, report, DatapointType.light.getShortName())) {
                return report;
            }
        } else {
            ResponsePrimitive response = CSEUtil.retrieveEntity(this.getCseService(), this.getModuleUrl());
            if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode())) {
                report.setErrorMessage("unable to retrieve FlexContainer:" + response.getContent());
                report.setState(TestReport.State.KO);
                return report;
            }
            AlarmSpeakerFlexContainer retrievedFlexContainer = (AlarmSpeakerFlexContainer)response.getContent();
            CustomAttribute lightCA = retrievedFlexContainer.getCustomAttribute(DatapointType.light.getShortName());
            if (lightCA != null) {
                report.setErrorMessage("no light datapoint but light customAttribute exists");
                report.setState(TestReport.State.KO);
                return report;
            }
        }
        report.setState(TestReport.State.OK);
        return report;
    }

    public TestReport testSetLight() {
        TestReport report = new TestReport("test " + this.getModule().getName() + ".SetLight");
        if (!this.checkModuleUrl(report)) {
            return report;
        }
        AlertColourCode lightDP = (AlertColourCode)this.getModule().getDataPoint(DatapointType.light.getShortName());
        if (lightDP != null) {
            Integer lightValueFromDP = null;
            try {
                lightValueFromDP = (Integer)lightDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve light DataPoint:" + e.getMessage());
                report.setException((Exception)e);
                report.setState(TestReport.State.KO);
                return report;
            }
            Integer newLightValue = lightValueFromDP == 1 ? 2 : 1;
            AlarmSpeakerFlexContainer toBeUpdated = new AlarmSpeakerFlexContainer();
            CustomAttribute lightCA = new CustomAttribute();
            lightCA.setCustomAttributeName(DatapointType.light.getShortName());
            lightCA.setCustomAttributeValue(newLightValue.toString());
            toBeUpdated.getCustomAttributes().add(lightCA);
            ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.getModuleUrl(), (AbstractFlexContainer)toBeUpdated);
            if (!ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
                report.setErrorMessage("fail to update light customAttribute:" + response.getContent());
                report.setState(TestReport.State.KO);
                return report;
            }
            try {
                lightValueFromDP = (Integer)lightDP.getValue();
            }
            catch (AccessException | DataPointException e) {
                report.setErrorMessage("unable to retrieve light DataPoint:" + e.getMessage());
                report.setException((Exception)e);
                report.setState(TestReport.State.KO);
                return report;
            }
            if (!this.checkObject(lightValueFromDP, newLightValue, report, DatapointType.light.getShortName())) {
                return report;
            }
        } else {
            AlarmSpeakerFlexContainer toBeUpdated = new AlarmSpeakerFlexContainer();
            CustomAttribute lightCA = new CustomAttribute();
            lightCA.setCustomAttributeName(DatapointType.light.getShortName());
            lightCA.setCustomAttributeValue(Integer.valueOf(1).toString());
            toBeUpdated.getCustomAttributes().add(lightCA);
            ResponsePrimitive response = CSEUtil.updateFlexContainerEntity(this.getCseService(), this.getModuleUrl(), (AbstractFlexContainer)toBeUpdated);
            if (ResponseStatusCode.UPDATED.equals(response.getResponseStatusCode())) {
                report.setErrorMessage("light datapoint does not exist, UPDATE must fail");
                report.setState(TestReport.State.KO);
                return report;
            }
        }
        report.setState(TestReport.State.OK);
        return report;
    }
}

