/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.sdt.model;

import java.util.List;
import org.eclipse.om2m.ipe.sample.sdt.model.SampleBinarySwitch;
import org.eclipse.om2m.ipe.sample.sdt.model.SampleColour;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.Light;
import org.eclipse.om2m.sdt.home.driver.Utils;
import org.eclipse.om2m.sdt.home.modules.ColourSaturation;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Lamp
extends Light {
    private List<ServiceRegistration> serviceRegistrations;

    public Lamp(String id, String serial, Domain domain, BundleContext bundleContext) {
        super(id, serial, domain);
        this.addModule(new SampleBinarySwitch("binarySwitch_" + id, domain));
        this.addModule(new SampleColour("colour_" + id, domain));
        this.addModule(new ColourSaturation("colourSaturation_" + id, domain, new IntegerDataPoint((Identifiers)DatapointType.colourSat){
            private Integer v;
            {
                this.v = new Integer((int)(Math.random() * 100.0));
            }

            public void doSetValue(Integer value) throws DataPointException {
                this.v = value;
            }

            public Integer doGetValue() throws DataPointException {
                return this.v;
            }
        }));
        this.setDeviceModelName("Fake lamp as SDT Light");
        this.setDeviceName("SDT Light");
        this.setLocation("Kitchen");
        this.setDeviceManufacturer("OM2M");
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Utils.register((GenericDevice)this, (BundleContext)bundleContext);
    }

    public void unregisterDevice() {
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

