/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.List;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.exceptions.OperationNotAllowed;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.CSEBase;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;

public class CSEBaseController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive requestIndication) {
        throw new OperationNotAllowed("Create of CSEBase is not allowed");
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        CSEBaseEntity cseBaseEntity = (CSEBaseEntity)this.dbs.getDAOFactory().getCSEBaseDAO().find(this.transaction, (Object)request.getTargetId());
        if (cseBaseEntity == null) {
            throw new ResourceNotFoundException("Resource " + request.getTargetId() + "not found");
        }
        List acpList = cseBaseEntity.getAccessControlPolicies();
        this.checkACP(acpList, request.getFrom(), request.getOperation());
        CSEBase cseBaseResource = EntityMapperFactory.getCseBaseMapper().mapEntityToResource(cseBaseEntity, request);
        response.setContent((Object)cseBaseResource);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive requestIndication) {
        throw new OperationNotAllowed("Update of CSEBase is not allowed");
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive requestIndication) {
        throw new OperationNotAllowed("Delete of CSEBase is not allowed");
    }
}

