/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.mocked.devices;

import java.util.List;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.Thermostat;
import org.eclipse.om2m.sdt.home.mocked.devices.Activator;
import org.eclipse.om2m.sdt.home.mocked.devices.MockedDevice;
import org.eclipse.om2m.sdt.home.mocked.modules.MockedTemperature;
import org.eclipse.om2m.sdt.home.modules.Temperature;
import org.eclipse.om2m.sdt.home.modules.Timer;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.ServiceRegistration;

public class MockedThermostat
extends Thermostat
implements MockedDevice {
    private List<ServiceRegistration> serviceRegistrations;
    private float currentTemp;
    private float targetTemp;
    private Temperature temperature;
    private boolean running;

    public MockedThermostat(String id, String serial, Domain domain) {
        super(id, serial, domain);
        this.temperature = new MockedTemperature("temperature_" + id, domain, new FloatDataPoint((Identifiers)DatapointType.currentTemperature){

            public Float doGetValue() throws DataPointException {
                return Float.valueOf(MockedThermostat.this.currentTemp);
            }
        });
        this.temperature.setTargetTemperature(new FloatDataPoint((Identifiers)DatapointType.targetTemperature){

            protected Float doGetValue() throws DataPointException {
                return Float.valueOf(MockedThermostat.this.targetTemp);
            }

            protected void doSetValue(Float temp) throws DataPointException {
                MockedThermostat.this.targetTemp = temp.floatValue();
            }
        });
        this.addModule(this.temperature);
        Timer timer = new Timer("timer_" + id, domain);
        this.addModule(timer);
    }

    @Override
    public void registerDevice() {
        this.running = true;
        if (this.serviceRegistrations != null && !this.serviceRegistrations.isEmpty()) {
            return;
        }
        this.serviceRegistrations = Activator.register((GenericDevice)this);
    }

    @Override
    public void unregisterDevice() {
        this.running = false;
        if (this.serviceRegistrations == null) {
            return;
        }
        for (ServiceRegistration reg : this.serviceRegistrations) {
            reg.unregister();
        }
        this.serviceRegistrations.clear();
    }
}

