/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class Boiling
extends Module {
    private BooleanDataPoint keepWarm;
    private IntegerDataPoint status;

    public Boiling(String name, Domain domain, BooleanDataPoint keepWarm, IntegerDataPoint status) {
        super(name, domain, (Identifiers)ModuleType.boiling);
        if (status == null || !status.getShortDefinitionType().equals(DatapointType.status.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong status datapoint: " + status);
        }
        this.status = status;
        this.status.setDoc("The current status of the machine which prepares the drinks. Status equals 1 means the boiling is ongoing, 0 means the boiling is not ongoing.");
        status.setReadable(true);
        this.addDataPoint((DataPoint)this.status);
        this.keepWarm = keepWarm;
        this.keepWarm.setDoc("The current status of the keeping a drink warm after brewing enabling. \u201cTrue\u201d indicates enabled, and \u201cFalse\u201d indicates not enabled");
        this.addDataPoint((DataPoint)this.keepWarm);
    }

    public Boolean getKeepWarm() throws DataPointException, AccessException {
        return (Boolean)this.keepWarm.getValue();
    }

    public int getStatus() throws DataPointException, AccessException {
        return (Integer)this.status.getValue();
    }

    public void setKeepWarm(Boolean v) throws DataPointException, AccessException {
        this.keepWarm.setValue((Object)v);
    }

    public void setStatus(int v) throws DataPointException, AccessException {
        this.status.setValue((Object)v);
    }
}

