/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import javax.servlet.ServletException;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.NotificationContentType;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.Notification;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.resource.flexcontainerspec.BinarySwitchFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.datamapping.service.DataMapperService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.SubscriptionServlet;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class SubscriptionTest
extends FlexContainerTestSuite {
    private SubscriptionServlet subscriptionServlet;
    private final HttpService httpService;
    private final DataMapperService dataMapperService;
    private boolean isServletRegistered = false;
    private Exception servletRegistrationException;

    public SubscriptionTest(CseService pCseService, HttpService pHttpService, DataMapperService pDataMapper) {
        super(pCseService);
        this.httpService = pHttpService;
        this.dataMapperService = pDataMapper;
        this.subscriptionServlet = new SubscriptionServlet(pHttpService, pDataMapper);
        try {
            this.subscriptionServlet.registerServlet();
            this.isServletRegistered = true;
        }
        catch (ServletException e) {
            this.isServletRegistered = false;
            this.servletRegistrationException = e;
        }
        catch (NamespaceException e) {
            this.isServletRegistered = false;
            this.servletRegistrationException = e;
        }
    }

    @Override
    protected String getTestSuiteName() {
        return "SubscriptionTest";
    }

    /*
     * Unable to fully structure code
     */
    public void testCreateSubscription() throws InterruptedException {
        if (!this.checkServletIsRegistered("testCreateSubscription")) {
            return;
        }
        flexContainer = null;
        try {
            flexContainer = this.createBinarySwitchFlexContainer();
        }
        catch (Exception e) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        subscriptionName = "subscription_" + System.currentTimeMillis();
        subscription = new Subscription();
        subscription.getNotificationURI().add(this.subscriptionServlet.getServletUrl());
        subscription.setSubscriberURI(this.subscriptionServlet.getServletUrl());
        subscription.setNotificationContentType(NotificationContentType.MODIFIED_ATTRIBUTES);
        subscription.setName(subscriptionName);
        flexContainerLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + flexContainer.getName();
        response = this.sendCreateSubscriptionRequest(subscription, flexContainerLocation, this.dataMapperService.getServiceDataType());
        returnedSubscription = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "unable to create the subscription", null);
            return;
        }
        returnedSubscription = (Subscription)this.dataMapperService.stringToObj((String)response.getContent());
        if (!returnedSubscription.getNotificationURI().contains(this.subscriptionServlet.getServletUrl())) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "invalid notification URI", null);
            return;
        }
        if (!returnedSubscription.getName().equals(subscriptionName)) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "invalid subscription name(expected:" + subscriptionName + ", found:" + returnedSubscription.getName() + ")", null);
            return;
        }
        Thread.sleep(1000L);
        notification = this.subscriptionServlet.getLastNotification();
        if (notification == null) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "expecting Notification message", null);
            return;
        }
        System.out.println("notif=" + notification);
        this.subscriptionServlet.resetNotifications();
        response = this.sendRetrieveRequest(flexContainerLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.OK)) ** GOTO lbl55
        retrievedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
        childs = retrievedFlexContainer.getChildResource();
        if (childs != null && !childs.isEmpty()) {
            foundSubscription = false;
            System.out.println("child size = " + childs.size());
            for (ChildResourceRef ref : childs) {
                System.out.println("found childResourceRef=" + ref.getResourceName() + "( expected:" + subscriptionName + "), type=" + ref.getType());
                if (ref.getType().intValue() != 23 || !ref.getResourceName().equals(subscriptionName)) continue;
                foundSubscription = true;
                break;
            }
            if (!foundSubscription) {
                this.createTestReport("testCreateSubscription", TestReport.Status.KO, "no subscription found", null);
                return;
            }
        } else {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "no child (ie subscription) found", null);
            return;
lbl55:
            // 1 sources

            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "unable to retrieve the FlexContainer", null);
        }
        toBeUpdated = new BinarySwitchFlexContainer();
        ca = new CustomAttribute();
        ca.setShortName("powSe");
        ca.setValue("false");
        toBeUpdated.getCustomAttributes().add(ca);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "unable to update flexContainer", null);
            return;
        }
        Thread.sleep(1000L);
        notification = this.subscriptionServlet.getLastNotification();
        if (notification == null) ** GOTO lbl78
        notifiedFlexContainer = (BinarySwitchFlexContainer)notification.getNotificationEvent().getRepresentation().getResource();
        ca = notifiedFlexContainer.getCustomAttribute("powSe");
        if (ca != null) {
            if (!ca.getValue().equals("false")) {
                this.createTestReport("testCreateSubscription", TestReport.Status.KO, "CustomAttribute powerState value is wrong", null);
                return;
            }
        } else {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "Custom attribute powerState is missing", null);
            return;
lbl78:
            // 1 sources

            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "no notification received. Expected one !", null);
        }
        this.createTestReport("testCreateSubscription", TestReport.Status.OK, null, null);
    }

    public void testDeleteSubscription() throws InterruptedException {
        if (!this.checkServletIsRegistered("testCreateSubscription")) {
            return;
        }
        BinarySwitchFlexContainer flexContainer = null;
        try {
            flexContainer = this.createBinarySwitchFlexContainer();
        }
        catch (Exception e) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        String subscriptionName = "subscription_" + System.currentTimeMillis();
        Subscription subscription = new Subscription();
        subscription.getNotificationURI().add(this.subscriptionServlet.getServletUrl());
        subscription.setSubscriberURI(this.subscriptionServlet.getServletUrl());
        subscription.setNotificationContentType(NotificationContentType.MODIFIED_ATTRIBUTES);
        subscription.setName(subscriptionName);
        String flexContainerLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + flexContainer.getName();
        String subscriptionLocation = String.valueOf(flexContainerLocation) + "/" + subscriptionName;
        ResponsePrimitive response = this.sendCreateSubscriptionRequest(subscription, flexContainerLocation, this.dataMapperService.getServiceDataType());
        Subscription returnedSubscription = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "unable to create the subscription", null);
            return;
        }
        returnedSubscription = (Subscription)this.dataMapperService.stringToObj((String)response.getContent());
        if (!returnedSubscription.getNotificationURI().contains(this.subscriptionServlet.getServletUrl())) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "invalid notification URI", null);
            return;
        }
        if (!returnedSubscription.getName().equals(subscriptionName)) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "invalid subscription name(expected:" + subscriptionName + ", found:" + returnedSubscription.getName() + ")", null);
            return;
        }
        Thread.sleep(1000L);
        Notification notification = this.subscriptionServlet.getLastNotification();
        if (notification == null) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "expecting Notification message", null);
            return;
        }
        System.out.println("notif=" + notification);
        this.subscriptionServlet.resetNotifications();
        response = this.sendDeleteRequest(subscriptionLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteSubscription", TestReport.Status.KO, "unable to delete the subscription", null);
            return;
        }
        BinarySwitchFlexContainer toBeUpdated = new BinarySwitchFlexContainer();
        CustomAttribute ca = new CustomAttribute();
        ca.setShortName("powSe");
        ca.setValue("false");
        toBeUpdated.getCustomAttributes().add(ca);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testDeleteSubscription", TestReport.Status.KO, "unable to update flexContainer", null);
            return;
        }
        Thread.sleep(1000L);
        notification = this.subscriptionServlet.getLastNotification();
        if (notification != null) {
            this.createTestReport("testDeleteSubscription", TestReport.Status.KO, "notification received but not expected", null);
            return;
        }
        this.createTestReport("testDeleteSubscription", TestReport.Status.OK, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testUpdateSubscription() throws InterruptedException {
        if (!this.checkServletIsRegistered("testCreateSubscription")) {
            return;
        }
        BinarySwitchFlexContainer flexContainer = null;
        try {
            flexContainer = this.createBinarySwitchFlexContainer();
        }
        catch (Exception e) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, e.getMessage(), e);
            return;
        }
        String subscriptionName = "subscription_" + System.currentTimeMillis();
        Subscription subscription = new Subscription();
        subscription.getNotificationURI().add(this.subscriptionServlet.getServletUrl());
        subscription.setSubscriberURI(this.subscriptionServlet.getServletUrl());
        subscription.setNotificationContentType(NotificationContentType.MODIFIED_ATTRIBUTES);
        subscription.setName(subscriptionName);
        String flexContainerLocation = "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + flexContainer.getName();
        String subscriptionLocation = String.valueOf(flexContainerLocation) + "/" + subscriptionName;
        ResponsePrimitive response = this.sendCreateSubscriptionRequest(subscription, flexContainerLocation, this.dataMapperService.getServiceDataType());
        Subscription returnedSubscription = null;
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "unable to create the subscription", null);
            return;
        }
        returnedSubscription = (Subscription)this.dataMapperService.stringToObj((String)response.getContent());
        if (!returnedSubscription.getNotificationURI().contains(this.subscriptionServlet.getServletUrl())) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "invalid notification URI", null);
            return;
        }
        if (!returnedSubscription.getName().equals(subscriptionName)) {
            this.createTestReport("testCreateSubscription", TestReport.Status.KO, "invalid subscription name(expected:" + subscriptionName + ", found:" + returnedSubscription.getName() + ")", null);
            return;
        }
        Thread.sleep(1000L);
        Notification notification = this.subscriptionServlet.getLastNotification();
        if (notification == null) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "expecting Notification message", null);
            return;
        }
        System.out.println("notif=" + notification);
        this.subscriptionServlet.resetNotifications();
        BinarySwitchFlexContainer toBeUpdated = new BinarySwitchFlexContainer();
        CustomAttribute ca = new CustomAttribute();
        ca.setShortName("powSe");
        ca.setValue("false");
        toBeUpdated.getCustomAttributes().add(ca);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "unable to update flexContainer", null);
            return;
        }
        Thread.sleep(1000L);
        notification = this.subscriptionServlet.getLastNotification();
        if (notification != null) {
            BinarySwitchFlexContainer notifiedFlexContainer = (BinarySwitchFlexContainer)notification.getNotificationEvent().getRepresentation().getResource();
            ca = notifiedFlexContainer.getCustomAttribute("powSe");
            if (ca == null) {
                this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "Custom attribute powerState is missing", null);
                return;
            }
            if (!ca.getValue().equals("false")) {
                this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "CustomAttribute powerState value is wrong", null);
                return;
            }
        } else {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "no notification received. Expected one !", null);
        }
        SubscriptionServlet servlet2 = new SubscriptionServlet(this.httpService, this.dataMapperService);
        try {
            servlet2.registerServlet();
        }
        catch (ServletException e) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "unable to register servlet for notification", (Exception)((Object)e));
        }
        catch (NamespaceException e) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "unable to register servlet for notification", (Exception)((Object)e));
        }
        subscription.setName(null);
        subscription.getNotificationURI().clear();
        subscription.getNotificationURI().add(servlet2.getServletUrl());
        subscription.setSubscriberURI(null);
        response = this.sendUpdateSubscriptionRequest(subscriptionLocation, subscription);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "unable to update a subscription (expected:" + ResponseStatusCode.UPDATED + ", received:" + response.getResponseStatusCode() + ")", null);
            return;
        }
        servlet2.resetNotifications();
        this.subscriptionServlet.resetNotifications();
        toBeUpdated = new BinarySwitchFlexContainer();
        ca = new CustomAttribute();
        ca.setShortName("powSe");
        ca.setValue("false");
        toBeUpdated.getCustomAttributes().add(ca);
        response = this.sendUpdateFlexContainerRequest(flexContainerLocation, (AbstractFlexContainer)toBeUpdated);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "unable to update flexContainer", null);
            return;
        }
        Thread.sleep(1000L);
        notification = servlet2.getLastNotification();
        if (notification == null) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "no notification received. Expected one !", null);
            return;
        }
        BinarySwitchFlexContainer notifiedFlexContainer = (BinarySwitchFlexContainer)notification.getNotificationEvent().getRepresentation().getResource();
        ca = notifiedFlexContainer.getCustomAttribute("powSe");
        if (ca == null) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "Custom attribute powerState is missing", null);
            return;
        }
        if (!ca.getValue().equals("false")) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "CustomAttribute powerState value is wrong", null);
            return;
        }
        notification = this.subscriptionServlet.getLastNotification();
        if (notification != null) {
            this.createTestReport("testUpdateSubscription", TestReport.Status.KO, "Received a notification but not expected", null);
            return;
        }
        this.createTestReport("testUpdateSubscription", TestReport.Status.OK, null, null);
    }

    private BinarySwitchFlexContainer createBinarySwitchFlexContainer() throws Exception {
        BinarySwitchFlexContainer flexContainer = new BinarySwitchFlexContainer();
        flexContainer.setName("FlexContainer_" + System.currentTimeMillis());
        CustomAttribute ca = new CustomAttribute();
        ca.setShortName("powSe");
        ca.setValue("true");
        flexContainer.getCustomAttributes().add(ca);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)flexContainer, "/" + Constants.CSE_ID + "/" + Constants.CSE_NAME, Constants.ADMIN_REQUESTING_ENTITY);
        if (response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            return (BinarySwitchFlexContainer)response.getContent();
        }
        throw new Exception("Unable to create FlexContainer (responseStatusCode:" + response.getResponseStatusCode() + ")");
    }

    private boolean checkServletIsRegistered(String methodName) {
        if (!this.isServletRegistered) {
            this.createTestReport(methodName, TestReport.Status.KO, "NotificationServlet can be registered", this.servletRegistrationException);
            return false;
        }
        return true;
    }
}

