/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.args.Command;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.ActionException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.actions.DecrementNumberValue;
import org.eclipse.om2m.sdt.home.actions.IncrementNumberValue;
import org.eclipse.om2m.sdt.home.actions.ResetNumberValue;
import org.eclipse.om2m.sdt.home.types.ActionType;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class NumberValue
extends Module {
    private FloatDataPoint numberValue;
    private FloatDataPoint minValue;
    private FloatDataPoint maxValue;
    private FloatDataPoint defaultValue;
    private FloatDataPoint step;
    private Action decrementNumberValue;
    private Action incrementNumberValue;
    private Action resetNumberValue;

    public NumberValue(String name, Domain domain, FloatDataPoint numberValue, FloatDataPoint minValue, FloatDataPoint maxValue, FloatDataPoint defaultValue, FloatDataPoint step) {
        this(name, domain, numberValue, minValue, maxValue, defaultValue, step, ModuleType.numberValue);
    }

    public NumberValue(String name, Domain domain, FloatDataPoint numberValue) {
        this(name, domain, numberValue, null, null, null, null);
    }

    protected NumberValue(String name, Domain domain, FloatDataPoint numberValue, FloatDataPoint minValue, FloatDataPoint maxValue, FloatDataPoint defaultValue, FloatDataPoint step, ModuleType type) {
        super(name, domain, (Identifiers)type);
        if (numberValue == null || !numberValue.getShortName().equals(DatapointType.numberValue.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong numberValue datapoint: " + numberValue);
        }
        this.numberValue = numberValue;
        this.numberValue.setDoc("The actual value of the number.");
        this.numberValue.setOptional(false);
        this.numberValue.setReadable(true);
        this.addDataPoint((DataPoint)this.numberValue);
        if (minValue != null) {
            if (!minValue.getShortName().equals(DatapointType.minValue.getShortName())) {
                domain.removeModule(this.getName());
                throw new IllegalArgumentException("Wrong minValue datapoint: " + minValue);
            }
            this.minValue = minValue;
            this.minValue.setDoc("The optional minimum value of the number. The default is the system-specific minimum value for a float value.");
            this.minValue.setOptional(true);
            this.minValue.setReadable(true);
            this.addDataPoint((DataPoint)this.minValue);
        }
        if (maxValue != null) {
            if (!maxValue.getShortName().equals(DatapointType.maxValue.getShortName())) {
                domain.removeModule(this.getName());
                throw new IllegalArgumentException("Wrong maxValue datapoint: " + maxValue);
            }
            this.maxValue = maxValue;
            this.maxValue.setDoc("The optional maximum value of the number. The default is the system-specific maximum value for a float value.");
            this.maxValue.setOptional(true);
            this.maxValue.setReadable(true);
            this.addDataPoint((DataPoint)this.maxValue);
        }
        if (defaultValue != null) {
            if (!defaultValue.getShortName().equals(DatapointType.defaultValue.getShortName())) {
                domain.removeModule(this.getName());
                throw new IllegalArgumentException("Wrong defaultValue datapoint: " + defaultValue);
            }
            this.defaultValue = defaultValue;
            this.defaultValue.setDoc("The optional default value for the number. The default is 0.0.");
            this.defaultValue.setOptional(true);
            this.defaultValue.setReadable(true);
            this.addDataPoint((DataPoint)this.defaultValue);
        }
        if (step != null) {
            if (!step.getShortName().equals(DatapointType.step.getShortName())) {
                domain.removeModule(this.getName());
                throw new IllegalArgumentException("Wrong step datapoint: " + step);
            }
            this.step = step;
            this.step.setDoc("The optional step size for controlled increment and decrement. The default is 1.0 , even when this data point is not implemeneted.");
            this.step.setOptional(true);
            this.step.setReadable(true);
            this.addDataPoint((DataPoint)this.step);
        }
    }

    public NumberValue(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (FloatDataPoint)dps.get(DatapointType.numberValue.getShortName()), (FloatDataPoint)dps.get(DatapointType.minValue.getShortName()), (FloatDataPoint)dps.get(DatapointType.maxValue.getShortName()), (FloatDataPoint)dps.get(DatapointType.defaultValue.getShortName()), (FloatDataPoint)dps.get(DatapointType.step.getShortName()));
    }

    public void addAction(Action action) {
        if (action.getShortDefinitionName().equals(ActionType.resetNumberValue.getShortName())) {
            this.resetNumberValue = action;
            this.resetNumberValue.setOptional(true);
            this.resetNumberValue.setDoc("Reset the \"numberValue\" to its \"defaultValue\".");
            super.addAction(this.resetNumberValue);
        } else if (action.getShortDefinitionName().equals(ActionType.decrementNumberValue.getShortName())) {
            this.decrementNumberValue = action;
            this.decrementNumberValue.setOptional(true);
            this.decrementNumberValue.setDoc("Decrement the \"numberValue\" by the value of \"step\", down to the value of \"minimum\".");
            super.addAction(this.decrementNumberValue);
        } else if (action.getShortDefinitionName().equals(ActionType.incrementNumberValue.getShortName())) {
            this.incrementNumberValue = action;
            this.incrementNumberValue.setOptional(true);
            this.incrementNumberValue.setDoc("Increment the \"numberValue\" by the value of \"step\", down to the value of \"minimum\".");
            super.addAction(this.incrementNumberValue);
        } else {
            throw new IllegalArgumentException("Wrong action: " + action);
        }
    }

    public float getNumberValue() throws DataPointException, AccessException {
        return ((Float)this.numberValue.getValue()).floatValue();
    }

    public void setNumberValue(float v) throws DataPointException, AccessException {
        this.numberValue.setValue((Object)Float.valueOf(v));
    }

    public float getMinValue() throws DataPointException, AccessException {
        return ((Float)this.minValue.getValue()).floatValue();
    }

    public void setMinValue(float v) throws DataPointException, AccessException {
        this.minValue.setValue((Object)Float.valueOf(v));
    }

    public float getMaxValue() throws DataPointException, AccessException {
        return ((Float)this.maxValue.getValue()).floatValue();
    }

    public void setMaxValue(float v) throws DataPointException, AccessException {
        this.maxValue.setValue((Object)Float.valueOf(v));
    }

    public float getDefaultValue() throws DataPointException, AccessException {
        return ((Float)this.defaultValue.getValue()).floatValue();
    }

    public void setDefaultValue(float v) throws DataPointException, AccessException {
        this.defaultValue.setValue((Object)Float.valueOf(v));
    }

    public float getStep() throws DataPointException, AccessException {
        return ((Float)this.step.getValue()).floatValue();
    }

    public void setStep(float v) throws DataPointException, AccessException {
        this.step.setValue((Object)Float.valueOf(v));
    }

    public void setDecrementNumberValue(DecrementNumberValue a) {
        this.addAction((Action)a);
    }

    public void decrementNumberValue() throws ActionException, AccessException {
        if (this.decrementNumberValue == null) {
            throw new ActionException("Not implemented");
        }
        if (this.decrementNumberValue instanceof DecrementNumberValue) {
            ((DecrementNumberValue)this.decrementNumberValue).decrementNumberValue();
        } else {
            ((Command)this.decrementNumberValue).invoke(null);
        }
    }

    public void setIncrementNumberValue(IncrementNumberValue a) {
        this.addAction((Action)a);
    }

    public void incrementNumberValue() throws ActionException, AccessException {
        if (this.incrementNumberValue == null) {
            throw new ActionException("Not implemented");
        }
        if (this.incrementNumberValue instanceof IncrementNumberValue) {
            ((IncrementNumberValue)this.incrementNumberValue).incrementNumberValue();
        } else {
            ((Command)this.incrementNumberValue).invoke(null);
        }
    }

    public void resetNumberValue(ResetNumberValue a) {
        this.addAction((Action)a);
    }

    public void resetNumberValue() throws ActionException, AccessException {
        if (this.resetNumberValue == null) {
            throw new ActionException("Not implemented");
        }
        if (this.resetNumberValue instanceof ResetNumberValue) {
            ((ResetNumberValue)this.resetNumberValue).resetNumberValue();
        } else {
            ((Command)this.resetNumberValue).invoke(null);
        }
    }
}

