/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;
import org.eclipse.om2m.sdt.home.types.UvStatus;

public class UvSensor
extends Module {
    private UvStatus uvStatus;
    private FloatDataPoint uvValue;

    public UvSensor(String name, Domain domain, FloatDataPoint uvValue) {
        super(name, domain, (Identifiers)ModuleType.uvSensor);
        if (uvValue == null || !uvValue.getShortName().equals(DatapointType.uvValue.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong uvValue datapoint: " + uvValue);
        }
        this.setDoc("This ModuleClass describes the capabilities of an ultraviolet sensor.");
        this.uvValue = uvValue;
        this.uvValue.setWritable(false);
        this.uvValue.setDoc("The measure of the UV intensity of radiation in mW/cm^2");
        this.addDataPoint((DataPoint)uvValue);
    }

    public UvSensor(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (FloatDataPoint)dps.get(DatapointType.uvValue.getShortName()));
        UvStatus uvStatus = (UvStatus)dps.get(DatapointType.uvStatus.getShortName());
        if (uvStatus != null) {
            this.setUvStatus(uvStatus);
        }
    }

    protected void setUvStatus(UvStatus dp) {
        this.uvStatus = dp;
        this.uvStatus.setOptional(true);
        this.uvStatus.setWritable(false);
        this.uvStatus.setDoc("Indicates the level of the UV radiation status (see clause 5.6.30).");
        this.addDataPoint((DataPoint)this.uvStatus);
    }

    public float getUvValue() throws DataPointException, AccessException {
        return ((Float)this.uvValue.getValue()).floatValue();
    }

    public UvStatus.Values getSensitivity() throws DataPointException, AccessException {
        if (this.uvStatus == null) {
            throw new DataPointException("Not implemented");
        }
        return (UvStatus.Values)((Object)this.uvStatus.getValue());
    }
}

