/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.List;
import java.util.Map;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.args.Command;
import org.eclipse.om2m.sdt.datapoints.ArrayDataPoint;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.ActionException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.actions.NextTrack;
import org.eclipse.om2m.sdt.home.actions.PreviousTrack;
import org.eclipse.om2m.sdt.home.types.ActionType;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;
import org.eclipse.om2m.sdt.home.types.PlayerMode;

public class PlayerControl
extends Module {
    private PlayerMode currentPlayerMode;
    private StringDataPoint currentPlayerModeName;
    private ArrayDataPoint<PlayerMode.Values> supportedPlayerModes;
    private FloatDataPoint speedFactor;
    private Action nextTrack;
    private Action previousTrack;

    public PlayerControl(String name, Domain domain, PlayerMode currentPlayerMode, ArrayDataPoint<PlayerMode.Values> supportedPlayerModes) {
        super(name, domain, (Identifiers)ModuleType.playerControl);
        if (currentPlayerMode == null || !currentPlayerMode.getShortName().equals(DatapointType.currentPlayerMode.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong currentPlayerMode datapoint: " + (Object)((Object)currentPlayerMode));
        }
        this.currentPlayerMode = currentPlayerMode;
        this.currentPlayerMode.setWritable(true);
        this.currentPlayerMode.setDoc("The current mode of the player.");
        this.addDataPoint((DataPoint)this.currentPlayerMode);
        if (supportedPlayerModes == null || !supportedPlayerModes.getShortName().equals(DatapointType.supportedPlayerModes.getShortName())) {
            throw new IllegalArgumentException("Wrong supportedPlayerModes datapoint: " + supportedPlayerModes);
        }
        this.supportedPlayerModes = supportedPlayerModes;
        this.supportedPlayerModes.setWritable(false);
        this.supportedPlayerModes.setDoc("List of supported modes for a player.");
        this.addDataPoint((DataPoint)this.supportedPlayerModes);
    }

    public PlayerControl(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (PlayerMode)dps.get(DatapointType.currentPlayerMode.getShortName()), (ArrayDataPoint<PlayerMode.Values>)((ArrayDataPoint)dps.get(DatapointType.supportedPlayerModes.getShortName())));
        FloatDataPoint speedFactor;
        StringDataPoint currentPlayerModeName = (StringDataPoint)dps.get(DatapointType.currentPlayerModeName.getShortName());
        if (currentPlayerModeName != null) {
            this.setCurrentPlayerModeName(currentPlayerModeName);
        }
        if ((speedFactor = (FloatDataPoint)dps.get(DatapointType.speedFactor.getShortName())) != null) {
            this.setSpeedFactor(speedFactor);
        }
    }

    public void addAction(Action action) {
        if (action.getShortDefinitionName().equals(ActionType.nextTrack.getShortName())) {
            this.nextTrack = action;
            super.addAction(this.nextTrack);
        } else if (action.getShortDefinitionName().equals(ActionType.previousTrack.getShortName())) {
            this.previousTrack = action;
            super.addAction(this.previousTrack);
        } else {
            throw new IllegalArgumentException("Wrong action: " + action);
        }
    }

    public void setNextTrack(NextTrack nextTrack) {
        this.addAction((Action)nextTrack);
    }

    public void setPreviousTrack(PreviousTrack previousTrack) {
        this.addAction((Action)previousTrack);
    }

    public void nextTrack() throws ActionException, AccessException {
        if (this.nextTrack == null) {
            throw new ActionException("Not implemented");
        }
        ((Command)this.nextTrack).invoke(null);
    }

    public void previousTrack() throws ActionException, AccessException {
        if (this.previousTrack == null) {
            throw new ActionException("Not implemented");
        }
        ((Command)this.previousTrack).invoke(null);
    }

    public PlayerMode.Values getPlayerMode() throws DataPointException, AccessException {
        return (PlayerMode.Values)((Object)this.currentPlayerMode.getValue());
    }

    public void setPlayerMode(PlayerMode.Values v) throws DataPointException, AccessException {
        this.currentPlayerMode.setValue((Object)v);
    }

    public List<PlayerMode.Values> getSupportedPlayerModes() throws DataPointException, AccessException {
        return (List)this.supportedPlayerModes.getValue();
    }

    public void setCurrentPlayerModeName(StringDataPoint sv) {
        this.currentPlayerModeName = sv;
        this.currentPlayerModeName.setWritable(false);
        this.currentPlayerModeName.setOptional(true);
        this.currentPlayerModeName.setDoc("Name of current player mode in string. This can be used when \u201ccurrentPlayerMode\u201d is vendor-specific.");
        this.addDataPoint((DataPoint)this.currentPlayerModeName);
    }

    public String getCurrentPlayerModeName() throws DataPointException, AccessException {
        if (this.currentPlayerModeName == null) {
            throw new DataPointException("Not implemented");
        }
        return (String)this.currentPlayerModeName.getValue();
    }

    public void setSpeedFactor(FloatDataPoint mv) {
        this.speedFactor = mv;
        this.speedFactor.setWritable(true);
        this.speedFactor.setOptional(true);
        this.speedFactor.setDoc("The optional factor of speeding up or slowing down playback, rewind or fast forward.");
        this.addDataPoint((DataPoint)this.speedFactor);
    }

    public float getSpeedFactor() throws DataPointException, AccessException {
        if (this.speedFactor == null) {
            throw new DataPointException("Not implemented");
        }
        return ((Float)this.speedFactor.getValue()).floatValue();
    }

    public void setSpeedFactor(float v) throws DataPointException, AccessException {
        if (this.speedFactor == null) {
            throw new DataPointException("Not implemented");
        }
        this.speedFactor.setValue((Object)Float.valueOf(v));
    }
}

