/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.types;

import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.home.types.FlexContainers;
import org.eclipse.om2m.sdt.home.types.HomeDataType;
import org.eclipse.om2m.sdt.types.DataType;

public enum DatapointType implements Identifiers.Typed
{
    absoluteEnergyConsumption,
    absoluteStartTime,
    absoluteStopTime,
    acousticStatus,
    alarm,
    alarmStatus,
    atmosphericPressure,
    availableChannels,
    bath,
    batteryThreshold,
    blue,
    bone,
    brightness,
    capacity,
    ch2o,
    channelId,
    charging,
    co,
    co2,
    coarseness,
    code,
    colourSaturation,
    cupsNumber,
    current,
    currentDate,
    currentJobState,
    currentMachineState,
    currentPlayerMode,
    currentPlayerModeName,
    currentTemperature,
    currentTime,
    currentValue,
    defaultValue,
    defrost,
    description,
    desiredHumidity,
    detectedPersons,
    detectedTime,
    diastolicPressure,
    discharging,
    doorState,
    duration,
    estimatedTimeToEnd,
    fat,
    filterLifetime,
    foamingStrength,
    frequency,
    grainsRemaining,
    green,
    height,
    jobStates,
    kcal,
    keyNumber,
    level,
    light,
    liquidLevel,
    lock,
    loginName,
    loudness,
    lowBattery,
    lqi,
    machineStates,
    maxPressureThreshhold,
    maxValue,
    mediaID,
    mediaName,
    mediaType,
    minPressureThreshhold,
    minValue,
    monitoringEnabled,
    multiplyingFactors,
    muscle,
    muteEnabled,
    numberValue,
    openAlarm,
    openDuration,
    oxygenSaturation,
    password,
    power,
    powerGenerationData,
    powerSaveEnabled,
    powerState,
    previousChannel,
    progressPercentage,
    pulseRate,
    pushed,
    rapidCool,
    rapidFreeze,
    red,
    referenceTimer,
    relativeHumidity,
    resistance,
    roundingEnergyConsumption,
    roundingEnergyGeneration,
    rssi,
    runningTime,
    sdp,
    sensitivity,
    sensorHumidity,
    sensorOdor,
    sensorPM1,
    sensorPM10,
    sensorPM2,
    significantDigits,
    silentTime,
    smokeThreshhold,
    speed,
    speedFactor,
    spinLevelStrength,
    status,
    step,
    stepValue,
    strength,
    supportedMediaSources,
    supportedPlayerModes,
    systolicPressure,
    targetDuration,
    targetTemperature,
    targetTimeToStart,
    targetTimeToStop,
    temperature,
    temperatureThreshhold,
    token,
    tone,
    turboEnabled,
    unit,
    url,
    useGrinder,
    uvStatus,
    uvValue,
    visceraFat,
    voc,
    voltage,
    volumePercentage,
    water,
    weight;

    private final String longDefinitionName = this.toString();
    private final String shortDefinitionName;
    private final DataType dataType;

    private DatapointType() {
        String[] dp = FlexContainers.getDataPoint(this.longDefinitionName);
        this.shortDefinitionName = dp[0];
        this.dataType = HomeDataType.getDataType(dp[1]);
    }

    public String getLongName() {
        return this.longDefinitionName;
    }

    public String getShortName() {
        return this.shortDefinitionName;
    }

    public String getDefinition() {
        return null;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public static DatapointType fromLongName(String def) {
        DatapointType[] datapointTypeArray = DatapointType.values();
        int n = datapointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatapointType c = datapointTypeArray[n2];
            if (c.longDefinitionName.equals(def)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    public static DatapointType fromShortName(String def) {
        DatapointType[] datapointTypeArray = DatapointType.values();
        int n = datapointTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatapointType c = datapointTypeArray[n2];
            if (c.shortDefinitionName.equals(def)) {
                return c;
            }
            ++n2;
        }
        return null;
    }
}

