/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.DeviceInfo;
import org.eclipse.om2m.commons.resource.MgmtObj;

@Entity(name="dvi")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class DeviceInfoEntity
extends MgmtObjEntity {
    @Column(name="dlb")
    protected String deviceLabel;
    @Column(name="dty")
    protected String deviceType;
    @Column(name="mod")
    protected String model;
    @Column(name="man")
    protected String manufacturer;
    @Column(name="fwv")
    protected String fwVersion;
    @Column(name="swv")
    protected String swVersion;
    @Column(name="hwv")
    protected String hwVersion;
    @Column(name="osv")
    protected String osVersion;
    @Column(name="mfdl")
    protected String manufacturerDetailsLink;
    @Column(name="mfd")
    protected String manufacturingDate;
    @Column(name="smod")
    protected String subModel;
    @Column(name="dvnm")
    protected String deviceName;
    @Column(name="cnty")
    protected String country;
    @Column(name="loc")
    protected String location;
    @Column(name="syst")
    protected String systemTime;
    @Column(name="spur")
    protected String supportURL;
    @Column(name="purl")
    protected String presentationURL;
    @Column(name="ptl")
    protected String protocol;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="DVI_ACP_JOIN", joinColumns={@JoinColumn(name="DVI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> accessControlPolicies;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="linkedDeviceInfoEntities")
    @JoinTable(name="DVI_DAC_JOIN", joinColumns={@JoinColumn(name="DVI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> dynamicAuthorizationConsultations;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=SubscriptionEntity.class, mappedBy="parentDvi")
    @JoinTable(name="DVI_SUB_JOIN", joinColumns={@JoinColumn(name="DVI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=NodeEntity.class)
    @JoinTable(name="DVI_NOD_JOIN", joinColumns={@JoinColumn(name="DVI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected NodeEntity parentNode;

    public DeviceInfoEntity() {
        this.mgmtDefinition = MgmtDefinitionTypes.DEVICE_INFO;
    }

    @Override
    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Override
    public NodeEntity getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParentNode(NodeEntity parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.accessControlPolicies == null) {
            this.accessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.accessControlPolicies;
    }

    @Override
    public void setAccessControlPolicies(List<AccessControlPolicyEntity> acps) {
        this.accessControlPolicies = acps;
    }

    @Override
    public List<DynamicAuthorizationConsultationEntity> getDynamicAuthorizationConsultations() {
        if (this.dynamicAuthorizationConsultations == null) {
            this.dynamicAuthorizationConsultations = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.dynamicAuthorizationConsultations;
    }

    @Override
    public void setDynamicAuthorizationConsultations(List<DynamicAuthorizationConsultationEntity> list) {
        this.dynamicAuthorizationConsultations = list;
    }

    public String getDeviceLabel() {
        return this.deviceLabel;
    }

    public void setDeviceLabel(String deviceLabel) {
        this.deviceLabel = deviceLabel;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getFwVersion() {
        return this.fwVersion;
    }

    public void setFwVersion(String fwVersion) {
        this.fwVersion = fwVersion;
    }

    public String getSwVersion() {
        return this.swVersion;
    }

    public void setSwVersion(String swVersion) {
        this.swVersion = swVersion;
    }

    public String getHwVersion() {
        return this.hwVersion;
    }

    public void setHwVersion(String hwVersion) {
        this.hwVersion = hwVersion;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public String getManufacturerDetailsLink() {
        return this.manufacturerDetailsLink;
    }

    public void setManufacturerDetailsLink(String manufacturerDetailsLink) {
        this.manufacturerDetailsLink = manufacturerDetailsLink;
    }

    public String getManufacturingDate() {
        return this.manufacturingDate;
    }

    public void setManufacturingDate(String manufacturingDate) {
        this.manufacturingDate = manufacturingDate;
    }

    public String getSubModel() {
        return this.subModel;
    }

    public void setSubModel(String subModel) {
        this.subModel = subModel;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getSystemTime() {
        return this.systemTime;
    }

    public void setSystemTime(String systemTime) {
        this.systemTime = systemTime;
    }

    public String getSupportURL() {
        return this.supportURL;
    }

    public void setSupportURL(String supportURL) {
        this.supportURL = supportURL;
    }

    public String getPresentationURL() {
        return this.presentationURL;
    }

    public void setPresentationURL(String presentationURL) {
        this.presentationURL = presentationURL;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public void fillFrom(MgmtObj mgmtObj) {
        super.fillFrom(mgmtObj);
        DeviceInfo di = (DeviceInfo)mgmtObj;
        this.deviceLabel = di.getDeviceLabel();
        this.deviceType = di.getDeviceType();
        this.model = di.getModel();
        this.manufacturer = di.getManufacturer();
        this.fwVersion = di.getFwVersion();
        this.swVersion = di.getSwVersion();
        this.hwVersion = di.getHwVersion();
        this.osVersion = di.getOsVersion();
        this.manufacturerDetailsLink = di.getManufacturerDetailsLink();
        this.manufacturingDate = di.getManufacturingDate();
        this.subModel = di.getSubModel();
        this.deviceName = di.getDeviceName();
        this.country = di.getCountry();
        this.location = di.getLocation();
        this.systemTime = di.getSystemTime();
        this.supportURL = di.getSupportURL();
        this.presentationURL = di.getPresentationURL();
        this.protocol = di.getProtocol();
    }
}

