/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnouncedResourceEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoAnncEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoAnncEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoAnncEntity;
import org.eclipse.om2m.commons.entities.NodeAnncEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.resource.AnnouncedMgmtResource;

@MappedSuperclass
public abstract class MgmtObjAnncEntity
extends AnnouncedResourceEntity {
    @Column(name="mgd")
    protected BigInteger mgmtDefinition;
    @Column(name="obis")
    protected List<String> objectIDs;
    @Column(name="obps")
    protected List<String> objectPaths;
    @Column(name="dc")
    protected String description;

    public BigInteger getMgmtDefinition() {
        return this.mgmtDefinition;
    }

    public List<String> getObjectIDs() {
        if (this.objectIDs == null) {
            this.objectIDs = new ArrayList<String>();
        }
        return this.objectIDs;
    }

    public void setObjectIDs(List<String> objectIDs) {
        this.objectIDs = objectIDs;
    }

    public List<String> getObjectPaths() {
        if (this.objectPaths == null) {
            this.objectPaths = new ArrayList<String>();
        }
        return this.objectPaths;
    }

    public void setObjectPaths(List<String> objectPaths) {
        this.objectPaths = objectPaths;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMgmtDefinition(BigInteger mgmtDefinition) {
        this.mgmtDefinition = mgmtDefinition;
    }

    public void fillFrom(AnnouncedMgmtResource mgmtObj) {
        this.mgmtDefinition = mgmtObj.getMgmtDefinition();
        this.description = mgmtObj.getDescription();
        this.objectIDs = mgmtObj.getObjectIDs();
        this.objectPaths = mgmtObj.getObjectPaths();
    }

    public static MgmtObjAnncEntity create(BigInteger mgmtDef) {
        if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_INFO)) {
            return new AreaNwkInfoAnncEntity();
        }
        if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO)) {
            return new AreaNwkDeviceInfoAnncEntity();
        }
        if (mgmtDef.equals(MgmtDefinitionTypes.DEVICE_INFO)) {
            return new DeviceInfoAnncEntity();
        }
        throw new BadRequestException("Not implemented");
    }

    public abstract NodeAnncEntity getParentNode();

    public abstract void setParentNode(NodeAnncEntity var1);

    @Override
    public abstract List<AccessControlPolicyEntity> getAccessControlPolicies();

    public abstract List<SubscriptionEntity> getSubscriptions();
}

