/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.binding.service.RestClientService;
import org.eclipse.om2m.commons.constants.CSEType;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.core.CSEInitializer;
import org.eclipse.om2m.core.comm.RestClient;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.flexcontainer.FlexContainerSelector;
import org.eclipse.om2m.core.interworking.IpeSelector;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.remotecse.RemoteCseService;
import org.eclipse.om2m.core.router.Router;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.core.thread.CoreExecutor;
import org.eclipse.om2m.datamapping.service.DataMapperService;
import org.eclipse.om2m.flexcontainer.service.FlexContainerService;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.eclipse.om2m.persistence.service.DBService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static Log LOGGER;
    private ServiceTracker<Object, Object> ipeServiceTracker;
    private ServiceTracker<Object, Object> restClientServiceTracker;
    private ServiceTracker<Object, Object> dataMapperServiceTracker;
    private ServiceTracker<Object, Object> databaseServiceTracker;
    private ServiceTracker<Object, Object> flexContainerServiceTracker;
    private ServiceTracker<Object, Object> eventAdminTracker;

    static {
        LOGGER = LogFactory.getLog(Activator.class);
    }

    public void start(BundleContext bundleContext) throws Exception {
        LOGGER.info((Object)"Starting CSE...");
        context = bundleContext;
        this.dataMapperServiceTracker = new ServiceTracker<Object, Object>(bundleContext, DataMapperService.class.getName(), null){

            public Object addingService(ServiceReference<Object> reference) {
                DataMapperService dataMapper = (DataMapperService)this.context.getService(reference);
                LOGGER.info((Object)("Added Data Mapper Service: " + dataMapper.getServiceDataType()));
                DataMapperSelector.getDataMapperList().put(dataMapper.getServiceDataType(), dataMapper);
                return dataMapper;
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                DataMapperService dataMapper = (DataMapperService)service;
                LOGGER.info((Object)("Removed Data Mapper Service: " + dataMapper.getServiceDataType()));
                DataMapperSelector.getDataMapperList().remove(dataMapper.getServiceDataType());
            }
        };
        this.dataMapperServiceTracker.open();
        this.databaseServiceTracker = new ServiceTracker<Object, Object>(bundleContext, DBService.class.getName(), null){

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"DataBase persistence service discovered");
                DBService dbService = (DBService)this.context.getService(reference);
                PersistenceService.getInstance().setDbService(dbService);
                CoreExecutor.postThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CSEInitializer.init();
                        }
                        catch (InterruptedException e) {
                            LOGGER.error((Object)"Error in CSEInitializer", (Throwable)e);
                        }
                        LOGGER.info((Object)"Registering CseService...");
                        context.registerService(CseService.class.getName(), (Object)new Router(), null);
                        LOGGER.info((Object)"CSE Started");
                    }
                });
                return dbService;
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"Database persistence service removed.");
                PersistenceService.getInstance().setDbService(null);
            }
        };
        this.databaseServiceTracker.open();
        this.restClientServiceTracker = new ServiceTracker<Object, Object>(bundleContext, RestClientService.class.getName(), null){

            public Object addingService(ServiceReference<Object> reference) {
                RestClientService service = (RestClientService)this.context.getService(reference);
                RestClient.getRestClients().put(service.getProtocol(), service);
                LOGGER.info((Object)("Rest client service discovered. Protocol: " + service.getProtocol()));
                return service;
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"Rest client service removed");
                RestClientService restClientService = (RestClientService)service;
                RestClient.getRestClients().remove(restClientService.getProtocol());
            }
        };
        this.restClientServiceTracker.open();
        this.ipeServiceTracker = new ServiceTracker<Object, Object>(bundleContext, InterworkingService.class.getName(), null){

            public Object addingService(ServiceReference<Object> reference) {
                InterworkingService service = (InterworkingService)this.context.getService(reference);
                IpeSelector.getInterworkingList().put(service.getAPOCPath(), service);
                LOGGER.info((Object)("IPE service discovered: " + service.getAPOCPath()));
                return service;
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                InterworkingService ipeService = (InterworkingService)service;
                LOGGER.info((Object)("IPE service removed: " + ipeService.getAPOCPath()));
                IpeSelector.getInterworkingList().remove(ipeService.getAPOCPath());
            }
        };
        this.ipeServiceTracker.open();
        this.flexContainerServiceTracker = new ServiceTracker<Object, Object>(bundleContext, FlexContainerService.class.getName(), null){

            public Object addingService(ServiceReference<Object> reference) {
                FlexContainerService fcs = (FlexContainerService)this.context.getService(reference);
                FlexContainerSelector.addFlexContainerService(fcs.getFlexContainerLocation(), fcs);
                LOGGER.info((Object)("FlexContainerService discovered for " + fcs.getFlexContainerLocation()));
                return fcs;
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                FlexContainerService fcs = (FlexContainerService)service;
                FlexContainerSelector.removeFlexContainerService(fcs);
                LOGGER.info((Object)("FlexContainerService removed for " + fcs.getFlexContainerLocation()));
            }
        };
        this.flexContainerServiceTracker.open();
        this.eventAdminTracker = new ServiceTracker<Object, Object>(bundleContext, EventAdmin.class.getName(), null){

            public Object addingService(ServiceReference<Object> reference) {
                EventAdmin eventAdmin = (EventAdmin)this.context.getService(reference);
                RemoteCseService.getInstance().setEventAdmin(eventAdmin);
                return eventAdmin;
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                RemoteCseService.getInstance().setEventAdmin(null);
            }
        };
        this.eventAdminTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        LOGGER.info((Object)"Stopping CSE");
        if (!Constants.CSE_TYPE.equals(CSEType.IN_CSE)) {
            CSEInitializer.unregisterCse();
        }
    }

    protected static BundleContext getContext() {
        return context;
    }
}

