/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.flexcontainerservice;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.flexcontainer.service.FlexContainerService;
import org.eclipse.om2m.ipe.sdt.Activator;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.args.Command;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.ActionException;
import org.eclipse.om2m.sdt.types.DataType;
import org.osgi.framework.ServiceRegistration;

public class ActionFlexContainerService
implements FlexContainerService {
    private static Log logger = LogFactory.getLog(ActionFlexContainerService.class);
    private final Action action;
    private final String resourceId;
    private ServiceRegistration serviceRegistration;

    public ActionFlexContainerService(Action pAction, String pResourceId) {
        this.action = pAction;
        this.resourceId = pResourceId;
    }

    public void register() {
        if (this.serviceRegistration != null) {
            return;
        }
        this.serviceRegistration = Activator.registerFlexContainerService(this);
    }

    public void unregister() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    public String getCustomAttributeValue(String customAttributeName) throws Om2mException {
        return null;
    }

    public Map<String, String> getCustomAttributeValues(List<String> customAttributeNames) throws Om2mException {
        return Collections.emptyMap();
    }

    public void setCustomAttributeValues(List<CustomAttribute> customAttributes, RequestPrimitive requestPrimitive) throws Om2mException {
        logger.debug((Object)("setCustomAttributeValues(" + customAttributes + ")"));
        HashMap<String, Object> args = null;
        if (requestPrimitive.getContent() != null && customAttributes.size() != 0) {
            args = new HashMap<String, Object>();
            try {
                for (String argName : this.action.getArgNames()) {
                    CustomAttribute ca = ActionFlexContainerService.getCustomAttribute(customAttributes, argName);
                    if (ca == null) continue;
                    DataType type = DataType.getDataType((String)ca.getType());
                    args.put(argName, type.getTypeChoice().fromString(ca.getValue()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            logger.debug((Object)("setCustomAttributeValues(" + customAttributes + ") - invoke action"));
            Object response = ((Command)this.action).invoke(args);
            if (response != null) {
                CustomAttribute output = new CustomAttribute();
                output.setShortName("output");
                output.setValue(response.toString());
                customAttributes.add(output);
            }
        }
        catch (ActionException e) {
            logger.info((Object)("setCustomAttributeValues(" + customAttributes + ") - KO: " + e.getMessage()));
            throw new Om2mException("action execution failed:" + e.getMessage(), ResponseStatusCode.BAD_REQUEST);
        }
        catch (AccessException e) {
            logger.info((Object)("setCustomAttributeValues(" + customAttributes + ") - KO: " + e.getMessage()));
            throw new Om2mException("action execution failed:" + e.getMessage(), ResponseStatusCode.ACCESS_DENIED);
        }
    }

    public String getFlexContainerLocation() {
        return this.resourceId;
    }

    private static CustomAttribute getCustomAttribute(List<CustomAttribute> customAttributes, String name) {
        if (customAttributes != null) {
            for (CustomAttribute ca : customAttributes) {
                if (!name.equals(ca.getShortName())) continue;
                return ca;
            }
        }
        return null;
    }
}

