/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.types;

import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BasicType {
    private static final String PREFIX = "xs:";
    private static final String S_INTEGER = "xs:integer";
    private static final String S_BOOLEAN = "xs:boolean";
    private static final String S_STRING = "xs:string";
    private static final String S_BYTE = "xs:byte";
    private static final String S_FLOAT = "xs:float";
    private static final String S_ENUM = "xs:enum";
    private static final String S_DATE = "xs:date";
    private static final String S_TIME = "xs:time";
    private static final String S_DATETIME = "xs:datetime";
    private static final String S_BLOB = "xs:blob";
    private static final String S_URI = "xs:uri";
    private static final DateFormat dateTimeFormat = DateFormat.getDateTimeInstance();
    private static final DateFormat dateFormat = DateFormat.getDateInstance();
    private static final DateFormat timeFormat = DateFormat.getTimeInstance();
    private static Map<String, BasicType> values = new HashMap<String, BasicType>();
    public static final BasicType INTEGER = new BasicType("xs:integer", Integer.class);
    public static final BasicType BOOLEAN = new BasicType("xs:boolean", Boolean.class);
    public static final BasicType STRING = new BasicType("xs:string", String.class);
    public static final BasicType BYTE = new BasicType("xs:byte", Byte.class);
    public static final BasicType FLOAT = new BasicType("xs:float", Float.class);
    public static final BasicType ENUM = new BasicType("xs:enum", Enum.class);
    public static final BasicType DATE = new BasicType("xs:date", Date.class);
    public static final BasicType TIME = new BasicType("xs:time", Date.class);
    public static final BasicType DATETIME = new BasicType("xs:datetime", Date.class);
    public static final BasicType BLOB = new BasicType("xs:blob", byte[].class);
    public static final BasicType URI = new BasicType("xs:uri", URI.class);
    private final String value;
    private final Class<?> clazz;

    protected BasicType(String v, Class<?> c) {
        this.value = v;
        this.clazz = c;
        values.put(v, this);
    }

    public String getValue() {
        return this.value;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public static BasicType getBasicType(String s) {
        return values.get(s);
    }

    public String toString(Object val) {
        if (val == null) {
            return null;
        }
        switch (this.value) {
            case "xs:byte": 
            case "xs:enum": 
            case "xs:boolean": 
            case "xs:uri": 
            case "xs:float": 
            case "xs:string": 
            case "xs:integer": {
                return val.toString();
            }
            case "xs:datetime": {
                return dateTimeFormat.format((Date)val);
            }
            case "xs:time": {
                return timeFormat.format((Date)val);
            }
            case "xs:date": {
                return dateFormat.format((Date)val);
            }
            case "xs:blob": {
                return val.toString();
            }
        }
        return null;
    }

    public Object fromString(String val) throws Exception {
        switch (this.value) {
            case "xs:string": {
                return val;
            }
            case "xs:enum": 
            case "xs:integer": {
                return Integer.parseInt(val);
            }
            case "xs:float": {
                return Float.valueOf(Float.parseFloat(val));
            }
            case "xs:boolean": {
                return Boolean.parseBoolean(val);
            }
            case "xs:datetime": {
                return dateTimeFormat.parse(val);
            }
            case "xs:time": {
                return timeFormat.parse(val);
            }
            case "xs:date": {
                return dateFormat.parse(val);
            }
            case "xs:byte": {
                return Byte.parseByte(val);
            }
            case "xs:blob": {
                return val;
            }
            case "xs:uri": {
                return new URI(this.value);
            }
        }
        return null;
    }

    public String toString() {
        return this.clazz.getSimpleName().toLowerCase();
    }
}

